/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.module.iot.plugin;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.iocoder.yudao.module.iot.api.DeviceDataApi;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;

public class HttpHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final DeviceDataApi deviceDataApi;

    public HttpHandler(DeviceDataApi deviceDataApi) {
        this.deviceDataApi = deviceDataApi;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        JSONObject jsonData;
        boolean isCorrectPath;
        String uri = request.uri();
        String[] parts = uri.split("/");
        boolean bl = isCorrectPath = parts.length == 8 && "sys".equals(parts[1]) && "thing".equals(parts[4]) && "event".equals(parts[5]) && "property".equals(parts[6]) && "post".equals(parts[7]);
        if (!isCorrectPath) {
            this.writeResponse(ctx, HttpResponseStatus.NOT_FOUND, "Not Found");
            return;
        }
        String productKey = parts[2];
        String deviceName = parts[3];
        String requestBody = request.content().toString(CharsetUtil.UTF_8);
        try {
            jsonData = JSONUtil.parseObj((String)requestBody);
        }
        catch (Exception e) {
            JSONObject res = this.createResponseJson(400, new JSONObject(), null, "\u8bf7\u6c42\u6570\u636e\u4e0d\u662f\u5408\u6cd5\u7684 JSON \u683c\u5f0f: " + e.getMessage(), "thing.event.property.post", "1.0");
            this.writeResponse(ctx, HttpResponseStatus.BAD_REQUEST, res.toString());
            return;
        }
        String id = jsonData.getStr((Object)"id", null);
        try {
            this.deviceDataApi.saveDeviceData(productKey, deviceName, jsonData.toString());
            JSONObject successRes = this.createResponseJson(200, new JSONObject(), id, "success", "thing.event.property.post", "1.0");
            this.writeResponse(ctx, HttpResponseStatus.OK, successRes.toString());
        }
        catch (Exception e) {
            JSONObject errorRes = this.createResponseJson(500, new JSONObject(), id, "The format of result is error!", "thing.event.property.post", "1.0");
            this.writeResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, errorRes.toString());
        }
    }

    private JSONObject createResponseJson(int code, JSONObject data, String id, String message, String method, String version) {
        JSONObject res = new JSONObject();
        res.set("code", (Object)code);
        res.set("data", (Object)(data != null ? data : new JSONObject()));
        res.set("id", (Object)id);
        res.set("message", (Object)message);
        res.set("method", (Object)method);
        res.set("version", (Object)version);
        return res;
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpResponseStatus status, String content) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

