/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device;

import android.content.Context;
import com.zkteco.android.biometric.core.device.TransportDevice;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.device.bluetooth.BHTTransportDevice;
import com.zkteco.android.biometric.core.device.hhserialport.HHSerialPortTransportDevice;
import com.zkteco.android.biometric.core.device.serialport.SerialPortTransportDevice;
import com.zkteco.android.biometric.core.device.usb.USBTransportDevice;
import com.zkteco.android.biometric.core.device.usbhid.USBHIDTransportDevice;
import com.zkteco.android.biometric.core.device.usbmcu.USBMCUTransportDevice;
import com.zkteco.android.biometric.core.device.usbscsi.USBSCSITransportDevice;

public class TransportManager {
    public static TransportDevice createTransportDevice(Context context, TransportType transportType) {
        TransportDevice transportDevice = null;
        switch (transportType) {
            case USB: {
                transportDevice = new USBTransportDevice(context);
                break;
            }
            case BLUETOOTH: {
                transportDevice = new BHTTransportDevice(context);
                break;
            }
            case SERIALPORT: {
                transportDevice = new SerialPortTransportDevice(context);
                break;
            }
            case USBSCSI: {
                transportDevice = new USBSCSITransportDevice(context);
                break;
            }
            case HHSERIALPORT: {
                transportDevice = new HHSerialPortTransportDevice(context);
                break;
            }
            case USBHID: {
                transportDevice = new USBHIDTransportDevice(context);
                break;
            }
            case USBMCU: {
                transportDevice = new USBMCUTransportDevice(context);
                break;
            }
        }
        return transportDevice;
    }
}

