/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.module.fingerprintreader;

import com.zkteco.zkfinger.FingerprintService;
import com.zkteco.zkfinger.ZKFingerConfig;

public class ZKFingerService {
    private static boolean bInitialized = false;
    private static int fingerLimitCount = -1;
    public static final int LIC_TYPE_HARDWARE = 0;
    public static final int LIC_TYPE_HARDWARE2 = 1;
    public static final int LIC_TYPE_SENSOR = 2;
    public static final int LIC_TYPE_LIMIT = 3;

    public static void version(byte[] version) {
        FingerprintService.version(version);
    }

    public static int init() {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        if (bInitialized) {
            return 0;
        }
        int[] limit = new int[1];
        int ret = FingerprintService.init(limit);
        if (0 == ret) {
            fingerLimitCount = limit[0];
            bInitialized = true;
        }
        return ret;
    }

    public static int free() {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        int ret = 0;
        if (bInitialized) {
            ret = FingerprintService.close();
            bInitialized = false;
            fingerLimitCount = -1;
        }
        return ret;
    }

    public static int verify(byte[] temp1, byte[] temp2) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        int ret = FingerprintService.verify(temp1, temp2);
        return ret;
    }

    public static int verifyId(byte[] temp, String id) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        int ret = FingerprintService.verifyId(temp, id);
        return ret;
    }

    public static int identify(byte[] temp, byte[] idstr, int threshold, int count) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        int ret = FingerprintService.identify(temp, idstr, threshold, count);
        return ret;
    }

    public static int merge(byte[] temp1, byte[] temp2, byte[] temp3, byte[] temp) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        int ret = FingerprintService.merge(temp1, temp2, temp3, temp);
        return ret;
    }

    public static int save(byte[] temp, String id) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        int ret = FingerprintService.save(temp, id);
        return ret;
    }

    public static int get(byte[] temp, String id) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return FingerprintService.get(temp, id);
    }

    public static int del(String id) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        int ret = FingerprintService.del(id);
        return ret;
    }

    public static int clear() {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        int ret = FingerprintService.clear();
        return ret;
    }

    public static int count() {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        int ret = FingerprintService.count();
        return ret;
    }

    public static int extract(byte[] rawImage, int width, int height, byte[] temp, int[] quality) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        int ret = FingerprintService.extract(rawImage, width, height, temp, quality);
        return ret;
    }

    public static int setParameter(int optCode, int value) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return FingerprintService.setParameter(optCode, value);
    }

    public static int getTemplateQuality(byte[] temp) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return FingerprintService.getTemplateQuality(temp);
    }

    public static String getMachineCode() {
        if (ZKFingerConfig.isOnlyCapture()) {
            return "";
        }
        return FingerprintService.getMachineCode();
    }

    public static int getLicenseType() {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return FingerprintService.getLicenseType();
    }

    public static int convertTemplate(byte[] inTemp, byte[] outTemp) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return FingerprintService.convertTemplate(inTemp, outTemp);
    }

    public static int getTemplateLength(byte[] temp) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return FingerprintService.getTemplateLength(temp);
    }

    public static int getFPLimitCount() {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return fingerLimitCount;
    }
}

