/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.usbmcu;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import com.zkteco.android.biometric.core.utils.LogHelper;
import java.util.Map;

class USBMCUHandler {
    protected static final int USB_TYPE_STANDARD = 0;
    protected static final int USB_TYPE_CLASS = 32;
    protected static final int USB_TYPE_VENDOR = 64;
    protected static final int USB_TYPE_RESERVED = 96;
    protected static final int USB_RECIP_DEVICE = 0;
    protected static final int USB_RECIP_INTERFACE = 1;
    protected static final int USB_RECIP_ENDPOINT = 2;
    protected static final int USB_RECIP_OTHER = 3;
    private static final int DEFAULT_DEVICE_INDEX = -1;
    private static UsbManager usbManager = null;
    private static Map<String, UsbDevice> usbDeviceList = null;
    private static int currentDeviceIndex = -1;
    private Context context = null;
    private UsbDeviceConnection usbDeviceConnection = null;
    private UsbEndpoint[] inEndpoint = null;
    private UsbEndpoint[] outEndpoint = null;
    private String strSerialNumber = "";
    private int nPid = 0;
    private int nVID = 0;
    private int nFd = 0;
    private int nInEndPoint = 0;
    private int nOutEndpoint = 0;
    private UsbInterface mUsbInterface = null;

    public USBMCUHandler(Context context) {
        this.context = context;
    }

    public static void reset() {
        currentDeviceIndex = -1;
        usbDeviceList = null;
        usbManager = null;
    }

    public void setUsbConnectionConfig(int vid, int pid, int fd, int inEndPoint, int outEndpoint) {
        this.nPid = pid;
        this.nVID = vid;
        this.nFd = fd;
        this.nInEndPoint = inEndPoint;
        this.nOutEndpoint = outEndpoint;
    }

    public void getUsbConnectionConfig(int[] vid, int[] pid, int[] fd, int[] inEndpoint, int[] outEndpoint) {
        if (null == vid || null == pid || null == fd || null == inEndpoint || null == outEndpoint) {
            return;
        }
        vid[0] = this.nVID;
        pid[0] = this.nPid;
        fd[0] = this.nFd;
        inEndpoint[0] = this.nInEndPoint;
        outEndpoint[0] = this.nOutEndpoint;
    }

    public static int getCurrentDeviceIndex() {
        return currentDeviceIndex;
    }

    public static void setCurrentDeviceIndex(int currentDeviceIndex) {
        USBMCUHandler.currentDeviceIndex = currentDeviceIndex;
    }

    public static UsbManager getUsbManager(Context context) {
        if (usbManager == null) {
            usbManager = (UsbManager)context.getSystemService("usb");
        }
        return usbManager;
    }

    public static Map<String, UsbDevice> getUSBDeviceList(Context context) {
        if (USBMCUHandler.getUsbManager(context) != null) {
            usbDeviceList = usbManager.getDeviceList();
        } else {
            LogHelper.e("Get USBDeviceList failed because of USBManager is null!");
        }
        return usbDeviceList;
    }

    public UsbDeviceConnection getUsbDeviceConnection() {
        return this.usbDeviceConnection;
    }

    public void setUsbDeviceConnection(UsbDeviceConnection usbDeviceConnection) {
        this.usbDeviceConnection = usbDeviceConnection;
    }

    public void setUsbInterface(UsbInterface usbInterface) {
        this.mUsbInterface = usbInterface;
    }

    public UsbEndpoint getInEndpoint(int index) {
        return this.inEndpoint[index];
    }

    public void setInEndpoint(UsbEndpoint[] inEndpoint) {
        this.inEndpoint = inEndpoint;
    }

    public UsbEndpoint getOutEndpoint(int index) {
        return this.outEndpoint[index];
    }

    public void setOutEndpoint(UsbEndpoint[] outEndpoint) {
        this.outEndpoint = outEndpoint;
    }

    public void setStrSerialNumber(String serialNumber) {
        if (null != serialNumber) {
            this.strSerialNumber = serialNumber;
        }
    }

    public String getStrSerialNumber() {
        return this.strSerialNumber;
    }

    public int control(int requestType, int request, int value, int index, byte[] buffer, int length, int timeout) {
        if (null == this.usbDeviceConnection) {
            return -1;
        }
        return this.usbDeviceConnection.controlTransfer(requestType, request, value, index, buffer, length, timeout);
    }

    public int control(byte[] buffer, int length, int timeout) {
        return this.control(64, 250, 0, 0, buffer, length, timeout);
    }

    public int read(byte[] buffer, int length, int timeout) {
        if (null == this.inEndpoint || this.inEndpoint.length <= 0 || null == this.usbDeviceConnection) {
            LogHelper.d("no inEndpoint");
            return -1;
        }
        return this.usbDeviceConnection.bulkTransfer(this.inEndpoint[0], buffer, length, timeout);
    }

    public int write(byte[] buffer, int length, int timeout) {
        if (null == this.outEndpoint || this.outEndpoint.length <= 0 || null == this.usbDeviceConnection) {
            LogHelper.d("no outEndpoint");
            return -1;
        }
        int ret1 = this.usbDeviceConnection.bulkTransfer(this.outEndpoint[0], buffer, length, timeout);
        int ret2 = 0;
        if (null != this.outEndpoint[1]) {
            LogHelper.d("have 2 outEndpoint");
            ret2 = this.usbDeviceConnection.bulkTransfer(this.outEndpoint[1], buffer, length, timeout);
        }
        return ret1 > 0 ? ret1 : ret2;
    }

    public void close() {
        if (null != this.usbDeviceConnection) {
            if (null != this.mUsbInterface) {
                this.usbDeviceConnection.releaseInterface(this.mUsbInterface);
            }
            this.mUsbInterface = null;
            this.usbDeviceConnection.close();
            this.usbDeviceConnection = null;
        }
    }
}

