/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.api.cls;

import com.uhf.api.cls.BackReadOption;
import com.uhf.api.cls.ErrInfo;
import com.uhf.api.cls.GPITrigger;
import com.uhf.api.cls.GpiInfo_ST;
import com.uhf.api.cls.GpiTriggerBoundaryListener;
import com.uhf.api.cls.GpiTriggerBoundaryReasonType;
import com.uhf.api.cls.GpiTriggerBoundaryType;
import com.uhf.api.cls.GpiTriggerListener;
import com.uhf.api.cls.GpiTrigger_Type;
import com.uhf.api.cls.IMPINJ_FASTPARMS;
import com.uhf.api.cls.InvEmbeddedBankData;
import com.uhf.api.cls.JniModuleAPI;
import com.uhf.api.cls.LogFile_C;
import com.uhf.api.cls.MODUSPARMS;
import com.uhf.api.cls.R2000_calibration;
import com.uhf.api.cls.ReadExceptionListener;
import com.uhf.api.cls.ReadListener;
import com.uhf.api.cls.SpecialSensorTag;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Reader {
    public static final int MAXANTCNT = 16;
    public static final int MAXIPSTRLEN = 50;
    public static final int HOPTABLECNT = 100;
    public static final int MAXEPCBYTESCNT = 62;
    public static final int MAXEMBDATALEN = 128;
    public static final int MAXINVPOTLSCNT = 6;
    public static boolean isDebug = false;
    public static boolean isLogfile = false;
    private LogFile_C Logf = null;
    private String Mark = "";
    private final int JniBytesBufferLength = 500;
    JniModuleAPI japi;
    int[] hReader;
    int m_gError;
    String address;
    int port;
    Thread m_ThreadForAll;
    long m_ThreadForAllid;
    boolean m_IsReadingForAll;
    boolean m_IsReadThRunning;
    BackReadOption m_BackReadOp;
    int m_FastReadOption;
    int[] m_BackReadAnts = new int[16];
    int m_BackReadAntsCnt;
    protected List<ReadListener> readListeners;
    protected List<ReadExceptionListener> readExceptionListeners;
    protected List<GpiTriggerListener> gpitriListener;
    protected List<GpiTriggerBoundaryListener> gpitriboundListener;
    protected int IT_CT_m1_keep = 15;
    protected int IT_CT_m1_toma = 5;
    protected int IT_CT_m1_cycle = 1000;
    protected int IT_CT_m2_keepcount = 10;
    protected int IT_CT_m2_cycle = 500;
    protected int IT_CT_m2_toma = 20;
    protected int IT_CT_m2_tomc = 10;
    protected int IT_CT_m3_cycleread = 300;
    protected int IT_CT_m3_cyclestop = 200;
    protected int IT_CT_m3_toma = 1;
    boolean isIT_CT_run;
    protected final int IT_CT_M1_STEP1 = 0;
    final int IT_CT_M1_STEP2 = 1;
    final int IT_CT_M2_STEP1 = 2;
    final int IT_CT_M2_STEP2 = 3;
    final int IT_CT_M3 = 4;
    protected final int IT_CT_M1_TESTFORDJ_STEP1 = 5;
    final int IT_CT_M1_TESTFORDJ_STEP2 = 6;
    long IT_CT_start;
    int IT_CT_step;
    protected int IT_CT_step_init = 0;
    int IT_CT_c;
    int totalcountlast = 0;
    int totalcount;
    long vstaticstarttick;
    Thread IT_CT_thread;
    IT_MODE it_mode_V;
    Thread IT_S2_thread;
    boolean isIT_S2_run;
    long IT_S2_start;
    int IT_S2_step;
    boolean IT_S2_istargetA;
    protected final int IT_S2_M1_STEP1 = 0;
    final int IT_S2_M1_STEP2 = 1;
    protected int IT_S2_m1_cycle = 500;
    protected int IT_S2_ctagcount = 50;
    protected int IT_S2_m1_cycle2 = 100;
    protected int IT_S2_ctagcount2 = 2;
    Thread IT_E7_thread;
    boolean isIT_E7_run;
    long IT_E7_start;
    int IT_E7_step;
    boolean IT_E7_istargetA;
    protected final int IT_E7_M1_STEP1 = 0;
    final int IT_E7_M1_STEP2 = 1;
    final int IT_E7_M1_STEP3 = 2;
    final int IT_E7_M1_STEP4 = 3;
    final int IT_E7_M1_STEP5 = 4;
    protected int IT_E7_rfm = 101;
    protected int IT_E7_m1_cycle = 500;
    protected int IT_E7_ctagcount = 50;
    protected int IT_E7_m1_cycle2 = 100;
    protected int IT_E7_ctagcount2 = 2;
    protected int IT_E7_m1_cycle3 = 70;
    protected int IT_E7_ctagcount3 = 1;
    Region_Conf IT_E7_rg;
    int IT_E7_centrefre = 915250;
    int IT_E7_lowfre = 902250;
    int IT_E7_highfre = 927250;
    int IT_E7_pow = 3300;
    int IT_AutoRe_time = 3000;
    int IT_AutoRe_count = 200;
    int unitms = 1000;
    List<Integer> lastcount = new ArrayList<Integer>();
    int isExfastmode = 0;
    int[] pants;
    int pantcnt;
    int poption;
    Lock lockobj_newadd = new ReentrantLock();
    Vector<String> quetagstr = new Vector();
    int[] IT_CT_fres_NA = new int[]{915750, 927250, 902750, 914250, 925250, 904750, 916250, 926750, 903250, 913250, 921250, 906250, 917250, 924250, 905750, 915250, 923750, 907750, 919250, 926250, 908750, 910250, 922750, 912250};
    int[] IT_CT_fres_cn = new int[]{922625, 924375, 920625, 922375, 924125, 920875, 922875, 923875, 921125, 922125, 923625, 921375, 923375, 921875, 923125, 921625};
    boolean isfilterpw = false;
    AntPowerConf setpower;

    public String CurTimeMis() {
        Date currentDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS");
        String currentTime = sdf.format(currentDate);
        return currentTime;
    }

    public void toAddDlogAPI(String mess) {
        this.toDlogAPI(mess);
    }

    private void toDlogEX(Exception ex, Object cls) {
        if (isDebug) {
            LogFile_C.DEBUG(ex, cls);
        }
        if (isLogfile) {
            if (this.Logf == null) {
                this.Logf = new LogFile_C();
                this.Logf.Init(this.CurTimeMis() + "  " + this.GetReaderAddress());
            }
            this.Logf.LOGLINE(ex, cls);
        }
    }

    private void toDlogAPI(String mess) {
        if (isDebug) {
            LogFile_C.DEBUG(mess, this.CurTimeMis() + "  " + this.GetReaderAddress() + " ModuleAPI:", "ModuleAPI");
        }
        if (isLogfile) {
            if (this.Logf == null) {
                this.Logf = new LogFile_C();
                this.Logf.Init(mess);
            }
            this.Logf.LOGLINE(this.CurTimeMis() + "\t" + this.GetReaderAddress() + " ModuleAPI:" + mess);
        }
    }

    private void toCloseDlog() {
        if (isLogfile && this.Logf != null) {
            this.Logf.CloseLogFile();
        }
    }

    private void toDlog(String mess) {
        if (isDebug) {
            LogFile_C.DEBUG(mess, this.CurTimeMis() + "  " + this.GetReaderAddress() + " MYINFO:", "MYINFO");
        }
        if (isLogfile) {
            if (this.Logf == null) {
                this.Logf = new LogFile_C();
                this.Logf.Init(mess);
            }
            this.Logf.LOGLINE(mess);
        }
    }

    public boolean Set_IT_Params(IT_MODE it_mode, Object[] objs) throws Exception {
        if (it_mode == IT_MODE.IT_MODE_CT || it_mode == IT_MODE.IT_MODE_E7CT || it_mode == IT_MODE.IT_MODE_E7StopP) {
            try {
                int p = 0;
                this.IT_CT_m1_keep = (Integer)objs[p++];
                this.IT_CT_m1_toma = (Integer)objs[p++];
                this.IT_CT_m3_cycleread = (Integer)objs[p++];
                this.IT_CT_m3_cyclestop = (Integer)objs[p++];
                this.IT_CT_m3_toma = (Integer)objs[p++];
            }
            catch (Exception ex) {
                throw new Exception("check paramters Length and data type must be Integer.");
            }
            return true;
        }
        if (it_mode == IT_MODE.IT_MODE_S2) {
            try {
                int p = 0;
                this.IT_S2_m1_cycle = (Integer)objs[p++];
                this.IT_S2_ctagcount = (Integer)objs[p++];
                this.IT_S2_m1_cycle2 = (Integer)objs[p++];
                this.IT_S2_ctagcount2 = (Integer)objs[p++];
            }
            catch (Exception ex) {
                throw new Exception("Length must be 4 and type must be Integer.");
            }
            return true;
        }
        if (it_mode == IT_MODE.IT_MODE_E7 || it_mode == IT_MODE.IT_MODE_E7v2) {
            try {
                int p = 0;
                this.IT_E7_m1_cycle = (Integer)objs[p++];
                this.IT_E7_ctagcount = (Integer)objs[p++];
                this.IT_E7_m1_cycle2 = (Integer)objs[p++];
                this.IT_E7_ctagcount2 = (Integer)objs[p++];
                this.IT_E7_rfm = (Integer)objs[p++];
            }
            catch (Exception ex) {
                throw new Exception("Length must be 4 and type must be Integer.");
            }
            return true;
        }
        if (it_mode == IT_MODE.IT_MODE_E7AutoRe) {
            try {
                int p = 0;
                this.IT_AutoRe_time = (Integer)objs[p++];
                this.IT_AutoRe_count = (Integer)objs[p++];
            }
            catch (Exception ex) {
                throw new Exception("Length must be 2 and type must be Integer.");
            }
            return true;
        }
        return false;
    }

    public void Setdutycycle(int option) {
        if (option < 0 || option > 11) {
            return;
        }
        this.IT_CT_m3_cyclestop = (int)((double)option * 0.05 * 500.0);
        this.IT_CT_m3_cycleread = 500 - this.IT_CT_m3_cyclestop;
    }

    public Reader() {
        this.hReader = new int[1];
        this.japi = new JniModuleAPI();
        this.readListeners = new Vector<ReadListener>();
        this.readExceptionListeners = new Vector<ReadExceptionListener>();
        this.gpitriListener = new Vector<GpiTriggerListener>();
        this.gpitriboundListener = new Vector<GpiTriggerBoundaryListener>();
        this.toDlog("Reader_" + String.valueOf(this.hashCode()));
    }

    public void Hex2Str(byte[] buf, int len, char[] out) {
        char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i < len; ++i) {
            out[i * 2] = hexc[(buf[i] & 0xFF) / 16];
            if (i * 2 + 1 >= out.length) continue;
            out[i * 2 + 1] = hexc[(buf[i] & 0xFF) % 16];
        }
    }

    private char[] bytestochars(byte[] bdata) {
        char[] cdata = new char[bdata.length];
        for (int i = 0; i < bdata.length; ++i) {
            cdata[i] = (char)bdata[i];
        }
        return cdata;
    }

    private byte[] charstobytes(char[] cdata) {
        int i;
        if (cdata == null) {
            return null;
        }
        int len = 0;
        for (i = 0; i < cdata.length && cdata[i] != '\u0000'; ++i) {
            ++len;
        }
        byte[] bdata = new byte[len];
        for (i = 0; i < len; ++i) {
            bdata[i] = (byte)cdata[i];
        }
        return bdata;
    }

    public READER_ERR InitReader(String src, Reader_Type rtype) {
        int re = this.japi.InitReader(this.hReader, src, rtype.value());
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR InitReader_Notype(String src, int antscnt) {
        this.toDlogAPI("InitReader_Notype-" + src + " " + String.valueOf(antscnt));
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.InitReader_Notype(this.hReader, src, antscnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                this.address = src;
                this.port = antscnt;
                Inv_Potls_ST ipst = new Inv_Potls_ST();
                ipst.potlcnt = 1;
                ipst.potls = new Inv_Potl[1];
                ipst.potls[0] = new Inv_Potl();
                ipst.potls[0].weight = 30;
                ipst.potls[0].potl = SL_TagProtocol.SL_TAG_PROTOCOL_GEN2;
                this.ParamSet(Mtr_Param.MTR_PARAM_TAG_INVPOTL, ipst);
                String powermsg = "";
                AntPowerConf apcf2 = new AntPowerConf();
                this.ParamGet(Mtr_Param.MTR_PARAM_RF_ANTPOWER, apcf2);
                for (int i = 0; i < apcf2.antcnt; ++i) {
                    powermsg = powermsg + "antid:" + apcf2.Powers[i].antid;
                    powermsg = powermsg + " rp:" + apcf2.Powers[i].readPower;
                    powermsg = powermsg + " wp:" + apcf2.Powers[i].writePower;
                }
                this.toDlogAPI("InitReader_Notype >>>" + src + " " + powermsg);
                this.readListeners.clear();
                this.readExceptionListeners.clear();
                this.gpitriListener.clear();
                this.gpitriboundListener.clear();
            } else {
                this.hReader[0] = 0;
            }
            return ERR;
        }
    }

    public String GetReaderAddress() {
        return this.address == null ? "" : this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetHardwareDetails(HardwareDetails val) {
        Reader reader = this;
        synchronized (reader) {
            byte[] data = new byte[500];
            int re = this.japi.GetHardwareDetails_BaseType(this.hReader[0], data);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                val.module = Module_Type.valueOf(data[0]);
                switch (data[1]) {
                    case 0: {
                        val.board = MaindBoard_Type.MAINBOARD_NONE;
                        break;
                    }
                    case 1: {
                        val.board = MaindBoard_Type.MAINBOARD_ARM7;
                        break;
                    }
                    case 2: {
                        val.board = MaindBoard_Type.MAINBOARD_SERIAL;
                        break;
                    }
                    case 3: {
                        val.board = MaindBoard_Type.MAINBOARD_WIFI;
                        break;
                    }
                    case 4: {
                        val.board = MaindBoard_Type.MAINBOARD_ARM9;
                        break;
                    }
                    case 5: {
                        val.board = MaindBoard_Type.MAINBOARD_ARM9_WIFI;
                    }
                }
                val.logictype = Reader_Type.valueOf(data[2]);
                val.antportnumbers = this.port;
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CloseReader() {
        this.toDlogAPI("CloseReader-");
        Reader reader = this;
        synchronized (reader) {
            this.japi.CloseReader(this.hReader[0]);
            this.address = "";
            this.hReader[0] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetTagData(int ant, char bank, int address, int blkcnt, byte[] data, byte[] accesspasswd, short timeout) {
        this.toDlogAPI("GetTagData-" + String.valueOf(ant) + " " + String.valueOf(bank) + " " + String.valueOf(address) + " " + String.valueOf(blkcnt));
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.GetTagData(this.hReader[0], ant, bank, address, blkcnt, data, accesspasswd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR WriteTagData(int ant, char bank, int address, byte[] data, int datalen, byte[] accesspasswd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.WriteTagData(this.hReader[0], ant, bank, address, data, datalen, accesspasswd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR WriteTagEpcEx(int ant, byte[] Epc, int epclen, byte[] accesspwd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.WriteTagEpcEx(this.hReader[0], ant, Epc, epclen, accesspwd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR TagInventory(int[] ants, int antcnt, short timeout, TAGINFO[] pTInfo, int[] tagcnt) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.TagInventory_Raw(this.hReader[0], ants, antcnt, timeout, tagcnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                for (int i = 0; i < tagcnt[0]; ++i) {
                    TAGINFO pTInfoa = new TAGINFO();
                    READER_ERR er = this.GetNextTag(pTInfoa);
                    if (er != READER_ERR.MT_OK_ERR) continue;
                    pTInfo[i] = pTInfoa;
                }
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR TagInventory_Raw(int[] ants, int antcnt, short timeout, int[] tagcnt) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.TagInventory_Raw(this.hReader[0], ants, antcnt, timeout, tagcnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR TagInventory_Single(int[] ants, int antcnt, short timeout, int[] tagcnt, TAGINFO TI) {
        EmbededData_ST edst2 = new EmbededData_ST();
        READER_ERR err = this.ParamGet(Mtr_Param.MTR_PARAM_TAG_EMBEDEDDATA, edst2);
        boolean isemd = false;
        if (err == READER_ERR.MT_OK_ERR && edst2 != null && edst2.bytecnt != 0) {
            isemd = true;
        }
        Reader reader = this;
        synchronized (reader) {
            long st = System.currentTimeMillis();
            READER_ERR ERR = READER_ERR.MT_OK_ERR;
            boolean isbreak = false;
            while (true) {
                int re;
                if (((ERR = READER_ERR.valueOf(re = this.japi.TagInventory_Raw(this.hReader[0], ants, antcnt, (short)20, tagcnt))) != READER_ERR.MT_OK_ERR || tagcnt[0] <= 0) && System.currentTimeMillis() - st < (long)timeout) {
                    continue;
                }
                if (ERR == READER_ERR.MT_OK_ERR) {
                    for (int i = 0; i < tagcnt[0]; ++i) {
                        TAGINFO pTInfoa = new TAGINFO();
                        READER_ERR er = this.GetNextTag(pTInfoa);
                        if (er != READER_ERR.MT_OK_ERR) continue;
                        if (isemd) {
                            if (pTInfoa.EmbededDatalen <= 0) continue;
                            TI.ReadCnt = pTInfoa.ReadCnt;
                            TI.RSSI = pTInfoa.RSSI;
                            TI.AntennaID = pTInfoa.AntennaID;
                            TI.Frequency = pTInfoa.Frequency;
                            TI.TimeStamp = pTInfoa.TimeStamp;
                            System.arraycopy(pTInfoa.PC, 0, TI.PC, 0, 2);
                            System.arraycopy(pTInfoa.PC, 0, TI.PC, 0, 2);
                            TI.EpcId = new byte[pTInfoa.Epclen];
                            TI.Epclen = pTInfoa.Epclen;
                            System.arraycopy(pTInfoa.EpcId, 0, TI.EpcId, 0, TI.Epclen);
                            System.arraycopy(pTInfoa.CRC, 0, TI.CRC, 0, 2);
                            TI.EmbededData = new byte[pTInfoa.EmbededDatalen];
                            TI.EmbededDatalen = pTInfoa.EmbededDatalen;
                            System.arraycopy(pTInfoa.EmbededData, 0, TI.EmbededData, 0, TI.EmbededDatalen);
                            tagcnt[0] = 1;
                            isbreak = true;
                            break;
                        }
                        TI.ReadCnt = pTInfoa.ReadCnt;
                        TI.RSSI = pTInfoa.RSSI;
                        TI.AntennaID = pTInfoa.AntennaID;
                        TI.Frequency = pTInfoa.Frequency;
                        TI.TimeStamp = pTInfoa.TimeStamp;
                        System.arraycopy(pTInfoa.PC, 0, TI.PC, 0, 2);
                        System.arraycopy(pTInfoa.PC, 0, TI.PC, 0, 2);
                        TI.EpcId = new byte[pTInfoa.Epclen];
                        TI.Epclen = pTInfoa.Epclen;
                        System.arraycopy(pTInfoa.EpcId, 0, TI.EpcId, 0, TI.Epclen);
                        System.arraycopy(pTInfoa.CRC, 0, TI.CRC, 0, 2);
                        TI.EmbededData = new byte[pTInfoa.EmbededDatalen];
                        TI.EmbededDatalen = pTInfoa.EmbededDatalen;
                        if (pTInfoa.EmbededDatalen > 0) {
                            System.arraycopy(pTInfoa.EmbededData, 0, TI.EmbededData, 0, TI.EmbededDatalen);
                        }
                        tagcnt[0] = 1;
                        isbreak = true;
                        break;
                    }
                }
                if (isbreak || System.currentTimeMillis() - st >= (long)timeout) break;
            }
            if (!isbreak) {
                tagcnt[0] = 0;
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR TagInventory_BaseType(int[] ants, int antcnt, short timeout, byte[] outbuf, int[] tagcnt) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.TagInventory_BaseType(this.hReader[0], ants, antcnt, timeout, outbuf, tagcnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetNextTag(TAGINFO TI) {
        Reader reader = this;
        synchronized (reader) {
            byte[] tagbuf = new byte[230];
            int pos = 0;
            int re = this.japi.GetNextTag_BaseType(this.hReader[0], tagbuf);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                TI.ReadCnt = tagbuf[pos++] & 0xFF;
                TI.RSSI = tagbuf[pos++];
                TI.AntennaID = tagbuf[pos++];
                TI.Frequency = (tagbuf[pos] & 0xFF) << 24 | (tagbuf[pos + 1] & 0xFF) << 16 | (tagbuf[pos + 2] & 0xFF) << 8 | tagbuf[pos + 3] & 0xFF;
                TI.TimeStamp = (tagbuf[pos += 4] & 0xFF) << 24 | (tagbuf[pos + 1] & 0xFF) << 16 | (tagbuf[pos + 2] & 0xFF) << 8 | tagbuf[pos + 3] & 0xFF;
                pos += 4;
                TI.Res[0] = tagbuf[pos++];
                TI.Res[1] = tagbuf[pos++];
                TI.protocol = SL_TagProtocol.valueOf(tagbuf[pos++]);
                int epclen = tagbuf[pos] << 8 | tagbuf[pos + 1];
                pos += 2;
                TI.PC[0] = tagbuf[pos++];
                TI.PC[1] = tagbuf[pos++];
                TI.EpcId = new byte[epclen];
                TI.Epclen = (short)epclen;
                System.arraycopy(tagbuf, pos, TI.EpcId, 0, epclen);
                pos += epclen;
                TI.CRC[0] = tagbuf[pos++];
                TI.CRC[1] = tagbuf[pos++];
                int emddatalen = tagbuf[pos] << 8 | tagbuf[pos + 1];
                pos += 2;
                TI.EmbededData = new byte[emddatalen];
                TI.EmbededDatalen = (short)emddatalen;
                if (emddatalen > 0) {
                    System.arraycopy(tagbuf, pos, TI.EmbededData, 0, emddatalen);
                }
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetNextTag_BaseType(byte[] outbuf) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.GetNextTag_BaseType(this.hReader[0], outbuf);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR LockTag(int ant, byte lockobjects, short locktypes, byte[] accesspasswd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.LockTag(this.hReader[0], ant, lockobjects, locktypes, accesspasswd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR KillTag(int ant, byte[] killpasswd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.KillTag(this.hReader[0], ant, killpasswd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR Lock180006BTag(int ant, int startblk, int blkcnt, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.Lock180006BTag(this.hReader[0], ant, startblk, blkcnt, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR BlockPermaLock(int ant, int readlock, int startblk, int blkrange, byte[] mask, byte[] pwd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.BlockPermaLock(this.hReader[0], ant, readlock, startblk, blkrange, mask, pwd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR BlockErase(int ant, int bank, int wordaddr, int wordcnt, byte[] pwd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.BlockErase(this.hReader[0], ant, bank, wordaddr, wordcnt, pwd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR EraseDataOnReader() {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.EraseDataOnReader(this.hReader[0]);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR SaveDataOnReader(int address, byte[] data, int datalen) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.SaveDataOnReader(this.hReader[0], address, data, datalen);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ReadDataOnReader(int address, byte[] data, int datalen) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.ReadDataOnReader(this.hReader[0], address, data, datalen);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR CustomCmd(int ant, CustomCmdType cmdtype, Object CustomPara, Object CustomRet) {
        Reader reader = this;
        synchronized (reader) {
            byte[] para = null;
            byte[] ret = null;
            switch (cmdtype) {
                case IMPINJ_M4_Qt: {
                    Object CustomPara2 = (IMPINJM4QtPara)CustomPara;
                    para = new byte[22];
                    ret = new byte[10];
                    System.arraycopy(((IMPINJM4QtPara)CustomPara2).AccessPwd, 0, para, 0, 4);
                    para[4] = (byte)((((IMPINJM4QtPara)CustomPara2).CmdType & 0xFF000000) >> 24);
                    para[5] = (byte)((((IMPINJM4QtPara)CustomPara2).CmdType & 0xFF0000) >> 16);
                    para[6] = (byte)((((IMPINJM4QtPara)CustomPara2).CmdType & 0xFF00) >> 8);
                    para[7] = (byte)(((IMPINJM4QtPara)CustomPara2).CmdType & 0xFF);
                    para[8] = (byte)((((IMPINJM4QtPara)CustomPara2).MemType & 0xFF000000) >> 24);
                    para[9] = (byte)((((IMPINJM4QtPara)CustomPara2).MemType & 0xFF0000) >> 16);
                    para[10] = (byte)((((IMPINJM4QtPara)CustomPara2).MemType & 0xFF00) >> 8);
                    para[11] = (byte)(((IMPINJM4QtPara)CustomPara2).MemType & 0xFF);
                    para[12] = (byte)((((IMPINJM4QtPara)CustomPara2).PersistType & 0xFF000000) >> 24);
                    para[13] = (byte)((((IMPINJM4QtPara)CustomPara2).PersistType & 0xFF0000) >> 16);
                    para[14] = (byte)((((IMPINJM4QtPara)CustomPara2).PersistType & 0xFF00) >> 8);
                    para[15] = (byte)(((IMPINJM4QtPara)CustomPara2).PersistType & 0xFF);
                    para[16] = (byte)((((IMPINJM4QtPara)CustomPara2).RangeType & 0xFF000000) >> 24);
                    para[17] = (byte)((((IMPINJM4QtPara)CustomPara2).RangeType & 0xFF0000) >> 16);
                    para[18] = (byte)((((IMPINJM4QtPara)CustomPara2).RangeType & 0xFF00) >> 8);
                    para[19] = (byte)(((IMPINJM4QtPara)CustomPara2).RangeType & 0xFF);
                    para[20] = (byte)((((IMPINJM4QtPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                    para[21] = (byte)(((IMPINJM4QtPara)CustomPara2).TimeOut & 0xFF);
                    break;
                }
                case ALIEN_Higgs3_BlockReadLock: {
                    para = new byte[7];
                    ret = new byte[7];
                    Object CustomPara2 = (ALIENHiggs3BlockReadLockPara)CustomPara;
                    System.arraycopy(((ALIENHiggs3BlockReadLockPara)CustomPara2).AccessPwd, 0, para, 0, 4);
                    para[4] = ((ALIENHiggs3BlockReadLockPara)CustomPara2).BlkBits;
                    para[5] = (byte)((((ALIENHiggs3BlockReadLockPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                    para[6] = (byte)(((ALIENHiggs3BlockReadLockPara)CustomPara2).TimeOut & 0xFF);
                    break;
                }
                case NXP_ChangeEAS: {
                    para = new byte[7];
                    ret = new byte[7];
                    Object CustomPara2 = (NXPChangeEASPara)CustomPara;
                    System.arraycopy(((NXPChangeEASPara)CustomPara2).AccessPwd, 0, para, 0, 4);
                    para[4] = (byte)((NXPChangeEASPara)CustomPara2).isSet;
                    para[5] = (byte)((((NXPChangeEASPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                    para[6] = (byte)(((NXPChangeEASPara)CustomPara2).TimeOut & 0xFF);
                    break;
                }
                case NXP_EASAlarm: {
                    para = new byte[5];
                    ret = new byte[5];
                    Object CustomPara2 = (NXPEASAlarmPara)CustomPara;
                    para[0] = ((NXPEASAlarmPara)CustomPara2).DR;
                    ((NXPEASAlarmPara)CustomPara2).MC = (byte)11;
                    para[1] = 11;
                    para[2] = ((NXPEASAlarmPara)CustomPara2).TrExt;
                    para[3] = (byte)((((NXPEASAlarmPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                    para[4] = (byte)(((NXPEASAlarmPara)CustomPara2).TimeOut & 0xFF);
                    break;
                }
                case NXP_U8_InventoryMode: {
                    NXP_U8_InventoryModePara ctpara = (NXP_U8_InventoryModePara)CustomPara;
                    para = ctpara.Mode;
                    ret = new byte[1];
                    break;
                }
                default: {
                    return READER_ERR.MT_OP_NOT_SUPPORTED;
                }
            }
            int re = this.japi.CustomCmd_BaseType(this.hReader[0], ant, cmdtype.value(), para, ret);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR CustomCmd_BaseType(int ant, int cmdtype, byte[] CustomPara, byte[] CustomRet) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.CustomCmd_BaseType(this.hReader[0], ant, cmdtype, CustomPara, CustomRet);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR SetGPO(int gpoid, int val) {
        Reader reader = this;
        synchronized (reader) {
            this.toDlogAPI("SetGPO gpoid:" + gpoid + " val:" + val);
            int re = this.japi.SetGPO(this.hReader[0], gpoid, val);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetGPI(int gpoid, int[] val) {
        Reader reader = this;
        synchronized (reader) {
            this.toDlogAPI("GetGPI gpoid:" + gpoid + " val:" + val);
            int re = this.japi.GetGPI(this.hReader[0], gpoid, val);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetGPIEx(GpiInfo_ST gpist) {
        Reader reader = this;
        synchronized (reader) {
            this.toDlogAPI("GetGPIEx");
            byte[] gpibytes = new byte[500];
            int re = this.japi.GetGPIEx_BaseType(this.hReader[0], gpibytes);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                gpist.gpiCount = gpibytes[0];
                for (int i = 0; i < gpist.gpiCount; ++i) {
                    gpist.gpiStats[i].GpiId = gpibytes[1 + 2 * i];
                    gpist.gpiStats[i].State = gpibytes[2 + 2 * i];
                }
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR PsamTransceiver(int soltid, int coslen, byte[] cos, int[] cosresplen, byte[] cosresp, byte[] errcode, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.PsamTransceiver(this.hReader[0], soltid, coslen, cos, cosresplen, cosresp, errcode, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    private int GetIntFrByteArray(byte[] byarray, int offset) {
        return (byarray[offset] & 0xFF) << 24 | (byarray[offset + 1] & 0xFF) << 16 | (byarray[offset + 2] & 0xFF) << 8 | byarray[offset + 3] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ParamGet(Mtr_Param key, Object val) {
        this.toDlogAPI("ParamGet " + key.toString());
        Reader reader = this;
        synchronized (reader) {
            int re = -1;
            byte[] data = new byte[500];
            switch (key) {
                case MTR_PARAM_RF_ANTPOWER: {
                    int i;
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    String powermsg = String.valueOf(data[0]) + ":";
                    ((AntPowerConf)val).antcnt = data[0];
                    for (i = 0; i < data[0]; ++i) {
                        AntPower apcf = new AntPower();
                        apcf.antid = data[i * 5 + 1];
                        powermsg = powermsg + String.valueOf(apcf.antid) + ",";
                        apcf.readPower = (short)(data[i * 5 + 2] << 8 | data[i * 5 + 3] & 0xFF);
                        powermsg = powermsg + String.valueOf(apcf.readPower) + ",";
                        apcf.writePower = (short)(data[i * 5 + 4] << 8 | data[i * 5 + 5] & 0xFF);
                        powermsg = powermsg + String.valueOf(apcf.readPower) + ";";
                        ((AntPowerConf)val).Powers[i] = apcf;
                    }
                    this.toDlogAPI("ParamGet " + key.toString() + " " + powermsg);
                    if (!this.isfilterpw || this.setpower == null) break;
                    ((AntPowerConf)val).antcnt = this.setpower.antcnt;
                    for (i = 0; i < this.setpower.antcnt; ++i) {
                        ((AntPowerConf)val).Powers[i].writePower = this.setpower.Powers[i].writePower;
                        ((AntPowerConf)val).Powers[i].readPower = this.setpower.Powers[i].readPower;
                    }
                    break;
                }
                case MTR_PARAM_TAG_FILTER: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((TagFilter_ST)val).bank = data[0];
                    ((TagFilter_ST)val).startaddr = (data[1] & 0xFF) << 24 | data[2] << 16 | data[3] << 8 | data[4] & 0xFF;
                    ((TagFilter_ST)val).flen = data[5] << 24 | data[6] << 16 | data[7] << 8 | data[8] & 0xFF;
                    int ilen = ((TagFilter_ST)val).flen / 8;
                    if (((TagFilter_ST)val).flen % 8 != 0) {
                        ++ilen;
                    }
                    System.arraycopy(data, 9, ((TagFilter_ST)val).fdata, 0, ilen);
                    ((TagFilter_ST)val).isInvert = data[9 + ilen];
                    break;
                }
                case MTR_PARAM_TAG_EMBEDEDDATA: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((EmbededData_ST)val).bank = data[1];
                    ((EmbededData_ST)val).startaddr = data[2] << 24 | data[3] << 16 | data[4] << 8 | data[5] & 0xFF;
                    ((EmbededData_ST)val).bytecnt = data[6] << 24 | data[7] << 16 | data[8] << 8 | data[9] & 0xFF;
                    if (data[0] == 14) {
                        System.arraycopy(data, 10, ((EmbededData_ST)val).accesspwd, 0, 4);
                        break;
                    }
                    if (data[0] != 10) break;
                    ((EmbededData_ST)val).accesspwd = null;
                    break;
                }
                case MTR_PARAM_TAG_INVPOTL: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((Inv_Potls_ST)val).potlcnt = data[0];
                    ((Inv_Potls_ST)val).potls = new Inv_Potl[data[0]];
                    for (int i = 0; i < data[0]; ++i) {
                        ((Inv_Potls_ST)val).potls[i] = new Inv_Potl();
                        ((Inv_Potls_ST)val).potls[i].potl = SL_TagProtocol.valueOf(data[i * 5 + 1]);
                        ((Inv_Potls_ST)val).potls[i].weight = this.GetIntFrByteArray(data, i * 5 + 2);
                    }
                    break;
                }
                case MTR_PARAM_READER_CONN_ANTS: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((ConnAnts_ST)val).antcnt = data[0];
                    for (int i = 0; i < data[0]; ++i) {
                        ((ConnAnts_ST)val).connectedants[i] = data[i + 1];
                    }
                    break;
                }
                case MTR_PARAM_READER_VERSION: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ReaderVersion rdrver = (ReaderVersion)val;
                    if (data[0] == 1 && data[1] == 0 && data[2] == 0) {
                        rdrver.hardwareVer = data[0] + ".";
                        rdrver.hardwareVer = rdrver.hardwareVer + data[1] + ".";
                        rdrver.hardwareVer = rdrver.hardwareVer + data[2] + ".";
                        rdrver.hardwareVer = rdrver.hardwareVer + data[3];
                        rdrver.softwareVer = data[4] + ".";
                        rdrver.softwareVer = rdrver.softwareVer + data[5] + ".";
                        rdrver.softwareVer = rdrver.softwareVer + data[6] + ".";
                        rdrver.softwareVer = rdrver.softwareVer + data[7];
                        break;
                    }
                    byte[] v1by = new byte[]{data[0]};
                    rdrver.hardwareVer = Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[1];
                    rdrver.hardwareVer = rdrver.hardwareVer + Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[2];
                    rdrver.hardwareVer = rdrver.hardwareVer + Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[3];
                    rdrver.hardwareVer = rdrver.hardwareVer + Reader.bytes_Hexstr(v1by);
                    v1by[0] = data[4];
                    rdrver.softwareVer = Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[5];
                    rdrver.softwareVer = rdrver.softwareVer + Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[6];
                    rdrver.softwareVer = rdrver.softwareVer + Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[7];
                    rdrver.softwareVer = rdrver.softwareVer + Reader.bytes_Hexstr(v1by);
                    break;
                }
                case MTR_PARAM_TAG_OPPOTL: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    int rgint = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                    ((SL_TagProtocol[])val)[0] = SL_TagProtocol.valueOf(rgint);
                    break;
                }
                case MTR_PARAM_FREQUENCY_REGION: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    int rgint = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                    ((Region_Conf[])val)[0] = Region_Conf.valueOf(rgint);
                    break;
                }
                case MTR_PARAM_FREQUENCY_HOPTABLE: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((HoptableData_ST)val).lenhtb = data[0];
                    for (int i = 0; i < data[0]; ++i) {
                        ((HoptableData_ST)val).htb[i] = (data[i * 4 + 1] & 0xFF) << 24 | (data[i * 4 + 2] & 0xFF) << 16 | (data[i * 4 + 3] & 0xFF) << 8 | data[i * 4 + 4] & 0xFF;
                    }
                    break;
                }
                case MTR_PARAM_RF_ANTPORTS_VSWR: {
                    int i;
                    AntPortsVSWR apvswr = (AntPortsVSWR)val;
                    data[0] = (byte)apvswr.andid;
                    data[1] = (byte)apvswr.region.value();
                    data[2] = (byte)((apvswr.power & 0xFF00) >> 8);
                    data[3] = (byte)(apvswr.power & 0xFF);
                    data[4] = (byte)(apvswr.frecount >> 24 & 0xFF);
                    data[5] = (byte)(apvswr.frecount >> 16 & 0xFF);
                    data[6] = (byte)(apvswr.frecount >> 8 & 0xFF);
                    data[7] = (byte)(apvswr.frecount & 0xFF);
                    boolean islbt = (apvswr.frecount & 0xFFFFFF00) > 0;
                    int count = apvswr.frecount & 0xFF;
                    for (i = 0; i < count; ++i) {
                        data[8 + i * 4] = (byte)(apvswr.vswrs[i].frequency >> 24 & 0xFF);
                        data[8 + i * 4 + 1] = (byte)(apvswr.vswrs[i].frequency >> 16 & 0xFF);
                        data[8 + i * 4 + 2] = (byte)(apvswr.vswrs[i].frequency >> 8 & 0xFF);
                        data[8 + i * 4 + 3] = (byte)(apvswr.vswrs[i].frequency >> 0 & 0xFF);
                    }
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    apvswr.frecount = data[0] & 0xFF;
                    for (i = 0; i < apvswr.frecount; ++i) {
                        float rl;
                        apvswr.vswrs[i].frequency = (data[1 + i * 5] & 0xFF) << 24 | (data[1 + i * 5 + 1] & 0xFF) << 16 | (data[1 + i * 5 + 2] & 0xFF) << 8 | data[1 + i * 5 + 3] & 0xFF;
                        if (islbt) {
                            apvswr.vswrs[i].vswr = rl = (float)data[1 + i * 5 + 4];
                            continue;
                        }
                        rl = (float)Math.pow(10.0, (float)(data[1 + i * 5 + 4] & 0xFF) / 10.0f / 20.0f);
                        apvswr.vswrs[i].vswr = (1.0f + rl) / (rl - 1.0f);
                    }
                    break;
                }
                case MTR_PARAM_READER_IP: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((Reader_Ip)val).ip = new byte[data[0]];
                    ((Reader_Ip)val).mask = new byte[data[1]];
                    ((Reader_Ip)val).gateway = new byte[data[2]];
                    System.arraycopy(data, 3, ((Reader_Ip)val).ip, 0, data[0]);
                    System.arraycopy(data, 3 + data[0], ((Reader_Ip)val).mask, 0, data[1]);
                    System.arraycopy(data, 3 + data[0] + data[1], ((Reader_Ip)val).gateway, 0, data[2]);
                    break;
                }
                case MTR_PARAM_CUSTOM: {
                    int i;
                    CustomParam_ST cpst = (CustomParam_ST)val;
                    byte[] tmppname = null;
                    try {
                        tmppname = cpst.ParamName.getBytes("US-ASCII");
                    }
                    catch (Exception count) {
                        // empty catch block
                    }
                    if (tmppname == null) {
                        return READER_ERR.MT_INVALID_PARA;
                    }
                    byte opcode = 0;
                    if (tmppname[0] == 48) {
                        if (cpst.ParamVal == null) {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                        int p = 0;
                        opcode = cpst.ParamVal[0];
                        data[p] = cpst.ParamVal[p++];
                        if (opcode == 3) {
                            data[p] = cpst.ParamVal[p++];
                            data[p] = cpst.ParamVal[p++];
                            data[p] = cpst.ParamVal[p++];
                            data[p] = cpst.ParamVal[p++];
                        }
                    } else {
                        System.arraycopy(tmppname, 0, data, 0, tmppname.length);
                        data[tmppname.length] = 0;
                        if (cpst.ParamVal != null) {
                            for (i = 0; i < cpst.ParamVal.length; ++i) {
                                data[50 + i] = cpst.ParamVal[i];
                            }
                        }
                    }
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    if (tmppname[0] == 48) {
                        if (opcode != 3) break;
                        for (i = 0; i < 4; ++i) {
                            cpst.ParamVal[i] = data[i];
                        }
                        break;
                    }
                    int CParamlen = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                    cpst.ParamVal = new byte[CParamlen - 50];
                    System.arraycopy(data, 50, cpst.ParamVal, 0, CParamlen - 50);
                    break;
                }
                case MTR_PARAM_READER_WATCHDOG: 
                case MTR_PARAM_READER_ERRORDATA: {
                    byte[] retdata = (byte[])val;
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), retdata);
                    break;
                }
                case MTR_PARAM_SAVEINMODULE: {
                    int i;
                    Default_Param dp = (Default_Param)val;
                    int mtspos = 0;
                    data[mtspos++] = (byte)dp.key.value();
                    ++mtspos;
                    if (dp.key != Mtr_Param.MTR_PARAM_SAVEINMODULE_BAUD && dp.key != Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION && dp.key != Mtr_Param.MTR_PARAM_POTL_GEN2_Q && dp.key != Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET && dp.key != Mtr_Param.MTR_PARAM_RF_ANTPOWER && dp.key != Mtr_Param.MTR_PARAM_FREQUENCY_REGION) {
                        if (dp.key == Mtr_Param.MTR_PARAM_SAVEINMODULE) {
                            byte[] subb = dp.subkey.getBytes();
                            data[mtspos++] = (byte)subb.length;
                            for (i = 0; i < subb.length; ++i) {
                                data[mtspos++] = subb[i];
                            }
                        } else {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                    }
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    boolean bl = dp.isdefault = data[1] == 1;
                    if (re != 0) break;
                    if (dp.key == Mtr_Param.MTR_PARAM_SAVEINMODULE_BAUD || dp.key == Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION || dp.key == Mtr_Param.MTR_PARAM_POTL_GEN2_Q || dp.key == Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET) {
                        if (dp.isdefault) {
                            dp.val = null;
                            break;
                        }
                        int valint = (data[mtspos] & 0xFF) << 24 | (data[mtspos + 1] & 0xFF) << 16 | (data[mtspos + 2] & 0xFF) << 8 | data[mtspos + 3] & 0xFF;
                        dp.val = valint;
                        break;
                    }
                    if (dp.key == Mtr_Param.MTR_PARAM_RF_ANTPOWER) {
                        if (dp.isdefault) {
                            dp.val = null;
                            break;
                        }
                        AntPowerConf apc = new AntPowerConf();
                        apc.antcnt = data[mtspos++];
                        AntPower[] ap = new AntPower[apc.antcnt];
                        for (int i2 = 0; i2 < apc.antcnt; ++i2) {
                            ap[i2] = new AntPower();
                            ap[i2].antid = data[mtspos++];
                            ap[i2].readPower = (short)((data[mtspos] & 0xFF) << 8 | data[mtspos + 1] & 0xFF);
                            ap[i2].writePower = (short)((data[mtspos += 2] & 0xFF) << 8 | data[mtspos + 1] & 0xFF);
                            mtspos += 2;
                            mtspos += 2;
                        }
                        apc.Powers = ap;
                        dp.val = apc;
                        break;
                    }
                    if (dp.key == Mtr_Param.MTR_PARAM_FREQUENCY_REGION) {
                        if (dp.isdefault) {
                            dp.val = null;
                            break;
                        }
                        dp.val = Region_Conf.valueOf(data[mtspos++]);
                        break;
                    }
                    if (dp.key != Mtr_Param.MTR_PARAM_SAVEINMODULE) break;
                    if (dp.subkey.equals("modulesave/hpupload")) {
                        if (dp.isdefault) {
                            dp.val = null;
                            break;
                        }
                        int[] pval = new int[6];
                        for (i = 0; i < 6; ++i) {
                            data[mtspos++] = (byte)((pval[i] & 0xFF000000) >> 24);
                            data[mtspos++] = (byte)((pval[i] & 0xFF0000) >> 16);
                            data[mtspos++] = (byte)((pval[i] & 0xFF00) >> 8);
                            data[mtspos++] = (byte)(pval[i] & 0xFF);
                        }
                        dp.val = pval;
                        break;
                    }
                    if (dp.subkey.equals("modulesave/antport")) {
                        if (dp.isdefault) {
                            dp.val = null;
                            break;
                        }
                        int valint = (data[mtspos] & 0xFF) << 24 | (data[mtspos + 1] & 0xFF) << 16 | (data[mtspos + 2] & 0xFF) << 8 | data[mtspos + 3] & 0xFF;
                        Vector<Integer> Lin = new Vector<Integer>();
                        for (int i3 = 0; i3 < 32; ++i3) {
                            if ((valint >> i3 & 1) != 1) continue;
                            Lin.add(i3 + 1);
                        }
                        Integer[] valI = new Integer[Lin.size()];
                        dp.val = Lin.toArray(valI);
                        break;
                    }
                    return READER_ERR.MT_INVALID_PARA;
                }
                default: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    int[] resint = (int[])val;
                    resint[0] = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                }
            }
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ParamSet(Mtr_Param key, Object val) {
        this.toDlogAPI("ParamSet " + key.toString());
        Reader reader = this;
        synchronized (reader) {
            int re = -1;
            byte[] data = new byte[500];
            switch (key) {
                case MTR_PARAM_RF_ANTPOWER: {
                    AntPowerConf acf = (AntPowerConf)val;
                    if (this.isfilterpw) {
                        int i;
                        boolean issave = false;
                        for (i = 0; i < acf.antcnt; ++i) {
                            if (acf.Powers[i].readPower >= 500 && acf.Powers[i].writePower >= 500) continue;
                            issave = true;
                            break;
                        }
                        if (issave) {
                            this.setpower = new AntPowerConf();
                            this.setpower.antcnt = acf.antcnt;
                            for (i = 0; i < acf.antcnt; ++i) {
                                this.setpower.Powers[i] = new AntPower();
                                this.setpower.Powers[i].readPower = acf.Powers[i].readPower;
                                this.setpower.Powers[i].writePower = acf.Powers[i].writePower;
                            }
                            for (i = 0; i < acf.antcnt; ++i) {
                                if (acf.Powers[i].readPower < 500) {
                                    acf.Powers[i].readPower = (short)500;
                                }
                                if (acf.Powers[i].writePower >= 500) continue;
                                acf.Powers[i].writePower = (short)500;
                            }
                            val = acf;
                        } else {
                            this.setpower = null;
                        }
                    }
                    data[0] = (byte)((AntPowerConf)val).antcnt;
                    for (int i = 0; i < data[0]; ++i) {
                        data[i * 5 + 1] = (byte)((AntPowerConf)val).Powers[i].antid;
                        data[i * 5 + 2] = (byte)((((AntPowerConf)val).Powers[i].readPower & 0xFF00) >> 8);
                        data[i * 5 + 3] = (byte)(((AntPowerConf)val).Powers[i].readPower & 0xFF);
                        data[i * 5 + 4] = (byte)((((AntPowerConf)val).Powers[i].writePower & 0xFF00) >> 8);
                        data[i * 5 + 5] = (byte)(((AntPowerConf)val).Powers[i].writePower & 0xFF);
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_TAG_FILTER: {
                    if ((TagFilter_ST)val != null) {
                        data[0] = (byte)((TagFilter_ST)val).bank;
                        data[1] = (byte)((((TagFilter_ST)val).startaddr & 0xFF000000) >> 24);
                        data[2] = (byte)((((TagFilter_ST)val).startaddr & 0xFF0000) >> 16);
                        data[3] = (byte)((((TagFilter_ST)val).startaddr & 0xFF00) >> 8);
                        data[4] = (byte)(((TagFilter_ST)val).startaddr & 0xFF);
                        data[5] = (byte)((((TagFilter_ST)val).flen & 0xFF000000) >> 24);
                        data[6] = (byte)((((TagFilter_ST)val).flen & 0xFF0000) >> 16);
                        data[7] = (byte)((((TagFilter_ST)val).flen & 0xFF00) >> 8);
                        data[8] = (byte)(((TagFilter_ST)val).flen & 0xFF);
                        int ilen = ((TagFilter_ST)val).flen / 8;
                        if (((TagFilter_ST)val).flen % 8 != 0) {
                            ++ilen;
                        }
                        System.arraycopy(((TagFilter_ST)val).fdata, 0, data, 9, ilen);
                        data[9 + ilen] = (byte)((TagFilter_ST)val).isInvert;
                        re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                        break;
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), null);
                    break;
                }
                case MTR_PARAM_TAG_EMBEDEDDATA: {
                    if ((EmbededData_ST)val != null) {
                        data[0] = ((EmbededData_ST)val).accesspwd == null ? 10 : 14;
                        data[1] = (byte)((EmbededData_ST)val).bank;
                        data[2] = (byte)((((EmbededData_ST)val).startaddr & 0xFF000000) >> 24);
                        data[3] = (byte)((((EmbededData_ST)val).startaddr & 0xFF0000) >> 16);
                        data[4] = (byte)((((EmbededData_ST)val).startaddr & 0xFF00) >> 8);
                        data[5] = (byte)(((EmbededData_ST)val).startaddr & 0xFF);
                        data[6] = (byte)((((EmbededData_ST)val).bytecnt & 0xFF000000) >> 24);
                        data[7] = (byte)((((EmbededData_ST)val).bytecnt & 0xFF0000) >> 16);
                        data[8] = (byte)((((EmbededData_ST)val).bytecnt & 0xFF00) >> 8);
                        data[9] = (byte)(((EmbededData_ST)val).bytecnt & 0xFF);
                        if (((EmbededData_ST)val).accesspwd != null) {
                            System.arraycopy(((EmbededData_ST)val).accesspwd, 0, data, 10, 4);
                        }
                        re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                        break;
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), null);
                    break;
                }
                case MTR_PARAM_TAG_INVPOTL: {
                    data[0] = (byte)((Inv_Potls_ST)val).potlcnt;
                    for (int i = 0; i < data[0]; ++i) {
                        data[i * 5 + 1] = (byte)((Inv_Potls_ST)val).potls[i].potl.value();
                        data[i * 5 + 2] = (byte)((((Inv_Potls_ST)val).potls[i].weight & 0xFF000000) >> 24);
                        data[i * 5 + 3] = (byte)((((Inv_Potls_ST)val).potls[i].weight & 0xFF0000) >> 16);
                        data[i * 5 + 4] = (byte)((((Inv_Potls_ST)val).potls[i].weight & 0xFF00) >> 8);
                        data[i * 5 + 5] = (byte)(((Inv_Potls_ST)val).potls[i].weight & 0xFF);
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_TAG_OPPOTL: {
                    int pi = ((SL_TagProtocol)((Object)val)).p_v;
                    data[0] = (byte)((pi & 0xFF000000) >> 24);
                    data[1] = (byte)((pi & 0xFF0000) >> 16);
                    data[2] = (byte)((pi & 0xFF00) >> 8);
                    data[3] = (byte)(pi & 0xFF);
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_FREQUENCY_REGION: {
                    int rgint = ((Region_Conf)((Object)val)).value();
                    data[0] = (byte)((rgint & 0xFF000000) >> 24);
                    data[1] = (byte)((rgint & 0xFF0000) >> 16);
                    data[2] = (byte)((rgint & 0xFF00) >> 8);
                    data[3] = (byte)(rgint & 0xFF);
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_FREQUENCY_HOPTABLE: {
                    data[0] = (byte)((HoptableData_ST)val).lenhtb;
                    for (int i = 0; i < data[0]; ++i) {
                        data[i * 4 + 1] = (byte)((((HoptableData_ST)val).htb[i] & 0xFF000000) >> 24);
                        data[i * 4 + 2] = (byte)((((HoptableData_ST)val).htb[i] & 0xFF0000) >> 16);
                        data[i * 4 + 3] = (byte)((((HoptableData_ST)val).htb[i] & 0xFF00) >> 8);
                        data[i * 4 + 4] = (byte)(((HoptableData_ST)val).htb[i] & 0xFF);
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_READER_IP: {
                    int ipl = ((Reader_Ip)val).ip.length;
                    int ml = ((Reader_Ip)val).mask.length;
                    int gl = ((Reader_Ip)val).gateway.length;
                    data[0] = (byte)ipl;
                    data[1] = (byte)ml;
                    data[2] = (byte)gl;
                    System.arraycopy(((Reader_Ip)val).ip, 0, data, 3, ipl);
                    System.arraycopy(((Reader_Ip)val).mask, 0, data, 3 + ipl, ml);
                    System.arraycopy(((Reader_Ip)val).gateway, 0, data, 3 + ipl + ml, gl);
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_READER_WATCHDOG: {
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), (byte[])val);
                    break;
                }
                case MTR_PARAM_TAG_MULTISELECTORS: {
                    String[] epcs = (String[])val;
                    if (epcs == null) {
                        re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), null);
                        break;
                    }
                    MultiTagSelectors_ST mts = new MultiTagSelectors_ST();
                    if (epcs.length == 0 || epcs.length > 16) {
                        return READER_ERR.MT_INVALID_PARA;
                    }
                    mts.tagselectorcnt = epcs.length;
                    for (int i = 0; i < epcs.length; ++i) {
                        if (epcs[i] == null) {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                        if (epcs[i].length() > 48 || epcs[i].length() % 4 != 0) {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                        mts.tagselectors[i].bank = 1;
                        if (epcs[i].length() == 0) {
                            mts.tagselectors[i].startaddr = 16;
                            mts.tagselectors[i].slen = 5;
                            mts.tagselectors[i].sdata[0] = 0;
                            continue;
                        }
                        mts.tagselectors[i].startaddr = 32;
                        mts.tagselectors[i].slen = epcs[i].length() * 4;
                        this.Str2Hex(epcs[i], epcs[i].length(), mts.tagselectors[i].sdata);
                    }
                    int mtspos = 0;
                    int sbytedatalen = 0;
                    data[mtspos++] = (byte)mts.tagselectorcnt;
                    for (int i = 0; i < mts.tagselectorcnt; ++i) {
                        data[mtspos++] = (byte)mts.tagselectors[i].bank;
                        data[mtspos++] = (byte)((mts.tagselectors[i].startaddr & 0xFF000000) >> 24);
                        data[mtspos++] = (byte)((mts.tagselectors[i].startaddr & 0xFF0000) >> 16);
                        data[mtspos++] = (byte)((mts.tagselectors[i].startaddr & 0xFF00) >> 8);
                        data[mtspos++] = (byte)(mts.tagselectors[i].startaddr & 0xFF);
                        data[mtspos++] = (byte)mts.tagselectors[i].slen;
                        sbytedatalen = mts.tagselectors[i].slen % 8 == 0 ? mts.tagselectors[i].slen / 8 : mts.tagselectors[i].slen / 8 + 1;
                        System.arraycopy(mts.tagselectors[i].sdata, 0, data, mtspos, sbytedatalen);
                        mtspos += sbytedatalen;
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_CUSTOM: {
                    CustomParam_ST cpst = (CustomParam_ST)val;
                    byte[] tmppname = null;
                    try {
                        tmppname = cpst.ParamName.getBytes("US-ASCII");
                    }
                    catch (Exception mtspos) {
                        // empty catch block
                    }
                    if (cpst.ParamVal == null || tmppname == null) {
                        return READER_ERR.MT_INVALID_PARA;
                    }
                    if (tmppname[0] == 48) {
                        int p = 2;
                        System.arraycopy(cpst.ParamVal, 0, data, p, cpst.ParamVal.length);
                        short len = (short)cpst.ParamVal.length;
                        data[0] = (byte)((len & 0xFF00) >> 8);
                        data[1] = (byte)(len & 0xFF);
                    } else {
                        System.arraycopy(tmppname, 0, data, 0, tmppname.length);
                        data[tmppname.length] = 0;
                        data[48] = (byte)((cpst.ParamVal.length & 0xFF00) >> 8);
                        data[49] = (byte)(cpst.ParamVal.length & 0xFF);
                        System.arraycopy(cpst.ParamVal, 0, data, 50, cpst.ParamVal.length);
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_SAVEINMODULE: {
                    Default_Param dp = (Default_Param)val;
                    if (dp == null) {
                        return READER_ERR.MT_INVALID_PARA;
                    }
                    int mtspos = 0;
                    data[mtspos++] = (byte)dp.key.value();
                    data[mtspos++] = (byte)(dp.isdefault ? 1 : 0);
                    if (dp.key == Mtr_Param.MTR_PARAM_SAVEINMODULE_BAUD || dp.key == Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION || dp.key == Mtr_Param.MTR_PARAM_POTL_GEN2_Q || dp.key == Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET) {
                        int valint = 0;
                        if (dp.val != null) {
                            valint = (Integer)dp.val;
                        } else if (dp.key == Mtr_Param.MTR_PARAM_SAVEINMODULE_BAUD && dp.val == null && !dp.isdefault) {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                        data[mtspos++] = (byte)((valint & 0xFF000000) >> 24);
                        data[mtspos++] = (byte)((valint & 0xFF0000) >> 16);
                        data[mtspos++] = (byte)((valint & 0xFF00) >> 8);
                        data[mtspos++] = (byte)(valint & 0xFF);
                    } else if (dp.key == Mtr_Param.MTR_PARAM_RF_ANTPOWER) {
                        AntPowerConf apc = null;
                        if (dp.val != null) {
                            apc = (AntPowerConf)dp.val;
                        } else if (dp.isdefault) {
                            apc = new AntPowerConf();
                        } else {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                        data[mtspos++] = (byte)apc.antcnt;
                        for (int i = 0; i < apc.antcnt; ++i) {
                            data[mtspos++] = (byte)apc.Powers[i].antid;
                            data[mtspos++] = (byte)((apc.Powers[i].readPower & 0xFF00) >> 8);
                            data[mtspos++] = (byte)(apc.Powers[i].readPower & 0xFF);
                            data[mtspos++] = (byte)((apc.Powers[i].writePower & 0xFF00) >> 8);
                            data[mtspos++] = (byte)(apc.Powers[i].writePower & 0xFF);
                            data[mtspos++] = 0;
                            data[mtspos++] = 0;
                        }
                    } else if (dp.key == Mtr_Param.MTR_PARAM_FREQUENCY_REGION) {
                        if (dp.isdefault && dp.val == null) {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                        data[mtspos++] = (byte)((Integer)(dp.val == null ? Integer.valueOf(0) : dp.val)).intValue();
                    } else if (dp.key == Mtr_Param.MTR_PARAM_SAVEINMODULE) {
                        byte[] subb = dp.subkey.getBytes();
                        data[mtspos++] = (byte)subb.length;
                        for (int i = 0; i < subb.length; ++i) {
                            data[mtspos++] = subb[i];
                        }
                        if (dp.subkey.equals("modulesave/hpupload")) {
                            int[] pval = (int[])dp.val;
                            for (int i = 0; i < 6; ++i) {
                                data[mtspos++] = (byte)((pval[i] & 0xFF000000) >> 24);
                                data[mtspos++] = (byte)((pval[i] & 0xFF0000) >> 16);
                                data[mtspos++] = (byte)((pval[i] & 0xFF00) >> 8);
                                data[mtspos++] = (byte)(pval[i] & 0xFF);
                            }
                        } else if (dp.subkey.equals("modulesave/antport")) {
                            Integer[] valints = (Integer[])dp.val;
                            int valint = 0;
                            for (int i = 0; i < valints.length; ++i) {
                                valint |= 1 << valints[i] - 1;
                            }
                            data[mtspos++] = (byte)((valint & 0xFF000000) >> 24);
                            data[mtspos++] = (byte)((valint & 0xFF0000) >> 16);
                            data[mtspos++] = (byte)((valint & 0xFF00) >> 8);
                            data[mtspos++] = (byte)(valint & 0xFF);
                        } else if (!dp.subkey.equals("modulesave/default")) {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                    } else {
                        return READER_ERR.MT_INVALID_PARA;
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                default: {
                    int valint = 0;
                    if (val != null) {
                        valint = ((int[])val)[0];
                    }
                    data[0] = (byte)((valint & 0xFF000000) >> 24);
                    data[1] = (byte)((valint & 0xFF0000) >> 16);
                    data[2] = (byte)((valint & 0xFF00) >> 8);
                    data[3] = (byte)(valint & 0xFF);
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                }
            }
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    public static String bytes_Hexstr(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public void Str2Hex(String buf, int len, byte[] hexbuf) {
        String chex = "0123456789ABCDEF";
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; i += 2) {
            byte hnx = (byte)chex.indexOf(buf.toUpperCase().substring(i, i + 1));
            byte lnx = 0;
            if (i + 2 <= len) {
                lnx = (byte)chex.indexOf(buf.toUpperCase().substring(i + 1, i + 2));
            }
            hexbuf[i % 2 == 0 ? i / 2 : i / 2 + 1] = (byte)(hnx << 4 & 0xFF | lnx & 0xFF);
        }
    }

    public void Str2Binary(String buf, int len, byte[] binarybuf) {
        if (len % 8 != 0) {
            return;
        }
        for (int i = 0; i < len; i += 8) {
            byte temp = 0;
            for (int j = 0; j < 8; ++j) {
                temp = (byte)(temp | (byte)(Byte.parseByte(buf.substring(i + j, i + j + 1)) << 7 - j));
            }
            int n = i / 8;
            binarybuf[n] = (byte)(binarybuf[n] | temp);
        }
    }

    public READER_ERR SetInvMultiEmbeddedData(ArrayList<InvEmbeddedBankData> bankdatas, byte[] accesspwd) {
        CustomParam_ST cstPara = new CustomParam_ST();
        cstPara.ParamName = "gen2op/multiembeddeddata";
        cstPara.ParamVal = new byte[70];
        int pos = 0;
        InvEmbeddedBankData bankdata = null;
        if (bankdatas.size() > 10) {
            return READER_ERR.MT_INVALID_PARA;
        }
        cstPara.ParamVal[pos++] = (byte)bankdatas.size();
        if (bankdatas.size() != 0) {
            cstPara.ParamVal[pos++] = accesspwd[0];
            cstPara.ParamVal[pos++] = accesspwd[1];
            cstPara.ParamVal[pos++] = accesspwd[2];
            cstPara.ParamVal[pos++] = accesspwd[3];
            for (int i = 0; i < bankdatas.size(); ++i) {
                bankdata = bankdatas.get(i);
                cstPara.ParamVal[pos++] = bankdata.bank;
                cstPara.ParamVal[pos++] = (byte)((bankdata.startaddr & 0xFF000000) >> 24);
                cstPara.ParamVal[pos++] = (byte)((bankdata.startaddr & 0xFF0000) >> 16);
                cstPara.ParamVal[pos++] = (byte)((bankdata.startaddr & 0xFF00) >> 8);
                cstPara.ParamVal[pos++] = (byte)(bankdata.startaddr & 0xFF);
                cstPara.ParamVal[pos++] = bankdata.blockcnt;
            }
        }
        return this.ParamSet(Mtr_Param.MTR_PARAM_CUSTOM, cstPara);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncStartReading(int[] ants, int antcnt, int option) {
        this.toDlogAPI("AsyncStartReading- [] " + String.valueOf(antcnt) + " " + String.valueOf(option));
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.AsyncStartReading(this.hReader[0], ants, antcnt, option);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncStopReading() {
        this.toDlogAPI("AsyncStopReading");
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.AsyncStopReading(this.hReader[0]);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncGetTagCount(int[] tagcnt) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.AsyncGetTagCount(this.hReader[0], tagcnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncGetNextTag(TAGINFO TI) {
        Reader reader = this;
        synchronized (reader) {
            byte[] tagbuf = new byte[500];
            int pos = 0;
            int re = this.japi.AsyncGetNextTag_BaseType(this.hReader[0], tagbuf);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                TI.ReadCnt = tagbuf[pos++];
                TI.RSSI = tagbuf[pos++];
                TI.AntennaID = tagbuf[pos++];
                TI.Frequency = (tagbuf[pos] & 0xFF) << 24 | (tagbuf[pos + 1] & 0xFF) << 16 | (tagbuf[pos + 2] & 0xFF) << 8 | tagbuf[pos + 3] & 0xFF;
                TI.TimeStamp = (tagbuf[pos += 4] & 0xFF) << 24 | (tagbuf[pos + 1] & 0xFF) << 16 | (tagbuf[pos + 2] & 0xFF) << 8 | tagbuf[pos + 3] & 0xFF;
                pos += 4;
                TI.Res[0] = tagbuf[pos++];
                TI.Res[1] = tagbuf[pos++];
                TI.protocol = SL_TagProtocol.valueOf(tagbuf[pos++]);
                int epclen = (tagbuf[pos] & 0xFF) << 8 | tagbuf[pos + 1] & 0xFF;
                pos += 2;
                TI.PC[0] = tagbuf[pos++];
                TI.PC[1] = tagbuf[pos++];
                TI.EpcId = new byte[epclen];
                TI.Epclen = (short)epclen;
                System.arraycopy(tagbuf, pos, TI.EpcId, 0, epclen);
                pos += epclen;
                TI.CRC[0] = tagbuf[pos++];
                TI.CRC[1] = tagbuf[pos++];
                TI.protocol = SL_TagProtocol.valueOf(tagbuf[pos++]);
                int emddatalen = (tagbuf[pos] & 0xFF) << 8 | tagbuf[pos + 1] & 0xFF;
                pos += 2;
                TI.EmbededData = new byte[emddatalen];
                TI.EmbededDatalen = (short)emddatalen;
                if (emddatalen > 0) {
                    System.arraycopy(tagbuf, pos, TI.EmbededData, 0, emddatalen);
                }
            }
            return ERR;
        }
    }

    public static String GetSDKVersion() {
        String ver = "jarVersion:20220322";
        ver = ver + "soVersion:" + JniModuleAPI.GetSDKVersion();
        return ver;
    }

    public static READER_ERR GetDeviceVersion(String serialpath, deviceVersion rdrver) {
        byte[] verdata = new byte[9];
        int ret = JniModuleAPI.GetDeviceVersion(serialpath, verdata);
        READER_ERR err = READER_ERR.valueOf(ret);
        if (err == READER_ERR.MT_OK_ERR) {
            if (verdata[0] == 1) {
                rdrver.hardwareVer = verdata[1] + ".";
                rdrver.hardwareVer = rdrver.hardwareVer + verdata[2] + ".";
                rdrver.hardwareVer = rdrver.hardwareVer + verdata[3] + ".";
                rdrver.hardwareVer = rdrver.hardwareVer + verdata[4];
                rdrver.softwareVer = verdata[5] + ".";
                rdrver.softwareVer = rdrver.softwareVer + verdata[6] + ".";
                rdrver.softwareVer = rdrver.softwareVer + verdata[7] + ".";
                rdrver.softwareVer = rdrver.softwareVer + verdata[8];
            } else {
                byte[] v1by = new byte[]{verdata[1]};
                rdrver.hardwareVer = Reader.bytes_Hexstr(v1by) + ".";
                v1by[0] = verdata[2];
                rdrver.hardwareVer = rdrver.hardwareVer + Reader.bytes_Hexstr(v1by) + ".";
                v1by[0] = verdata[3];
                rdrver.hardwareVer = rdrver.hardwareVer + Reader.bytes_Hexstr(v1by) + ".";
                v1by[0] = verdata[4];
                rdrver.hardwareVer = rdrver.hardwareVer + Reader.bytes_Hexstr(v1by);
                v1by[0] = verdata[5];
                rdrver.softwareVer = Reader.bytes_Hexstr(v1by) + ".";
                v1by[0] = verdata[6];
                rdrver.softwareVer = rdrver.softwareVer + Reader.bytes_Hexstr(v1by) + ".";
                v1by[0] = verdata[7];
                rdrver.softwareVer = rdrver.softwareVer + Reader.bytes_Hexstr(v1by) + ".";
                v1by[0] = verdata[8];
                rdrver.softwareVer = rdrver.softwareVer + Reader.bytes_Hexstr(v1by);
            }
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetSerialNumber(DeviceSerialNumber devsn) {
        Reader reader = this;
        synchronized (reader) {
            String sn = "";
            CustomParam_ST cpara = new CustomParam_ST();
            cpara.ParamName = "reader/rdrdetails";
            READER_ERR ret = this.ParamGet(Mtr_Param.MTR_PARAM_CUSTOM, cpara);
            if (ret != READER_ERR.MT_OK_ERR) {
                return ret;
            }
            byte[] binhv = new byte[4];
            System.arraycopy(cpara.ParamVal, 28, binhv, 0, 4);
            sn = sn + Reader.bytes_Hexstr(binhv);
            for (int i = 0; i < 12; ++i) {
                sn = sn + cpara.ParamVal[16 + i];
            }
            HardwareDetails hd = new HardwareDetails();
            this.GetHardwareDetails(hd);
            sn = hd.board == MaindBoard_Type.MAINBOARD_ARM9 ? "A9" + sn : (hd.board == MaindBoard_Type.MAINBOARD_ARM7 ? "A7" + sn : "SE" + sn);
            devsn.serailNumber = sn;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetLastDetailError(ErrInfo ei) {
        Reader reader = this;
        synchronized (reader) {
            byte[] resbuf = new byte[500];
            int re = this.japi.GetLastDetailError_BaseType(this.hReader[0], resbuf);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                ei.derrcode = (resbuf[0] & 0xFF) << 24 | (resbuf[1] & 0xFF) << 16 | (resbuf[2] & 0xFF) << 8 | resbuf[3] & 0xFF;
                byte[] estrbytes = new byte[resbuf[4]];
                System.arraycopy(resbuf, 5, estrbytes, 0, resbuf[4]);
                try {
                    ei.errstr = new String(estrbytes, "ascii");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ResetRfidModule() {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.ResetRfidModule(this.hReader[0]);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    public static READER_ERR FirmwareLoadFromSerialPort(String serialportPath, String firmwarePath) {
        int re = JniModuleAPI.FirmwareLoadFromSerialPort(serialportPath, firmwarePath);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public static READER_ERR RebootReader(String readeraddr) {
        int re = JniModuleAPI.RebootReader(readeraddr);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int DataTransportSend(byte[] data, int datalen, int timeout) {
        Reader reader = this;
        synchronized (reader) {
            return this.japi.DataTransportSend(this.hReader[0], data, datalen, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int DataTransportRecv(byte[] data, int datalen, int timeout) {
        Reader reader = this;
        synchronized (reader) {
            return this.japi.DataTransportRecv(this.hReader[0], data, datalen, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ReadTagTemperature(int ant, char bank, int address, int wordcnt, int timeout, int timeselwait, int timereadwait, short metaflag, byte[] accesspasswd, R2000_calibration.Tagtemperture_DATA tagtemp) {
        Reader reader = this;
        synchronized (reader) {
            byte[] data = new byte[300];
            int[] datalen = new int[1];
            int re = this.japi.ReadTagTemperature(this.hReader[0], ant, bank, address, wordcnt, timeout + timeselwait + timereadwait, timeselwait, timereadwait, metaflag, accesspasswd, data, datalen);
            if (re == 0) {
                R2000_calibration.Tagtemperture_DATA tagtemp2 = new R2000_calibration().new R2000_calibration.Tagtemperture_DATA(data, wordcnt);
                tagtemp.pvtAntenna = tagtemp2.pvtAntenna;
                tagtemp.pvtFrequency = tagtemp2.pvtFrequency;
                tagtemp.pvtLqi = tagtemp2.pvtLqi;
                tagtemp.pvtPhase = tagtemp2.pvtPhase;
                tagtemp.pvtPro = tagtemp2.pvtPro;
                tagtemp.pvtReadCount = tagtemp2.pvtReadCount;
                tagtemp.pvtTsmp = tagtemp2.pvtTsmp;
                tagtemp.tagcrc = new byte[2];
                tagtemp.tagpc = new byte[2];
                tagtemp.tagepc = new byte[tagtemp2.tagepc.length];
                System.arraycopy(tagtemp2.tagcrc, 0, tagtemp.tagcrc, 0, 2);
                System.arraycopy(tagtemp2.tagepc, 0, tagtemp.tagepc, 0, tagtemp2.tagepc.length);
                System.arraycopy(tagtemp2.tagpc, 0, tagtemp.tagpc, 0, 2);
                if (tagtemp2.BankData != null) {
                    tagtemp.BankData = new byte[tagtemp2.BankData.length];
                    System.arraycopy(tagtemp2.BankData, 0, tagtemp.BankData, 0, tagtemp2.BankData.length);
                }
                tagtemp.temperdata = new byte[tagtemp2.temperdata.length];
                System.arraycopy(tagtemp2.temperdata, 0, tagtemp.temperdata, 0, tagtemp2.temperdata.length);
            }
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ReadTagLED(int ant, short timeout, short metaflag, R2000_calibration.TagLED_DATA tagled) {
        Reader reader = this;
        synchronized (reader) {
            byte[] data = new byte[300];
            int[] datalen = new int[1];
            int re = this.japi.ReadTagLED(this.hReader[0], ant, metaflag, timeout, data, datalen);
            if (re == 0) {
                R2000_calibration.TagLED_DATA tagled2 = new R2000_calibration().new R2000_calibration.TagLED_DATA(data, datalen[0]);
                tagled.pvtAntenna = tagled2.pvtAntenna;
                tagled.pvtFrequency = tagled2.pvtFrequency;
                tagled.pvtLqi = tagled2.pvtLqi;
                tagled.pvtPhase = tagled2.pvtPhase;
                tagled.pvtPro = tagled2.pvtPro;
                tagled.pvtReadCount = tagled2.pvtReadCount;
                tagled.pvtTsmp = tagled2.pvtTsmp;
                tagled.tagcrc = new byte[2];
                tagled.tagpc = new byte[2];
                tagled.tagepc = new byte[tagled2.tagepc.length];
                System.arraycopy(tagled2.tagcrc, 0, tagled.tagcrc, 0, 2);
                System.arraycopy(tagled2.tagepc, 0, tagled.tagepc, 0, tagled2.tagepc.length);
                System.arraycopy(tagled2.tagpc, 0, tagled.tagpc, 0, 2);
                if (tagled2.BankData != null) {
                    tagled.BankData = new byte[tagled2.BankData.length];
                    System.arraycopy(tagled2.BankData, 0, tagled.BankData, 0, tagled2.BankData.length);
                }
            }
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR SpecialSensorTagOp(int ant, int timeout, SpecialSensorTag sst) {
        Reader reader = this;
        synchronized (reader) {
            byte[] outdata = new byte[255];
            int[] outdatalen = new int[1];
            int re = this.japi.SpecialSensorTagOp(this.hReader[0], ant, sst.TagTypeE().value(), timeout, sst.ToByteData(), sst.ToByteData().length, sst.accesspwd, outdata, outdatalen);
            if (re == 0 && sst.TagTypeE() == SpecialSensorTag.TagType.SCR409) {
                try {
                    int pos = sst.ParseOfEPCinfo(outdata, outdatalen[0] & 0xFF);
                    if (pos + 10 <= outdatalen[0]) {
                        ((SpecialSensorTag.Tag_SCR409)sst).ParseSpecialSensorInfo(outdata, pos);
                    } else {
                        re = 20;
                    }
                }
                catch (Exception ex) {
                    re = 20;
                }
            }
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    public int SetFilterSessioninTargetA(int[] ants, int fre, int power) {
        try {
            R2000_calibration.FilterS2inA_DATA fsa = new R2000_calibration().new R2000_calibration.FilterS2inA_DATA(ants, fre, power);
            R2000_calibration r2cb = new R2000_calibration();
            byte[] data = r2cb.GetSendCmd(R2000_calibration.R2000cmd.S2TA, fsa.ToByteData());
            MsgObj hMsg = new MsgObj();
            int re = this.SendandRev(data, 5000, hMsg);
            if (re != 0) {
                return re;
            }
            return hMsg.status[0] << 8 | hMsg.status[1];
        }
        catch (Exception ex) {
            this.toDlogEX(ex, this);
            return 57601;
        }
    }

    READER_ERR FlushDummyData2Mod() {
        byte[] zerobuf = new byte[255];
        zerobuf[0] = -1;
        zerobuf[1] = -6;
        zerobuf[2] = 0;
        for (int i = 3; i < 255; ++i) {
            zerobuf[i] = 0;
        }
        this.DataTransportSend(zerobuf, 255, 2000);
        return READER_ERR.MT_OK_ERR;
    }

    public READER_ERR SpecParamsForReader(int type, boolean isset, SpecObject val) {
        READER_ERR er = READER_ERR.MT_OK_ERR;
        if (type == 0) {
            CustomParam_ST cpst = new CustomParam_ST();
            int addr = 1;
            cpst.ParamName = "R2000/oemregister";
            if (isset) {
                if (val == null || !(val.Val() instanceof Region_Conf)) {
                    return READER_ERR.MT_INVALID_PARA;
                }
                cpst.ParamVal = new byte[4];
                cpst.ParamVal[0] = (byte)(addr >> 24 & 0xFF);
                cpst.ParamVal[1] = (byte)(addr >> 16 & 0xFF);
                cpst.ParamVal[2] = (byte)(addr >> 8 & 0xFF);
                cpst.ParamVal[3] = (byte)(addr & 0xFF);
                er = this.ParamGet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
                byte[] valb = new byte[4];
                if (er == READER_ERR.MT_OK_ERR) {
                    for (int i = 0; i < 4; ++i) {
                        valb[i] = cpst.ParamVal[i];
                    }
                } else {
                    return READER_ERR.MT_CMD_FAILED_ERR;
                }
                cpst.ParamVal = new byte[8];
                cpst.ParamVal[0] = (byte)(addr >> 24 & 0xFF);
                cpst.ParamVal[1] = (byte)(addr >> 16 & 0xFF);
                cpst.ParamVal[2] = (byte)(addr >> 8 & 0xFF);
                cpst.ParamVal[3] = (byte)(addr & 0xFF);
                cpst.ParamVal[4] = valb[0];
                cpst.ParamVal[5] = valb[1];
                switch ((Region_Conf)((Object)val.Val())) {
                    case RG_NA: {
                        cpst.ParamVal[6] = 1;
                        break;
                    }
                    case RG_EU3: {
                        cpst.ParamVal[6] = 3;
                        break;
                    }
                    case RG_KR: {
                        cpst.ParamVal[6] = 4;
                        break;
                    }
                    case RG_PRC: {
                        cpst.ParamVal[6] = 0;
                        break;
                    }
                    case RG_PRC2: {
                        cpst.ParamVal[6] = 0;
                        break;
                    }
                    case RG_OPEN: {
                        cpst.ParamVal[6] = 0;
                        break;
                    }
                    case RG_IN: {
                        cpst.ParamVal[6] = 14;
                        break;
                    }
                    case RG_JP: {
                        cpst.ParamVal[6] = 2;
                        break;
                    }
                    case RG_CE_HIGH: {
                        cpst.ParamVal[6] = 5;
                        break;
                    }
                    case RG_HK: {
                        cpst.ParamVal[6] = 6;
                        break;
                    }
                    case RG_TAIWAN: {
                        cpst.ParamVal[6] = 7;
                        break;
                    }
                    case RG_MALAYSIA: {
                        cpst.ParamVal[6] = 8;
                        break;
                    }
                    case RG_SOUTH_AFRICA: {
                        cpst.ParamVal[6] = 9;
                        break;
                    }
                    case RG_BRAZIL: {
                        cpst.ParamVal[6] = 10;
                        break;
                    }
                    case RG_THAILAND: {
                        cpst.ParamVal[6] = 11;
                        break;
                    }
                    case RG_SINGAPORE: {
                        cpst.ParamVal[6] = 12;
                        break;
                    }
                    case RG_AUSTRALIA: {
                        cpst.ParamVal[6] = 13;
                        break;
                    }
                    case RG_URUGUAY: {
                        cpst.ParamVal[6] = 15;
                        break;
                    }
                    case RG_VIETNAM: {
                        cpst.ParamVal[6] = 16;
                        break;
                    }
                    case RG_ISRAEL: {
                        cpst.ParamVal[6] = 17;
                        break;
                    }
                    case RG_PHILIPPINES: {
                        cpst.ParamVal[6] = 18;
                        break;
                    }
                    case RG_INDONESIA: {
                        cpst.ParamVal[6] = 19;
                        break;
                    }
                    case RG_NEW_ZEALAND: {
                        cpst.ParamVal[6] = 20;
                        break;
                    }
                    case RG_PERU: {
                        cpst.ParamVal[6] = 21;
                        break;
                    }
                    case RG_RUSSIA: {
                        cpst.ParamVal[6] = 22;
                        break;
                    }
                    case RG_CE_LOW_HIGH: {
                        cpst.ParamVal[6] = 23;
                        break;
                    }
                    case RG_JP2_LBT6: {
                        cpst.ParamVal[6] = 24;
                        break;
                    }
                    case RG_JP3_NLBT19: {
                        cpst.ParamVal[6] = 25;
                        break;
                    }
                    default: {
                        return READER_ERR.MT_INVALID_PARA;
                    }
                }
                cpst.ParamVal[7] = valb[3];
                return this.ParamSet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
            }
            cpst.ParamVal = new byte[4];
            cpst.ParamVal[0] = (byte)(addr >> 24 & 0xFF);
            cpst.ParamVal[1] = (byte)(addr >> 16 & 0xFF);
            cpst.ParamVal[2] = (byte)(addr >> 8 & 0xFF);
            cpst.ParamVal[3] = (byte)(addr & 0xFF);
            er = this.ParamGet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
            if (er == READER_ERR.MT_OK_ERR) {
                byte[] valb = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    valb[i] = cpst.ParamVal[i];
                }
                switch (valb[2] & 0xFF) {
                    case 1: {
                        val.Set((Object)Region_Conf.RG_NA);
                        break;
                    }
                    case 3: {
                        val.Set((Object)Region_Conf.RG_EU3);
                        break;
                    }
                    case 4: {
                        val.Set((Object)Region_Conf.RG_KR);
                        break;
                    }
                    case 0: {
                        val.Set((Object)Region_Conf.RG_PRC);
                        break;
                    }
                    case 14: {
                        val.Set((Object)Region_Conf.RG_IN);
                        break;
                    }
                    case 2: {
                        val.Set((Object)Region_Conf.RG_JP);
                        break;
                    }
                    case 5: {
                        val.Set((Object)Region_Conf.RG_CE_HIGH);
                        break;
                    }
                    case 6: {
                        val.Set((Object)Region_Conf.RG_HK);
                        break;
                    }
                    case 7: {
                        val.Set((Object)Region_Conf.RG_TAIWAN);
                        break;
                    }
                    case 8: {
                        val.Set((Object)Region_Conf.RG_MALAYSIA);
                        break;
                    }
                    case 9: {
                        val.Set((Object)Region_Conf.RG_SOUTH_AFRICA);
                        break;
                    }
                    case 10: {
                        val.Set((Object)Region_Conf.RG_BRAZIL);
                        break;
                    }
                    case 11: {
                        val.Set((Object)Region_Conf.RG_THAILAND);
                        break;
                    }
                    case 12: {
                        val.Set((Object)Region_Conf.RG_SINGAPORE);
                        break;
                    }
                    case 13: {
                        val.Set((Object)Region_Conf.RG_AUSTRALIA);
                        break;
                    }
                    case 15: {
                        val.Set((Object)Region_Conf.RG_URUGUAY);
                        break;
                    }
                    case 16: {
                        val.Set((Object)Region_Conf.RG_VIETNAM);
                        break;
                    }
                    case 17: {
                        val.Set((Object)Region_Conf.RG_ISRAEL);
                        break;
                    }
                    case 18: {
                        val.Set((Object)Region_Conf.RG_PHILIPPINES);
                        break;
                    }
                    case 19: {
                        val.Set((Object)Region_Conf.RG_INDONESIA);
                        break;
                    }
                    case 20: {
                        val.Set((Object)Region_Conf.RG_NEW_ZEALAND);
                        break;
                    }
                    case 21: {
                        val.Set((Object)Region_Conf.RG_PERU);
                        break;
                    }
                    case 22: {
                        val.Set((Object)Region_Conf.RG_RUSSIA);
                        break;
                    }
                    case 23: {
                        val.Set((Object)Region_Conf.RG_CE_LOW_HIGH);
                        break;
                    }
                    case 24: {
                        val.Set((Object)Region_Conf.RG_JP2_LBT6);
                        break;
                    }
                    case 25: {
                        val.Set((Object)Region_Conf.RG_JP3_NLBT19);
                    }
                }
            }
        }
        return er;
    }

    public static byte[] CollectionTobyteArray(List list) {
        Iterator itor = list.iterator();
        byte[] backdata = new byte[list.size()];
        int i = 0;
        while (itor.hasNext()) {
            backdata[i++] = (Byte)itor.next();
        }
        return backdata;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Byte> SpecialStructDataConvert(Object ObjectData) {
        ArrayList<Byte> LB = new ArrayList<Byte>();
        if (ObjectData instanceof MODUSPARMS) {
            MODUSPARMS msp = (MODUSPARMS)ObjectData;
            LB.add(msp.CMD);
            if (msp.CMD != 1 && msp.CMD != 2 && msp.CMD != 3) return null;
            LB.add((byte)0);
            LB.add((byte)0);
            LB.add((byte)0);
            byte datab = 0;
            if (msp.isReAntCT == 1) {
                datab = (byte)(datab | 1);
            }
            if (msp.isReAntHL == 1) {
                datab = (byte)(datab | 2);
            }
            if (msp.isReTemp == 1) {
                datab = (byte)(datab | 4);
            }
            LB.add(datab);
            return LB;
        } else {
            if (!(ObjectData instanceof IMPINJ_FASTPARMS)) return LB;
            IMPINJ_FASTPARMS msp = (IMPINJ_FASTPARMS)ObjectData;
            List<Byte> tempdata = null;
            LB.add(msp.CMD);
            if (msp.sub == null) {
                LB.add((byte)0);
            } else {
                tempdata = Reader.SpecialStructDataConvert(msp.sub);
                if (null != tempdata) {
                    return null;
                }
                LB.addAll(tempdata);
            }
            LB.add((byte)((msp.IMPINJ_MODE_ID & 0xFF00) >> 8));
            LB.add((byte)(msp.IMPINJ_MODE_ID & 0xFF));
            if (msp.CMD != 19) return LB;
            LB.add(msp.IMPINJ_FAST_MODE);
        }
        return LB;
    }

    READER_ERR TestModLive() {
        READER_ERR err = READER_ERR.MT_OK_ERR;
        byte[] cmd = new byte[]{-1, 0, 3, 29, 12};
        byte[] resp = new byte[50];
        byte[] resp2 = new byte[50];
        this.DataTransportSend(cmd, cmd.length, 1000);
        if (this.DataTransportRecv(resp, 5, 1000) == -1) {
            return READER_ERR.MT_CMD_FAILED_ERR;
        }
        if (this.DataTransportRecv(resp2, resp[1] + 2, 1000) == -1) {
            return READER_ERR.MT_CMD_FAILED_ERR;
        }
        return err;
    }

    private int SendandRev(byte[] data, int timeout, MsgObj hMsg) {
        int COMM_NON_FATAL_ERR = 65277;
        int MODULE_NEED_RESTART = 65278;
        short MSG_CRC_INIT = -1;
        this.toDlogAPI("send:" + Reader.bytes_Hexstr(data));
        int re = this.DataTransportSend(data, data.length, timeout);
        if (re != 0) {
            return COMM_NON_FATAL_ERR;
        }
        READER_ERR err = READER_ERR.MT_OK_ERR;
        int ret = 0;
        String revstr = "";
        ret = this.DataTransportRecv(hMsg.soh, 1, 1000);
        revstr = revstr + Reader.bytes_Hexstr(hMsg.soh);
        if (ret == -2 || ret == -3) {
            return COMM_NON_FATAL_ERR;
        }
        if (ret == -1) {
            return READER_ERR.MT_IO_ERR.value();
        }
        if (ret == -4) {
            if (this.FlushDummyData2Mod() != READER_ERR.MT_OK_ERR) {
                return READER_ERR.MT_IO_ERR.value();
            }
            if (this.TestModLive() == READER_ERR.MT_OK_ERR) {
                return COMM_NON_FATAL_ERR;
            }
            return MODULE_NEED_RESTART;
        }
        if ((hMsg.soh[0] & 0xFF) != 255) {
            if (this.FlushDummyData2Mod() != READER_ERR.MT_OK_ERR) {
                return READER_ERR.MT_IO_ERR.value();
            }
            return 65277;
        }
        short scrc = MSG_CRC_INIT;
        if (this.DataTransportRecv(hMsg.dataLen, 1, 1000) == -1) {
            return COMM_NON_FATAL_ERR;
        }
        revstr = revstr + Reader.bytes_Hexstr(hMsg.dataLen);
        if (this.DataTransportRecv(hMsg.opCode, 1, 1000) == -1) {
            return COMM_NON_FATAL_ERR;
        }
        revstr = revstr + Reader.bytes_Hexstr(hMsg.opCode);
        if (this.DataTransportRecv(hMsg.status, 2, 1000) == -1) {
            return COMM_NON_FATAL_ERR;
        }
        revstr = revstr + Reader.bytes_Hexstr(hMsg.status);
        if (hMsg.dataLen[0] > 0) {
            if (this.DataTransportRecv(hMsg.data, hMsg.dataLen[0], 1000) == -1) {
                return COMM_NON_FATAL_ERR;
            }
            byte[] fdata = new byte[hMsg.dataLen[0]];
            System.arraycopy(hMsg.data, 0, fdata, 0, hMsg.dataLen[0]);
            revstr = revstr + Reader.bytes_Hexstr(fdata);
        }
        if (this.DataTransportRecv(hMsg.crc, 2, 1000) == -1) {
            return COMM_NON_FATAL_ERR;
        }
        this.toDlogAPI("revd:" + revstr + Reader.bytes_Hexstr(hMsg.crc));
        scrc = (short)((hMsg.crc[0] & 0xFF) << 8 | hMsg.crc[1] & 0xFF);
        if (R2000_calibration.calcCrc_short(hMsg.getcheckcrcdata()) != scrc) {
            if (this.FlushDummyData2Mod() != READER_ERR.MT_OK_ERR) {
                return READER_ERR.MT_IO_ERR.value();
            }
            return COMM_NON_FATAL_ERR;
        }
        if (err != READER_ERR.MT_OK_ERR && this.FlushDummyData2Mod() != READER_ERR.MT_OK_ERR) {
            return READER_ERR.MT_IO_ERR.value();
        }
        return 0;
    }

    public void addReadListener(ReadListener listener) {
        this.toDlogAPI("addReadListener");
        this.readListeners.add(listener);
    }

    public void removeReadListener(ReadListener listener) {
        this.toDlogAPI("removeReadListener");
        this.readListeners.remove(listener);
    }

    public void addReadExceptionListener(ReadExceptionListener listener) {
        this.toDlogAPI("addReadExceptionListener");
        this.readExceptionListeners.add(listener);
    }

    public void removeReadExceptionListener(ReadExceptionListener listener) {
        this.toDlogAPI("removeReadExceptionListener");
        this.readExceptionListeners.remove(listener);
    }

    public void addGpiTriggerListener(GpiTriggerListener listener) {
        this.toDlogAPI("addGpiTriggerListener");
        this.gpitriListener.add(listener);
    }

    public void removeGpiTriggerListener(GpiTriggerListener listener) {
        this.toDlogAPI("removeGpiTriggerListener");
        this.gpitriListener.remove(listener);
    }

    public void addGpiTriggerBoundaryListener(GpiTriggerBoundaryListener listener) {
        this.toDlogAPI("addGpiTriggerBoundaryListener");
        this.gpitriboundListener.add(listener);
    }

    public void removeGpiTriggerBoundaryListener(GpiTriggerBoundaryListener listener) {
        this.toDlogAPI("removeGpiTriggerBoundaryListener");
        this.gpitriboundListener.remove(listener);
    }

    private boolean GpiTriContains(GpiInfo_ST littleGInfo, GpiInfo_ST bigGInfo) {
        for (int i = 0; i < littleGInfo.gpiCount; ++i) {
            if (bigGInfo.gpiStats[littleGInfo.gpiStats[i].GpiId - 1].State == littleGInfo.gpiStats[i].State) continue;
            return false;
        }
        return true;
    }

    public READER_ERR StartReading(int[] ants, int antcnt, BackReadOption pBRO) {
        this.toDlogAPI("StartReading- [] " + String.valueOf(antcnt) + " " + (pBRO.IsFastRead ? "fast" : "general"));
        READER_ERR ERR = READER_ERR.MT_OK_ERR;
        if (this.m_IsReadingForAll) {
            return READER_ERR.MT_OP_EXECING;
        }
        this.m_IsReadingForAll = true;
        this.m_BackReadOp = pBRO;
        if (pBRO.IsGPITrigger) {
            int i;
            if ((pBRO.GpiTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1START_TIMEOUTSTOP || pBRO.GpiTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1ORTRI2START_TIMEOUTSTOP) && pBRO.GpiTrigger.StopTriggerTimeout < 5) {
                return READER_ERR.MT_INVALID_PARA;
            }
            HardwareDetails hd = new HardwareDetails();
            this.GetHardwareDetails(hd);
            int maxgpiid = hd.logictype == Reader_Type.MODULE_ARM7_FOUR_ANTS || hd.logictype == Reader_Type.M6E_ARM7_FOUR_ANTS || hd.logictype == Reader_Type.MODULE_ARM7_TWO_ANTS || hd.logictype == Reader_Type.SL_COMMN_READER ? 4 : 2;
            if (pBRO.GpiTrigger.GpiTrigger1States.gpiCount > maxgpiid) {
                return READER_ERR.MT_INVALID_PARA;
            }
            for (i = 0; i < pBRO.GpiTrigger.GpiTrigger1States.gpiCount; ++i) {
                if (pBRO.GpiTrigger.GpiTrigger1States.gpiStats[i].GpiId >= 1 && pBRO.GpiTrigger.GpiTrigger1States.gpiStats[i].GpiId <= maxgpiid) continue;
                return READER_ERR.MT_INVALID_PARA;
            }
            if (pBRO.GpiTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1START_TRI2STOP) {
                if (pBRO.GpiTrigger.GpiTrigger2States.gpiCount > maxgpiid) {
                    return READER_ERR.MT_INVALID_PARA;
                }
                for (i = 0; i < pBRO.GpiTrigger.GpiTrigger2States.gpiCount; ++i) {
                    if (pBRO.GpiTrigger.GpiTrigger2States.gpiStats[i].GpiId >= 1 && pBRO.GpiTrigger.GpiTrigger2States.gpiStats[i].GpiId <= maxgpiid) continue;
                    return READER_ERR.MT_INVALID_PARA;
                }
            }
        }
        if (this.m_BackReadOp.IsFastRead) {
            short flags = 0;
            if (this.m_BackReadOp.TMFlags.IsReadCnt) {
                flags = (short)(flags | 1);
            }
            if (this.m_BackReadOp.TMFlags.IsRSSI) {
                flags = (short)(flags | 2);
            }
            if (this.m_BackReadOp.TMFlags.IsAntennaID) {
                flags = (short)(flags | 4);
            }
            if (this.m_BackReadOp.TMFlags.IsFrequency) {
                flags = (short)(flags | 8);
            }
            if (this.m_BackReadOp.TMFlags.IsTimestamp) {
                flags = (short)(flags | 0x10);
            }
            if (this.m_BackReadOp.TMFlags.IsRFU) {
                flags = (short)(flags | 0x20);
            }
            if (this.m_BackReadOp.TMFlags.IsProtocol) {
                flags = (short)(flags | 0x40);
            }
            if (this.m_BackReadOp.TMFlags.IsEmdData) {
                flags = (short)(flags | 0x80);
            }
            this.m_BackReadOp.ReadDuration = 0;
            this.m_BackReadOp.ReadInterval = 50;
            this.m_FastReadOption = flags << 8 | this.m_BackReadOp.FastReadDutyRation | 0x80;
            if (!this.m_BackReadOp.IsGPITrigger) {
                int re = this.japi.AsyncStartReading(this.hReader[0], ants, antcnt, this.m_FastReadOption);
                ERR = this.errhandle(re);
                if (ERR != READER_ERR.MT_OK_ERR) {
                    return ERR;
                }
                this.toDlogAPI("AsyncStartReading ok opton:" + String.valueOf(this.m_FastReadOption));
            }
        }
        this.m_BackReadAntsCnt = antcnt;
        for (int i = 0; i < antcnt; ++i) {
            this.m_BackReadAnts[i] = ants[i];
        }
        Tagnotify tf = new Tagnotify(this);
        this.m_ThreadForAll = new Thread(tf);
        this.m_ThreadForAllid = this.m_ThreadForAll.getId();
        this.m_ThreadForAll.start();
        return ERR;
    }

    public READER_ERR StopReading() {
        READER_ERR ERR;
        this.toDlogAPI("StopReading");
        if (!this.m_IsReadingForAll) {
            return READER_ERR.MT_OK_ERR;
        }
        this.m_IsReadingForAll = false;
        Thread current = Thread.currentThread();
        if (current != null) {
            this.m_ThreadForAllid = current.getId();
        }
        if (this.m_ThreadForAllid == this.m_ThreadForAll.getId()) {
            READER_ERR ERR2;
            if (this.m_BackReadOp.IsFastRead && (ERR2 = this.AsyncStopReading()) != READER_ERR.MT_OK_ERR) {
                return ERR2;
            }
            return READER_ERR.MT_OK_ERR;
        }
        while (this.m_IsReadThRunning) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.m_ThreadForAll = null;
        if (this.m_BackReadOp.IsFastRead && (ERR = this.AsyncStopReading()) != READER_ERR.MT_OK_ERR) {
            return ERR;
        }
        return READER_ERR.MT_OK_ERR;
    }

    private READER_ERR errhandle(int re) {
        READER_ERR err = READER_ERR.valueOf(re);
        if (err != READER_ERR.MT_OK_ERR) {
            this.toDlogAPI("errhandle:" + String.valueOf(re) + " " + this.Mark);
            this.m_gError = re;
            if (this.m_BackReadOp.IsFastRead) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.AsyncStopReading();
            }
            this.m_IsReadingForAll = false;
            if (this.readExceptionListeners.size() > 0) {
                Exceptionotify exfy = new Exceptionotify(this, err);
                Thread tread = new Thread(exfy);
                tread.start();
            }
        }
        return err;
    }

    private READER_ERR errhandle2(READER_ERR err) {
        if (err != READER_ERR.MT_OK_ERR) {
            this.toDlogAPI("errhandle2:" + String.valueOf((Object)err) + " " + this.Mark);
            if (this.m_BackReadOp.IsFastRead) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.AsyncStopReading();
            }
            this.m_IsReadingForAll = false;
            if (this.readExceptionListeners.size() > 0) {
                Exceptionotify exfy = new Exceptionotify(this, err);
                Thread tread = new Thread(exfy);
                tread.start();
            }
        }
        return err;
    }

    public READER_ERR AsyncStartReading_IT(IT_MODE it_mode, int[] ants, int antcnt, int option) {
        this.toDlogAPI("AsyncStartReading_IT:" + it_mode.toString() + " l:" + antcnt + " o:" + option);
        this.it_mode_V = it_mode;
        if (this.it_mode_V == IT_MODE.IT_MODE_CT || this.it_mode_V == IT_MODE.IT_MODE_E7CT) {
            return this.AsyncStartReading_IT_CT(ants, antcnt, option);
        }
        if (this.it_mode_V == IT_MODE.IT_MODE_E7) {
            return READER_ERR.MT_OP_NOT_SUPPORTED;
        }
        if (this.it_mode_V == IT_MODE.IT_MODE_E7v2) {
            return READER_ERR.MT_OP_NOT_SUPPORTED;
        }
        if (this.it_mode_V == IT_MODE.IT_MODE_E7StopP) {
            return this.AsyncStartReading_IT_CT_StopP(ants, antcnt, option);
        }
        if (this.it_mode_V == IT_MODE.IT_MODE_E7AutoRe) {
            return this.AsyncStartReading_IT_AutoRe(ants, antcnt, option);
        }
        if (this.it_mode_V == IT_MODE.IT_MODE_E7AutoReV2) {
            return this.AsyncStartReading_IT_AutoRe_v2(ants, antcnt, option);
        }
        return READER_ERR.MT_OP_NOT_SUPPORTED;
    }

    public READER_ERR AsyncStartReading_IT_CT(int[] ants, int antcnt, int option) {
        Region_Conf[] rcf2 = new Region_Conf[1];
        READER_ERR er = this.ParamGet(Mtr_Param.MTR_PARAM_FREQUENCY_REGION, rcf2);
        if (er == READER_ERR.MT_OK_ERR && (rcf2[0] == Region_Conf.RG_NA || rcf2[0] == Region_Conf.RG_PRC)) {
            HoptableData_ST hdst2 = new HoptableData_ST();
            er = this.ParamGet(Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, hdst2);
            boolean isrestart = false;
            if (er == READER_ERR.MT_OK_ERR) {
                int j;
                boolean iscontain;
                if (rcf2[0] == Region_Conf.RG_NA) {
                    if (hdst2.lenhtb == 50) {
                        isrestart = true;
                    } else if (hdst2.lenhtb == this.IT_CT_fres_NA.length) {
                        for (int i = 0; i < hdst2.lenhtb; ++i) {
                            iscontain = false;
                            for (j = 0; j < this.IT_CT_fres_NA.length; ++j) {
                                if (hdst2.htb[i] != this.IT_CT_fres_NA[j]) continue;
                                iscontain = true;
                                break;
                            }
                            if (!iscontain) break;
                            if (i != hdst2.lenhtb - 1) continue;
                            isrestart = true;
                        }
                    }
                    if (isrestart) {
                        HoptableData_ST hdst = new HoptableData_ST();
                        hdst.lenhtb = this.IT_CT_fres_NA.length;
                        hdst.htb = this.IT_CT_fres_NA;
                        er = this.ParamSet(Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, hdst);
                        if (er != READER_ERR.MT_OK_ERR) {
                            return er;
                        }
                    }
                } else if (rcf2[0] == Region_Conf.RG_PRC) {
                    if (hdst2.lenhtb == 16) {
                        isrestart = true;
                    } else if (hdst2.lenhtb == this.IT_CT_fres_cn.length) {
                        for (int i = 0; i < hdst2.lenhtb; ++i) {
                            iscontain = false;
                            for (j = 0; j < this.IT_CT_fres_NA.length; ++j) {
                                if (hdst2.htb[i] != this.IT_CT_fres_NA[j]) continue;
                                iscontain = true;
                                break;
                            }
                            if (!iscontain) break;
                            if (i != hdst2.lenhtb - 1) continue;
                            isrestart = true;
                        }
                    }
                    if (isrestart) {
                        HoptableData_ST hdst = new HoptableData_ST();
                        hdst.lenhtb = this.IT_CT_fres_cn.length;
                        hdst.htb = this.IT_CT_fres_cn;
                        er = this.ParamSet(Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, hdst);
                        if (er != READER_ERR.MT_OK_ERR) {
                            return er;
                        }
                    }
                }
                if (er != READER_ERR.MT_OK_ERR) {
                    return er;
                }
            }
        }
        this.pants = ants;
        this.pantcnt = antcnt;
        this.poption = option;
        CustomParam_ST cpst = new CustomParam_ST();
        cpst.ParamName = "Reader/Ex10fastmode";
        byte[] vals = new byte[22];
        byte[] getvals = new byte[22];
        cpst.ParamVal = getvals;
        this.ParamGet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
        this.isExfastmode = getvals[0];
        vals[0] = this.it_mode_V == IT_MODE.IT_MODE_E7CT ? (byte)1 : 0;
        vals[1] = 20;
        for (int i = 0; i < 20; ++i) {
            vals[2 + i] = 0;
        }
        cpst.ParamVal = vals;
        this.ParamSet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
        er = this.AsyncStartReading(ants, antcnt, option);
        this.Reset_IT_CT();
        this.isIT_CT_run = true;
        IT_CT_notify tf = new IT_CT_notify(this);
        this.IT_CT_thread = new Thread(tf);
        this.IT_CT_step = this.IT_CT_step_init;
        this.IT_CT_thread.start();
        return er;
    }

    private READER_ERR AsyncStartReading_IT_CT_StopP(int[] ants, int antcnt, int option) {
        this.pants = ants;
        this.pantcnt = antcnt;
        this.poption = option;
        CustomParam_ST cpst = new CustomParam_ST();
        cpst.ParamName = "Reader/Ex10fastmode";
        byte[] vals = new byte[22];
        byte[] getvals = new byte[22];
        cpst.ParamVal = getvals;
        this.ParamGet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
        this.isExfastmode = getvals[0];
        vals[0] = 1;
        vals[1] = 20;
        for (int i = 0; i < 20; ++i) {
            vals[2 + i] = 0;
        }
        cpst.ParamVal = vals;
        READER_ERR er = this.ParamSet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
        er = this.AsyncStartReading(ants, antcnt, option);
        this.Reset_IT_CT();
        this.isIT_CT_run = true;
        IT_CT_StopP_notify tf = new IT_CT_StopP_notify(this);
        this.IT_CT_thread = new Thread(tf);
        this.IT_CT_step = 4;
        this.IT_CT_thread.start();
        return er;
    }

    private READER_ERR AsyncStartReading_IT_AutoRe(int[] ants, int antcnt, int option) {
        this.pants = ants;
        this.pantcnt = antcnt;
        this.poption = option;
        CustomParam_ST cpst = new CustomParam_ST();
        cpst.ParamName = "Reader/Ex10fastmode";
        byte[] vals = new byte[22];
        byte[] getvals = new byte[22];
        cpst.ParamVal = getvals;
        this.ParamGet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
        this.isExfastmode = getvals[0];
        vals[0] = 1;
        vals[1] = 20;
        for (int i = 0; i < 20; ++i) {
            vals[2 + i] = 0;
        }
        cpst.ParamVal = vals;
        READER_ERR er = this.ParamSet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
        er = this.AsyncStartReading(ants, antcnt, option);
        this.Reset_IT_CT();
        this.isIT_CT_run = true;
        IT_AutoRe_notify tf = new IT_AutoRe_notify(this);
        this.IT_CT_thread = new Thread(tf);
        this.IT_CT_thread.start();
        return er;
    }

    private READER_ERR AsyncStartReading_IT_AutoRe_v2(int[] ants, int antcnt, int option) {
        this.pants = ants;
        this.pantcnt = antcnt;
        this.poption = option;
        CustomParam_ST cpst = new CustomParam_ST();
        cpst.ParamName = "Reader/Ex10fastmode";
        byte[] vals = new byte[22];
        byte[] getvals = new byte[22];
        cpst.ParamVal = getvals;
        this.ParamGet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
        this.isExfastmode = getvals[0];
        vals[0] = 0;
        vals[1] = 20;
        for (int i = 0; i < 20; ++i) {
            vals[2 + i] = 0;
        }
        cpst.ParamVal = vals;
        READER_ERR er = this.ParamSet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET, new int[]{0});
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION, new int[]{2});
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_Q, new int[]{-1});
        HoptableData_ST hdst2 = new HoptableData_ST();
        er = this.ParamGet(Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, hdst2);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        int[] tablefre = this.Sort(hdst2.htb, hdst2.lenhtb);
        this.IT_E7_centrefre = tablefre[tablefre.length / 2];
        this.IT_E7_lowfre = tablefre[0];
        this.IT_E7_highfre = tablefre[tablefre.length - 1];
        AntPowerConf apcf2 = new AntPowerConf();
        er = this.ParamGet(Mtr_Param.MTR_PARAM_RF_ANTPOWER, apcf2);
        if (er == READER_ERR.MT_OK_ERR) {
            this.IT_E7_pow = apcf2.Powers[0].readPower;
        }
        er = this.AsyncStartReading(ants, antcnt, option);
        this.Reset_IT_CT();
        this.isIT_CT_run = true;
        IT_AutoRe_notify2 tf = new IT_AutoRe_notify2(this, ants);
        this.IT_CT_thread = new Thread(tf);
        this.IT_CT_thread.start();
        return er;
    }

    int[] Sort(int[] array, int len) {
        int tmpIntValue = 0;
        for (int xIndex = 0; xIndex < len; ++xIndex) {
            for (int yIndex = 0; yIndex < len; ++yIndex) {
                if (array[xIndex] >= array[yIndex]) continue;
                tmpIntValue = array[xIndex];
                array[xIndex] = array[yIndex];
                array[yIndex] = tmpIntValue;
            }
        }
        int[] reary = new int[len];
        System.arraycopy(array, 0, reary, 0, len);
        return reary;
    }

    public READER_ERR AsyncStopReading_IT_CT() {
        this.isIT_CT_run = false;
        READER_ERR err = this.AsyncStopReading();
        if (this.IT_CT_thread != null) {
            try {
                this.IT_CT_thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return err;
    }

    public READER_ERR AsyncStopReading_IT() {
        if (this.it_mode_V == IT_MODE.IT_MODE_CT || this.it_mode_V == IT_MODE.IT_MODE_E7CT) {
            READER_ERR er = this.AsyncStopReading_IT_CT();
            CustomParam_ST cpst = new CustomParam_ST();
            cpst.ParamName = "Reader/Ex10fastmode";
            byte[] vals = new byte[22];
            if (this.isExfastmode == 0) {
                vals[0] = 0;
                vals[1] = 20;
                for (int i = 0; i < 20; ++i) {
                    vals[2 + i] = 0;
                }
                cpst.ParamVal = vals;
                this.ParamSet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
            } else {
                vals[0] = 1;
                vals[1] = 20;
                for (int i = 0; i < 20; ++i) {
                    vals[2 + i] = 0;
                }
                cpst.ParamVal = vals;
                this.ParamSet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
            }
            return er;
        }
        if (this.it_mode_V == IT_MODE.IT_MODE_E7 || this.it_mode_V == IT_MODE.IT_MODE_E7v2) {
            this.isIT_E7_run = false;
            READER_ERR err = this.AsyncStopReading();
            if (this.IT_E7_thread != null) {
                try {
                    this.IT_E7_thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.SetFilterSessioninTargetA(this.pants, this.IT_E7_centrefre, this.IT_E7_pow);
            if (this.it_mode_V == IT_MODE.IT_MODE_E7v2) {
                this.SetFilterSessioninTargetA(this.pants, this.IT_E7_lowfre, this.IT_E7_pow);
                this.SetFilterSessioninTargetA(this.pants, this.IT_E7_highfre, this.IT_E7_pow);
            }
            return err;
        }
        if (this.it_mode_V == IT_MODE.IT_MODE_S2) {
            this.isIT_S2_run = false;
            READER_ERR err = this.AsyncStopReading();
            if (this.IT_S2_thread != null) {
                try {
                    this.IT_S2_thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return err;
        }
        if (this.it_mode_V == IT_MODE.IT_MODE_E7StopP || this.it_mode_V == IT_MODE.IT_MODE_E7AutoRe || this.it_mode_V == IT_MODE.IT_MODE_E7AutoReV2) {
            return this.AsyncStopReading_IT_CT();
        }
        return READER_ERR.MT_OP_INVALID;
    }

    public void Reset_IT_CT() {
        this.quetagstr.clear();
        this.totalcount = 0;
        this.totalcountlast = 0;
        this.IT_CT_step = this.IT_CT_step_init != -1 ? this.IT_CT_step_init : 0;
        this.IT_CT_c = 0;
        this.IT_CT_start = System.currentTimeMillis();
        this.vstaticstarttick = System.currentTimeMillis() - this.IT_CT_start;
    }

    public void Reset_IT() {
        if (this.it_mode_V == IT_MODE.IT_MODE_CT || this.it_mode_V == IT_MODE.IT_MODE_E7CT) {
            this.Reset_IT_CT();
            if (this.it_mode_V == IT_MODE.IT_MODE_E7CT) {
                this.it_mode_V = IT_MODE.IT_MODE_CT;
            }
        } else if (this.it_mode_V == IT_MODE.IT_MODE_E7 || this.it_mode_V == IT_MODE.IT_MODE_E7v2) {
            this.IT_E7_start = System.currentTimeMillis();
            this.vstaticstarttick = System.currentTimeMillis() - this.IT_E7_start;
        } else if (this.it_mode_V == IT_MODE.IT_MODE_S2) {
            this.IT_S2_start = System.currentTimeMillis();
            this.vstaticstarttick = System.currentTimeMillis() - this.IT_S2_start;
        }
    }

    private READER_ERR errhandle_IT(READER_ERR err) {
        if (err != READER_ERR.MT_OK_ERR) {
            if (this.it_mode_V == IT_MODE.IT_MODE_CT || this.it_mode_V == IT_MODE.IT_MODE_E7CT) {
                this.isIT_CT_run = false;
            } else if (this.it_mode_V == IT_MODE.IT_MODE_S2) {
                this.isIT_S2_run = false;
            } else if (this.it_mode_V == IT_MODE.IT_MODE_E7 || this.it_mode_V == IT_MODE.IT_MODE_E7v2) {
                this.isIT_E7_run = false;
            }
            this.AsyncStopReading();
            if (this.readExceptionListeners.size() > 0) {
                Exceptionotify exfy = new Exceptionotify(this, err);
                Thread tread = new Thread(exfy);
                tread.start();
            }
        }
        return err;
    }

    private class IT_AutoRe_notify2
    implements Runnable {
        Reader reader;
        int[] ants;

        public IT_AutoRe_notify2(Reader rd, int[] pants) {
            this.reader = rd;
            this.ants = pants;
        }

        @Override
        public void run() {
            while (Reader.this.isIT_CT_run) {
                long readtime_spp;
                TAGINFO[] tag = null;
                int[] tagcnt = new int[]{0};
                READER_ERR er = Reader.this.AsyncGetTagCount(tagcnt);
                if (er == READER_ERR.MT_OK_ERR && tagcnt[0] > 0) {
                    Vector<TAGINFO> tagv = new Vector<TAGINFO>();
                    for (int i = 0; i < tagcnt[0]; ++i) {
                        TAGINFO tfs = new TAGINFO();
                        er = Reader.this.AsyncGetNextTag(tfs);
                        if (er == READER_ERR.MT_OK_ERR) {
                            if (!Reader.this.quetagstr.contains(Reader.bytes_Hexstr(tfs.EpcId))) {
                                Reader.this.quetagstr.add(Reader.bytes_Hexstr(tfs.EpcId));
                                ++Reader.this.totalcount;
                            }
                        } else {
                            Reader.this.errhandle_IT(er);
                            break;
                        }
                        tagv.add(tfs);
                    }
                    tag = new TAGINFO[tagv.size()];
                    tag = tagv.toArray(tag);
                    if (Reader.this.readListeners.size() > 0 && tag.length > 0) {
                        for (ReadListener rl : Reader.this.readListeners) {
                            if (Reader.this.hReader[0] == 0) break;
                            rl.tagRead(this.reader, tag);
                        }
                    }
                }
                if ((readtime_spp = System.currentTimeMillis() - Reader.this.IT_CT_start) < (long)Reader.this.unitms) continue;
                Reader.this.toDlogAPI("lastcount size:" + Reader.this.lastcount + " addcount:" + Reader.this.totalcount);
                Reader.this.lastcount.add(Reader.this.totalcount);
                if (Reader.this.lastcount.size() >= Reader.this.IT_AutoRe_time / Reader.this.unitms) {
                    int all = 0;
                    for (int i = 0; i < Reader.this.lastcount.size(); ++i) {
                        all += Reader.this.lastcount.get(i).intValue();
                    }
                    Reader.this.toDlogAPI("all:" + all);
                    if (all < Reader.this.IT_AutoRe_count) {
                        er = Reader.this.AsyncStopReading();
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        Reader.this.lastcount.clear();
                        Reader.this.SetFilterSessioninTargetA(this.ants, Reader.this.IT_E7_lowfre, Reader.this.IT_E7_pow);
                        Reader.this.SetFilterSessioninTargetA(this.ants, Reader.this.IT_E7_centrefre, Reader.this.IT_E7_pow);
                        Reader.this.SetFilterSessioninTargetA(this.ants, Reader.this.IT_E7_highfre, Reader.this.IT_E7_pow);
                        er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET, new int[]{0});
                        er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION, new int[]{2});
                        er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_Q, new int[]{-1});
                        if (Reader.this.isIT_CT_run) {
                            er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pantcnt, Reader.this.poption);
                        }
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                    } else {
                        Reader.this.lastcount.remove(0);
                    }
                }
                Reader.this.quetagstr.clear();
                Reader.this.totalcount = 0;
                Reader.this.IT_CT_start = System.currentTimeMillis();
            }
        }
    }

    private class IT_AutoRe_notify
    implements Runnable {
        Reader reader;

        public IT_AutoRe_notify(Reader rd) {
            this.reader = rd;
        }

        @Override
        public void run() {
            while (Reader.this.isIT_CT_run) {
                long readtime_spp;
                TAGINFO[] tag = null;
                int[] tagcnt = new int[]{0};
                READER_ERR er = Reader.this.AsyncGetTagCount(tagcnt);
                if (er == READER_ERR.MT_OK_ERR && tagcnt[0] > 0) {
                    Vector<TAGINFO> tagv = new Vector<TAGINFO>();
                    for (int i = 0; i < tagcnt[0]; ++i) {
                        TAGINFO tfs = new TAGINFO();
                        er = Reader.this.AsyncGetNextTag(tfs);
                        if (er == READER_ERR.MT_OK_ERR) {
                            if (!Reader.this.quetagstr.contains(Reader.bytes_Hexstr(tfs.EpcId))) {
                                Reader.this.quetagstr.add(Reader.bytes_Hexstr(tfs.EpcId));
                                ++Reader.this.totalcount;
                            }
                        } else {
                            Reader.this.errhandle_IT(er);
                            break;
                        }
                        tagv.add(tfs);
                    }
                    tag = new TAGINFO[tagv.size()];
                    tag = tagv.toArray(tag);
                    if (Reader.this.readListeners.size() > 0 && tag.length > 0) {
                        for (ReadListener rl : Reader.this.readListeners) {
                            if (Reader.this.hReader[0] == 0) break;
                            rl.tagRead(this.reader, tag);
                        }
                    }
                }
                if ((readtime_spp = System.currentTimeMillis() - Reader.this.IT_CT_start) < (long)Reader.this.unitms) continue;
                Reader.this.toDlogAPI("lastcount size:" + Reader.this.lastcount + " addcount:" + Reader.this.totalcount);
                Reader.this.lastcount.add(Reader.this.totalcount);
                if (Reader.this.lastcount.size() >= Reader.this.IT_AutoRe_time / Reader.this.unitms) {
                    int all = 0;
                    for (int i = 0; i < Reader.this.lastcount.size(); ++i) {
                        all += Reader.this.lastcount.get(i).intValue();
                    }
                    Reader.this.toDlogAPI("all:" + all);
                    if (all < Reader.this.IT_AutoRe_count) {
                        er = Reader.this.AsyncStopReading();
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        Reader.this.lastcount.clear();
                        if (Reader.this.isIT_CT_run) {
                            er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pantcnt, Reader.this.poption);
                        }
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                    } else {
                        Reader.this.lastcount.remove(0);
                    }
                }
                Reader.this.quetagstr.clear();
                Reader.this.totalcount = 0;
                Reader.this.IT_CT_start = System.currentTimeMillis();
            }
        }
    }

    private class IT_CT_StopP_notify
    implements Runnable {
        Reader reader;

        public IT_CT_StopP_notify(Reader rd) {
            this.reader = rd;
        }

        @Override
        public void run() {
            while (Reader.this.isIT_CT_run) {
                long readtime_spp;
                TAGINFO[] tag = null;
                int[] tagcnt = new int[]{0};
                READER_ERR er = Reader.this.AsyncGetTagCount(tagcnt);
                Reader.this.toDlogAPI("gettagcount:" + String.valueOf(tagcnt[0]));
                if (er != READER_ERR.MT_OK_ERR) {
                    Reader.this.errhandle_IT(er);
                    break;
                }
                if (tagcnt[0] > 0) {
                    Vector<TAGINFO> tagv = new Vector<TAGINFO>();
                    for (int i = 0; i < tagcnt[0]; ++i) {
                        TAGINFO tfs = new TAGINFO();
                        er = Reader.this.AsyncGetNextTag(tfs);
                        if (er == READER_ERR.MT_OK_ERR) {
                            if (!Reader.this.quetagstr.contains(Reader.bytes_Hexstr(tfs.EpcId))) {
                                Reader.this.quetagstr.add(Reader.bytes_Hexstr(tfs.EpcId));
                                ++Reader.this.totalcount;
                            }
                        } else {
                            Reader.this.errhandle_IT(er);
                            break;
                        }
                        tagv.add(tfs);
                    }
                    tag = new TAGINFO[tagv.size()];
                    tag = tagv.toArray(tag);
                    if (Reader.this.readListeners.size() > 0 && tag.length > 0) {
                        for (ReadListener rl : Reader.this.readListeners) {
                            if (Reader.this.hReader[0] != 0) {
                                rl.tagRead(this.reader, tag);
                                continue;
                            }
                            break;
                        }
                    }
                }
                if ((readtime_spp = System.currentTimeMillis() - Reader.this.IT_CT_start) - Reader.this.vstaticstarttick >= (long)Reader.this.IT_CT_m3_cycleread) {
                    Reader.this.toDlogAPI("Nowcyc: tick:" + String.valueOf(readtime_spp - Reader.this.vstaticstarttick));
                    Reader.this.vstaticstarttick = readtime_spp;
                    if (Reader.this.IT_CT_step == 4 && Reader.this.isIT_CT_run) {
                        er = Reader.this.AsyncStopReading();
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        long st_time = System.currentTimeMillis();
                        do {
                            try {
                                if (!Reader.this.isIT_CT_run) break;
                                Thread.sleep(50L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        } while (System.currentTimeMillis() - st_time <= (long)Reader.this.IT_CT_m3_cyclestop);
                        if (Reader.this.isIT_CT_run) {
                            er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pantcnt, Reader.this.poption);
                        }
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        Reader.this.IT_CT_start = System.currentTimeMillis();
                        Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                    }
                    Reader.this.totalcountlast = Reader.this.totalcount;
                }
                if (Reader.this.isIT_CT_run) continue;
                break;
            }
        }
    }

    private class IT_CT_notify
    implements Runnable {
        Reader reader;

        public IT_CT_notify(Reader rd) {
            this.reader = rd;
        }

        @Override
        public void run() {
            while (Reader.this.isIT_CT_run) {
                int nowcyc;
                TAGINFO[] tag = null;
                int[] tagcnt = new int[]{0};
                READER_ERR er = Reader.this.AsyncGetTagCount(tagcnt);
                if (er != READER_ERR.MT_OK_ERR) {
                    Reader.this.errhandle_IT(er);
                    break;
                }
                if (tagcnt[0] > 0) {
                    Vector<TAGINFO> tagv = new Vector<TAGINFO>();
                    for (int i = 0; i < tagcnt[0]; ++i) {
                        TAGINFO tfs = new TAGINFO();
                        er = Reader.this.AsyncGetNextTag(tfs);
                        if (er == READER_ERR.MT_OK_ERR) {
                            if (!Reader.this.quetagstr.contains(Reader.bytes_Hexstr(tfs.EpcId))) {
                                Reader.this.quetagstr.add(Reader.bytes_Hexstr(tfs.EpcId));
                                ++Reader.this.totalcount;
                            }
                        } else {
                            Reader.this.errhandle_IT(er);
                            break;
                        }
                        tagv.add(tfs);
                    }
                    tag = new TAGINFO[tagv.size()];
                    tag = tagv.toArray(tag);
                    if (Reader.this.readListeners.size() > 0 && tag.length > 0) {
                        for (ReadListener rl : Reader.this.readListeners) {
                            if (Reader.this.hReader[0] != 0) {
                                rl.tagRead(this.reader, tag);
                                continue;
                            }
                            break;
                        }
                    }
                }
                long readtime_spp = System.currentTimeMillis() - Reader.this.IT_CT_start;
                if (Reader.this.IT_CT_step == 0 && Reader.this.isIT_CT_run && readtime_spp >= (long)(Reader.this.IT_CT_m1_keep * 1000)) {
                    if (Reader.this.it_mode_V == IT_MODE.IT_MODE_E7CT) {
                        er = Reader.this.AsyncStopReading();
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        CustomParam_ST cpst = new CustomParam_ST();
                        cpst.ParamName = "Reader/Ex10fastmode";
                        byte[] vals = new byte[22];
                        vals[0] = 0;
                        vals[1] = 20;
                        for (int i = 0; i < 20; ++i) {
                            vals[2 + i] = 0;
                        }
                        cpst.ParamVal = vals;
                        Reader.this.ParamSet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
                        if (Reader.this.isIT_CT_run) {
                            er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption);
                        }
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                    }
                    Reader.this.IT_CT_step = 1;
                    Reader.this.IT_CT_start = System.currentTimeMillis();
                    Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                }
                if (Reader.this.IT_CT_step == 5 && Reader.this.isIT_CT_run && readtime_spp >= (long)(Reader.this.IT_CT_m1_keep * 1000)) {
                    Reader.this.IT_CT_step = 6;
                    Reader.this.IT_CT_start = System.currentTimeMillis();
                    Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                }
                if (readtime_spp - Reader.this.vstaticstarttick >= (long)(nowcyc = Reader.this.IT_CT_step == 0 || Reader.this.IT_CT_step == 1 || Reader.this.IT_CT_step == 5 ? Reader.this.IT_CT_m1_cycle : (Reader.this.IT_CT_step == 2 || Reader.this.IT_CT_step == 3 ? Reader.this.IT_CT_m2_cycle : (Reader.this.IT_CT_step == 4 || Reader.this.IT_CT_step == 6 ? Reader.this.IT_CT_m3_cycleread : 1000)))) {
                    int i;
                    CustomParam_ST cpst;
                    Reader.this.vstaticstarttick = readtime_spp;
                    if (Reader.this.IT_CT_step == 1 && Reader.this.isIT_CT_run) {
                        if (Reader.this.totalcount - Reader.this.totalcountlast < Reader.this.IT_CT_m1_toma) {
                            Reader.this.IT_CT_step = 4;
                            Reader.this.IT_CT_c = 0;
                            Reader.this.IT_CT_start = System.currentTimeMillis();
                            Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                        }
                    } else if (Reader.this.IT_CT_step == 2 && Reader.this.isIT_CT_run) {
                        er = Reader.this.AsyncStopReading();
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        if (Reader.this.isIT_CT_run) {
                            er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption);
                        }
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        if (++Reader.this.IT_CT_c >= Reader.this.IT_CT_m2_keepcount) {
                            Reader.this.IT_CT_step = 3;
                            Reader.this.IT_CT_start = System.currentTimeMillis();
                            Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                        }
                    } else if (Reader.this.IT_CT_step == 3 && Reader.this.isIT_CT_run) {
                        if (Reader.this.totalcount - Reader.this.totalcountlast < Reader.this.IT_CT_m2_tomc) {
                            Reader.this.IT_CT_step = 4;
                            Reader.this.IT_CT_start = System.currentTimeMillis();
                            Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                        } else if (Reader.this.totalcount - Reader.this.totalcountlast > Reader.this.IT_CT_m2_toma) {
                            if (Reader.this.it_mode_V == IT_MODE.IT_MODE_E7CT) {
                                er = Reader.this.AsyncStopReading();
                                if (er != READER_ERR.MT_OK_ERR) {
                                    Reader.this.errhandle_IT(er);
                                }
                                cpst = new CustomParam_ST();
                                cpst.ParamName = "Reader/Ex10fastmode";
                                byte[] vals = new byte[22];
                                vals[0] = 1;
                                vals[1] = 20;
                                for (i = 0; i < 20; ++i) {
                                    vals[2 + i] = 0;
                                }
                                cpst.ParamVal = vals;
                                Reader.this.ParamSet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
                                if (Reader.this.isIT_CT_run) {
                                    er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption);
                                }
                                if (er != READER_ERR.MT_OK_ERR) {
                                    Reader.this.errhandle_IT(er);
                                }
                            }
                            Reader.this.IT_CT_step = 0;
                            Reader.this.IT_CT_start = System.currentTimeMillis();
                            Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                        }
                    } else if ((Reader.this.IT_CT_step == 4 || Reader.this.IT_CT_step == 6) && Reader.this.isIT_CT_run) {
                        if (Reader.this.totalcount - Reader.this.totalcountlast > Reader.this.IT_CT_m3_toma) {
                            if (Reader.this.it_mode_V == IT_MODE.IT_MODE_E7CT) {
                                er = Reader.this.AsyncStopReading();
                                if (er != READER_ERR.MT_OK_ERR) {
                                    Reader.this.errhandle_IT(er);
                                }
                                cpst = new CustomParam_ST();
                                cpst.ParamName = "Reader/Ex10fastmode";
                                byte[] vals = new byte[22];
                                vals[0] = 1;
                                vals[1] = 20;
                                for (i = 0; i < 20; ++i) {
                                    vals[2 + i] = 0;
                                }
                                cpst.ParamVal = vals;
                                Reader.this.ParamSet(Mtr_Param.MTR_PARAM_CUSTOM, cpst);
                                if (Reader.this.isIT_CT_run) {
                                    er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption);
                                }
                                if (er != READER_ERR.MT_OK_ERR) {
                                    Reader.this.errhandle_IT(er);
                                }
                            }
                            Reader.this.IT_CT_step = 0;
                        } else {
                            er = Reader.this.AsyncStopReading();
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            long st_time = System.currentTimeMillis();
                            do {
                                try {
                                    if (!Reader.this.isIT_CT_run) break;
                                    Thread.sleep(50L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            } while (System.currentTimeMillis() - st_time <= (long)Reader.this.IT_CT_m3_cyclestop);
                            if (Reader.this.isIT_CT_run) {
                                er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pantcnt, Reader.this.poption);
                            }
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                        }
                        Reader.this.IT_CT_start = System.currentTimeMillis();
                        Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                    }
                    Reader.this.totalcountlast = Reader.this.totalcount;
                }
                if (Reader.this.isIT_CT_run) continue;
                break;
            }
        }
    }

    private class Tagnotify
    implements Runnable {
        Reader reader;

        public Tagnotify(Reader rd) {
            this.reader = rd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Reader.this.toDlogAPI("run");
            int re = 0;
            TAGINFO[] tag = null;
            Reader.this.m_IsReadThRunning = true;
            boolean isGpiTrigger = false;
            boolean isGpiTriStop = false;
            int startgpitriid = 0;
            GPITrigger pGTrigger = Reader.this.m_BackReadOp.GpiTrigger;
            long dtwstart = System.currentTimeMillis();
            long timenow = System.currentTimeMillis();
            BackReadGpiTriState BRGstate = BackReadGpiTriState.BackReadGpi_WaitStart;
            if (Reader.this.m_BackReadOp.IsGPITrigger) {
                isGpiTrigger = true;
                if (Reader.this.m_BackReadOp.GpiTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1START_TRI2STOP) {
                    isGpiTriStop = true;
                }
                pGTrigger = Reader.this.m_BackReadOp.GpiTrigger;
                Reader.this.toDlogAPI("GpiTrigger true:" + (Object)((Object)pGTrigger.TriggerType) + " gpitriListener size:" + Reader.this.gpitriListener.size() + " gpitriboundListener" + Reader.this.gpitriboundListener.size());
            }
            block26: while (Reader.this.m_IsReadingForAll) {
                Reader isStart22;
                if (isGpiTrigger) {
                    Iterator<GpiTriggerBoundaryListener> iterator;
                    Iterator<GpiTriggerBoundaryListener> gstates;
                    boolean isStart22 = true;
                    boolean isStop = true;
                    if (BRGstate == BackReadGpiTriState.BackReadGpi_WaitStart) {
                        gstates = new GpiInfo_ST();
                        iterator = this.reader;
                        synchronized (iterator) {
                            re = Reader.this.japi.Get_GPIEx(Reader.this.hReader[0], (GpiInfo_ST)((Object)gstates));
                        }
                        Reader.this.Mark = " E1";
                        if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                        isStart22 = Reader.this.GpiTriContains(pGTrigger.GpiTrigger1States, gstates);
                        if (isStart22) {
                            startgpitriid = 1;
                            if (Reader.this.gpitriListener.size() > 0) {
                                for (GpiTriggerListener gpiTriggerListener : Reader.this.gpitriListener) {
                                    if (Reader.this.hReader[0] != 0) {
                                        gpiTriggerListener.GpiTrigger(this.reader, (GpiInfo_ST)((Object)gstates), startgpitriid);
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else if (pGTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1ORTRI2START_TIMEOUTSTOP && (isStart22 = Reader.this.GpiTriContains(pGTrigger.GpiTrigger2States, gstates))) {
                            startgpitriid = 2;
                            if (Reader.this.gpitriListener.size() > 0) {
                                for (GpiTriggerListener gpiTriggerListener : Reader.this.gpitriListener) {
                                    if (Reader.this.hReader[0] != 0) {
                                        gpiTriggerListener.GpiTrigger(this.reader, (GpiInfo_ST)((Object)gstates), startgpitriid);
                                        continue;
                                    }
                                    break;
                                }
                            }
                        }
                        if (!isStart22) continue;
                        if (Reader.this.gpitriboundListener.size() > 0) {
                            for (GpiTriggerBoundaryListener gpiTriggerBoundaryListener : Reader.this.gpitriboundListener) {
                                if (Reader.this.hReader[0] == 0) break;
                                gpiTriggerBoundaryListener.GpiTriggerBoundary(this.reader, GpiTriggerBoundaryType.GPITriggerBoundary_StartInventory, GpiTriggerBoundaryReasonType.GpiTriggerBoundaryReason_ByGpi);
                            }
                        }
                        if (isGpiTriStop) {
                            BRGstate = BackReadGpiTriState.BackReadGpi_WaitStop;
                        } else {
                            dtwstart = System.currentTimeMillis();
                            BRGstate = BackReadGpiTriState.BackReadGpi_WaitTimeout;
                        }
                        if (Reader.this.m_BackReadOp.IsFastRead) {
                            iterator = this.reader;
                            synchronized (iterator) {
                                re = Reader.this.japi.AsyncStartReading(Reader.this.hReader[0], Reader.this.m_BackReadAnts, Reader.this.m_BackReadAntsCnt, Reader.this.m_FastReadOption);
                            }
                            Reader.this.toDlogAPI("AsyncStartReading ok opton:" + String.valueOf(Reader.this.m_FastReadOption) + " startgpitriid:" + String.valueOf(startgpitriid));
                        }
                    } else if (BRGstate == BackReadGpiTriState.BackReadGpi_WaitStop) {
                        gstates = new GpiInfo_ST();
                        iterator = this.reader;
                        synchronized (iterator) {
                            re = Reader.this.japi.Get_GPIEx(Reader.this.hReader[0], (GpiInfo_ST)((Object)gstates));
                        }
                        Reader.this.Mark = " E2";
                        if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                        isStop = Reader.this.GpiTriContains(pGTrigger.GpiTrigger2States, gstates);
                        if (isStop) {
                            if (Reader.this.gpitriListener.size() > 0) {
                                for (GpiTriggerListener gpiTriggerListener : Reader.this.gpitriListener) {
                                    if (Reader.this.hReader[0] == 0) break;
                                    gpiTriggerListener.GpiTrigger(this.reader, (GpiInfo_ST)((Object)gstates), 2);
                                }
                            }
                            BRGstate = BackReadGpiTriState.BackReadGpi_WaitStart;
                            if (Reader.this.m_BackReadOp.IsFastRead) {
                                iterator = this.reader;
                                synchronized (iterator) {
                                    re = Reader.this.japi.AsyncStopReading(Reader.this.hReader[0]);
                                }
                                Reader.this.Mark = " E3";
                                if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                                Reader.this.toDlogAPI("AsyncStopReading:E3");
                            }
                            if (Reader.this.gpitriboundListener.size() <= 0) continue;
                            for (GpiTriggerBoundaryListener gpiTriggerBoundaryListener : Reader.this.gpitriboundListener) {
                                if (Reader.this.hReader[0] == 0) continue block26;
                                gpiTriggerBoundaryListener.GpiTriggerBoundary(this.reader, GpiTriggerBoundaryType.GPITriggerBoundary_StopInventory, GpiTriggerBoundaryReasonType.GpiTriggerBoundaryReason_ByGpi);
                            }
                            continue;
                        }
                    } else if (BRGstate == BackReadGpiTriState.BackReadGpi_WaitTimeout) {
                        if (pGTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1ORTRI2START_TIMEOUTSTOP) {
                            gstates = new GpiInfo_ST();
                            GpiInfo_ST ptmpgpiinfo = new GpiInfo_ST();
                            Reader reader = this.reader;
                            synchronized (reader) {
                                re = Reader.this.japi.Get_GPIEx(Reader.this.hReader[0], (GpiInfo_ST)((Object)gstates));
                            }
                            Reader.this.Mark = " E4";
                            if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                            if (startgpitriid == 1) {
                                ptmpgpiinfo = pGTrigger.GpiTrigger2States;
                            } else if (startgpitriid == 2) {
                                ptmpgpiinfo = pGTrigger.GpiTrigger1States;
                            }
                            if (Reader.this.GpiTriContains(ptmpgpiinfo, gstates) && Reader.this.gpitriListener.size() > 0) {
                                for (GpiTriggerListener rl : Reader.this.gpitriListener) {
                                    if (Reader.this.hReader[0] == 0) break;
                                    rl.GpiTrigger(this.reader, (GpiInfo_ST)((Object)gstates), 3 - startgpitriid);
                                }
                            }
                        }
                        if ((timenow = System.currentTimeMillis()) - dtwstart > (long)Reader.this.m_BackReadOp.GpiTrigger.StopTriggerTimeout) {
                            BRGstate = BackReadGpiTriState.BackReadGpi_WaitStart;
                            if (Reader.this.m_BackReadOp.IsFastRead) {
                                gstates = this.reader;
                                synchronized (gstates) {
                                    re = Reader.this.japi.AsyncStopReading(Reader.this.hReader[0]);
                                }
                                Reader.this.Mark = " E5";
                                if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                                Reader.this.toDlogAPI("AsyncStopReading:E5");
                            }
                            if (Reader.this.gpitriboundListener.size() <= 0) continue;
                            for (GpiTriggerBoundaryListener rl : Reader.this.gpitriboundListener) {
                                if (Reader.this.hReader[0] == 0) continue block26;
                                rl.GpiTriggerBoundary(this.reader, GpiTriggerBoundaryType.GPITriggerBoundary_StopInventory, GpiTriggerBoundaryReasonType.GpiTriggerBoundaryReason_ByTimeout);
                            }
                            continue;
                        }
                    }
                }
                int[] tagcnt = new int[1];
                if (Reader.this.m_BackReadOp.IsFastRead) {
                    tagcnt[0] = 0;
                    isStart22 = this.reader;
                    synchronized (isStart22) {
                        re = Reader.this.japi.AsyncGetTagCount(Reader.this.hReader[0], tagcnt);
                    }
                    Reader.this.Mark = " E6";
                    Reader.this.toDlogAPI("read tag:" + String.valueOf(tagcnt[0]));
                    if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) {
                        continue;
                    }
                } else {
                    isStart22 = this.reader;
                    synchronized (isStart22) {
                        re = Reader.this.japi.TagInventory_Raw(Reader.this.hReader[0], Reader.this.m_BackReadAnts, Reader.this.m_BackReadAntsCnt, Reader.this.m_BackReadOp.ReadDuration, tagcnt);
                    }
                    if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                }
                Vector<TAGINFO> tagv = new Vector<TAGINFO>();
                for (int i = 0; i < tagcnt[0]; ++i) {
                    TAGINFO stag = new TAGINFO();
                    if (Reader.this.m_IsReadingForAll) {
                        if (Reader.this.m_BackReadOp.IsFastRead) {
                            if (Reader.this.errhandle2(this.reader.AsyncGetNextTag(stag)) != READER_ERR.MT_OK_ERR) {
                                Reader.this.toDlogAPI(String.valueOf(re) + " E7");
                                continue;
                            }
                        } else {
                            re = Reader.this.GetNextTag(stag).value;
                            Reader.this.Mark = " E8";
                            if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                        }
                        tagv.add(stag);
                    }
                    if (!Reader.this.m_IsReadingForAll) break;
                }
                tag = new TAGINFO[tagv.size()];
                tag = tagv.toArray(tag);
                if (Reader.this.readListeners.size() > 0 && tag.length > 0) {
                    for (ReadListener rl : Reader.this.readListeners) {
                        if (Reader.this.hReader[0] == 0) break;
                        rl.tagRead(this.reader, tag);
                    }
                }
                try {
                    Thread.sleep(Reader.this.m_BackReadOp.ReadInterval);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            Reader.this.m_IsReadThRunning = false;
        }
    }

    private class Exceptionotify
    implements Runnable {
        Reader reader;
        READER_ERR re;

        public Exceptionotify(Reader rd, READER_ERR rer) {
            this.reader = rd;
            this.re = rer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Exceptionotify exceptionotify = this;
            synchronized (exceptionotify) {
                for (ReadExceptionListener rel : Reader.this.readExceptionListeners) {
                    if (Reader.this.hReader[0] == 0) break;
                    rel.tagReadException(this.reader, this.re);
                }
            }
        }
    }

    class MsgObj {
        public byte[] soh = new byte[1];
        public byte[] dataLen = new byte[1];
        public byte[] opCode = new byte[1];
        public byte[] status = new byte[2];
        public byte[] crc = new byte[2];
        public byte[] data = new byte[250];

        MsgObj() {
        }

        public byte[] getcheckcrcdata() {
            int len = (this.dataLen[0] & 0xFF) + 4;
            byte[] crcb = new byte[len];
            int p = 0;
            crcb[p] = this.dataLen[0];
            int n = ++p;
            crcb[n] = this.opCode[0];
            int n2 = ++p;
            crcb[n2] = this.status[0];
            int n3 = ++p;
            ++p;
            crcb[n3] = this.status[1];
            for (int i = 0; i < len - 4; ++i) {
                crcb[p++] = this.data[i];
            }
            return crcb;
        }
    }

    public class SpecObject {
        Object oval;

        public SpecObject() {
        }

        public SpecObject(Object vl) {
            this.oval = vl;
        }

        public Object Val() {
            return this.oval;
        }

        protected void Set(Object ot) {
            this.oval = ot;
        }
    }

    public class DeviceSerialNumber {
        public String serailNumber = "";
    }

    public static enum IT_MODE {
        IT_MODE_CT,
        IT_MODE_S2,
        IT_MODE_E7,
        IT_MODE_E7v2,
        IT_MODE_E7CT,
        IT_MODE_E7StopP,
        IT_MODE_E7AutoRe,
        IT_MODE_E7AutoReV2;

    }

    public class AntPortsVSWR {
        public int andid;
        public short power;
        public Region_Conf region;
        public int frecount;
        public FrequencyVSWR[] vswrs = new FrequencyVSWR[100];

        public AntPortsVSWR() {
            for (int i = 0; i < 100; ++i) {
                this.vswrs[i] = new FrequencyVSWR();
            }
        }

        public String toString() {
            String ret = "";
            for (int i = 0; i < this.frecount; ++i) {
                ret = ret + this.vswrs[i].frequency + ":" + String.format("%.2f", Float.valueOf(this.vswrs[i].vswr)) + " ";
            }
            return ret;
        }
    }

    public class FrequencyVSWR {
        public int frequency;
        public float vswr;
    }

    public class Inv_Potls_ST {
        public int potlcnt;
        public Inv_Potl[] potls = new Inv_Potl[6];
    }

    public class Inv_Potl {
        public SL_TagProtocol potl;
        public int weight;
    }

    public class HoptableData_ST {
        public int[] htb = new int[100];
        public int lenhtb;
    }

    public static class deviceVersion {
        public String hardwareVer = "";
        public String softwareVer = "";
    }

    public class ReaderVersion {
        public String hardwareVer = "";
        public String softwareVer = "";
    }

    public class ConnAnts_ST {
        public int antcnt;
        public int[] connectedants = new int[16];
    }

    public class EmbededData_ST {
        public int bank;
        public int startaddr;
        public int bytecnt;
        public byte[] accesspwd;
    }

    public class Default_Param {
        public Mtr_Param key;
        public String subkey;
        public boolean isdefault;
        public Object val;
    }

    public class MultiTagSelectors_ST {
        public TagSelector_ST[] tagselectors = new TagSelector_ST[16];
        public int tagselectorcnt;

        public MultiTagSelectors_ST() {
            for (int i = 0; i < 16; ++i) {
                this.tagselectors[i] = new TagSelector_ST();
            }
        }
    }

    public class TagSelector_ST {
        public int bank;
        public int startaddr;
        public int slen;
        public byte[] sdata = new byte[24];
    }

    public class TagFilter_ST {
        public int bank;
        public int startaddr;
        public int flen;
        public byte[] fdata = new byte[255];
        public int isInvert;
    }

    public class Reader_Ip {
        public byte[] ip;
        public byte[] mask;
        public byte[] gateway;
    }

    public class EmbededSecureRead_ST {
        public int tagtype;
        public int pwdtype;
        public int ApIndexStartBitsInEpc;
        public int ApIndexBitsNumInEpc;
        public int bank;
        public int address;
        public int blkcnt;
        public int accesspwd;
    }

    public class HardwareDetails {
        public Module_Type module;
        public MaindBoard_Type board;
        public Reader_Type logictype;
        public int antportnumbers;
    }

    public class AntPowerConf {
        public int antcnt;
        public AntPower[] Powers = new AntPower[16];
    }

    public class AntPower {
        public int antid;
        public short readPower;
        public short writePower;
    }

    public class NXP_U8_InventoryModePara {
        public byte[] Mode = new byte[1];
    }

    public class ALIENHiggs3BlockReadLockPara {
        public byte[] AccessPwd = new byte[4];
        public byte BlkBits;
        public short TimeOut;
    }

    public class NXPEASAlarmResult {
        public byte[] EASdata = new byte[8];
    }

    public class NXPEASAlarmPara {
        public byte DR;
        public byte MC;
        public byte TrExt;
        public short TimeOut;
    }

    public class NXPChangeEASPara {
        public byte[] AccessPwd = new byte[4];
        public int isSet;
        public short TimeOut;
    }

    public class IMPINJM4QtResult {
        public int MemType;
        public int RangeType;
    }

    public class CustomParam_ST {
        public String ParamName;
        public byte[] ParamVal;
    }

    public class IMPINJM4QtPara {
        public byte[] AccessPwd = new byte[4];
        public int CmdType;
        public int MemType;
        public int PersistType;
        public int RangeType;
        public short TimeOut;
    }

    public class TAGINFO
    implements Cloneable {
        public int ReadCnt;
        public int RSSI;
        public byte AntennaID;
        public int Frequency;
        public int TimeStamp;
        public short EmbededDatalen;
        public byte[] EmbededData = null;
        public byte[] Res = new byte[2];
        public short Epclen;
        public byte[] PC = new byte[2];
        public byte[] CRC = new byte[2];
        public byte[] EpcId = null;
        public int Phase;
        public SL_TagProtocol protocol;

        public Object clone() {
            TAGINFO o = null;
            try {
                o = (TAGINFO)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            return o;
        }
    }

    public static enum BackReadGpiTriState {
        BackReadGpi_WaitStart(0),
        BackReadGpi_WaitStop(1),
        BackReadGpi_WaitTimeout(2);

        private int value = 0;

        private BackReadGpiTriState(int value) {
            this.value = value;
        }

        public static BackReadGpiTriState valueOf(int value) {
            switch (value) {
                case 0: {
                    return BackReadGpi_WaitStart;
                }
                case 1: {
                    return BackReadGpi_WaitStop;
                }
                case 2: {
                    return BackReadGpi_WaitTimeout;
                }
            }
            return null;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Mtr_Param {
        MTR_PARAM_POTL_GEN2_SESSION(0),
        MTR_PARAM_POTL_GEN2_Q(1),
        MTR_PARAM_POTL_GEN2_TAGENCODING(2),
        MTR_PARAM_POTL_GEN2_MAXEPCLEN(3),
        MTR_PARAM_RF_ANTPOWER(4),
        MTR_PARAM_RF_MAXPOWER(5),
        MTR_PARAM_RF_MINPOWER(6),
        MTR_PARAM_TAG_FILTER(7),
        MTR_PARAM_TAG_EMBEDEDDATA(8),
        MTR_PARAM_TAG_INVPOTL(9),
        MTR_PARAM_READER_CONN_ANTS(10),
        MTR_PARAM_READER_AVAILABLE_ANTPORTS(11),
        MTR_PARAM_READER_IS_CHK_ANT(12),
        MTR_PARAM_READER_VERSION(13),
        MTR_PARAM_READER_IP(14),
        MTR_PARAM_FREQUENCY_REGION(15),
        MTR_PARAM_FREQUENCY_HOPTABLE(16),
        MTR_PARAM_POTL_GEN2_BLF(17),
        MTR_PARAM_POTL_GEN2_WRITEMODE(18),
        MTR_PARAM_POTL_GEN2_TARGET(19),
        MTR_PARAM_TAGDATA_UNIQUEBYANT(20),
        MTR_PARAM_TAGDATA_UNIQUEBYEMDDATA(21),
        MTR_PARAM_TAGDATA_RECORDHIGHESTRSSI(22),
        MTR_PARAM_RF_TEMPERATURE(23),
        MTR_PARAM_RF_HOPTIME(24),
        MTR_PARAM_RF_LBT_ENABLE(25),
        MTR_PARAM_RF_SUPPORTEDREGIONS(26),
        MTR_PARAM_POTL_SUPPORTEDPROTOCOLS(27),
        MTR_PARAM_POTL_ISO180006B_BLF(28),
        MTR_PARAM_POTL_GEN2_TARI(29),
        MTR_PARAM_TRANS_TIMEOUT(30),
        MTR_PARAM_TAG_EMDSECUREREAD(31),
        MTR_PARAM_TRANSMIT_MODE(32),
        MTR_PARAM_POWERSAVE_MODE(33),
        MTR_PARAM_TAG_SEARCH_MODE(34),
        MTR_PARAM_POTL_ISO180006B_MODULATION_DEPTH(35),
        MTR_PARAM_POTL_ISO180006B_DELIMITER(36),
        MTR_PARAM_RF_ANTPORTS_VSWR(37),
        MTR_PARAM_MAXINDEX(39),
        MTR_PARAM_CUSTOM(41),
        MTR_PARAM_READER_WATCHDOG(42),
        MTR_PARAM_READER_ERRORDATA(43),
        MTR_PARAM_RF_HOPANTTIME(44),
        MTR_PARAM_TAG_MULTISELECTORS(45),
        MTR_PARAM_SAVEINMODULE(46),
        MTR_PARAM_SAVEINMODULE_BAUD(47),
        MTR_PARAM_TAG_OPPOTL(48);

        private int value = 0;

        private Mtr_Param(int value) {
            this.value = value;
        }

        public static Mtr_Param valueOf(int value) {
            switch (value) {
                case 0: {
                    return MTR_PARAM_POTL_GEN2_SESSION;
                }
                case 1: {
                    return MTR_PARAM_POTL_GEN2_Q;
                }
                case 2: {
                    return MTR_PARAM_POTL_GEN2_TAGENCODING;
                }
                case 3: {
                    return MTR_PARAM_POTL_GEN2_MAXEPCLEN;
                }
                case 4: {
                    return MTR_PARAM_RF_ANTPOWER;
                }
                case 5: {
                    return MTR_PARAM_RF_MAXPOWER;
                }
                case 6: {
                    return MTR_PARAM_RF_MINPOWER;
                }
                case 7: {
                    return MTR_PARAM_TAG_FILTER;
                }
                case 8: {
                    return MTR_PARAM_TAG_EMBEDEDDATA;
                }
                case 9: {
                    return MTR_PARAM_TAG_INVPOTL;
                }
                case 10: {
                    return MTR_PARAM_READER_CONN_ANTS;
                }
                case 11: {
                    return MTR_PARAM_READER_AVAILABLE_ANTPORTS;
                }
                case 12: {
                    return MTR_PARAM_READER_IS_CHK_ANT;
                }
                case 13: {
                    return MTR_PARAM_READER_VERSION;
                }
                case 14: {
                    return MTR_PARAM_READER_IP;
                }
                case 15: {
                    return MTR_PARAM_FREQUENCY_REGION;
                }
                case 16: {
                    return MTR_PARAM_FREQUENCY_HOPTABLE;
                }
                case 17: {
                    return MTR_PARAM_POTL_GEN2_BLF;
                }
                case 18: {
                    return MTR_PARAM_POTL_GEN2_WRITEMODE;
                }
                case 19: {
                    return MTR_PARAM_POTL_GEN2_TARGET;
                }
                case 20: {
                    return MTR_PARAM_TAGDATA_UNIQUEBYANT;
                }
                case 21: {
                    return MTR_PARAM_TAGDATA_UNIQUEBYEMDDATA;
                }
                case 22: {
                    return MTR_PARAM_TAGDATA_RECORDHIGHESTRSSI;
                }
                case 23: {
                    return MTR_PARAM_RF_TEMPERATURE;
                }
                case 24: {
                    return MTR_PARAM_RF_HOPTIME;
                }
                case 25: {
                    return MTR_PARAM_RF_LBT_ENABLE;
                }
                case 26: {
                    return MTR_PARAM_RF_SUPPORTEDREGIONS;
                }
                case 27: {
                    return MTR_PARAM_POTL_SUPPORTEDPROTOCOLS;
                }
                case 28: {
                    return MTR_PARAM_POTL_ISO180006B_BLF;
                }
                case 29: {
                    return MTR_PARAM_POTL_GEN2_TARI;
                }
                case 30: {
                    return MTR_PARAM_TRANS_TIMEOUT;
                }
                case 31: {
                    return MTR_PARAM_TAG_EMDSECUREREAD;
                }
                case 32: {
                    return MTR_PARAM_TRANSMIT_MODE;
                }
                case 33: {
                    return MTR_PARAM_POWERSAVE_MODE;
                }
                case 34: {
                    return MTR_PARAM_TAG_SEARCH_MODE;
                }
                case 35: {
                    return MTR_PARAM_POTL_ISO180006B_MODULATION_DEPTH;
                }
                case 36: {
                    return MTR_PARAM_POTL_ISO180006B_DELIMITER;
                }
                case 37: {
                    return MTR_PARAM_RF_ANTPORTS_VSWR;
                }
                case 39: {
                    return MTR_PARAM_MAXINDEX;
                }
                case 41: {
                    return MTR_PARAM_CUSTOM;
                }
                case 42: {
                    return MTR_PARAM_READER_WATCHDOG;
                }
                case 43: {
                    return MTR_PARAM_READER_ERRORDATA;
                }
                case 44: {
                    return MTR_PARAM_RF_HOPANTTIME;
                }
                case 45: {
                    return MTR_PARAM_TAG_MULTISELECTORS;
                }
                case 46: {
                    return MTR_PARAM_SAVEINMODULE;
                }
                case 47: {
                    return MTR_PARAM_SAVEINMODULE_BAUD;
                }
                case 48: {
                    return MTR_PARAM_TAG_OPPOTL;
                }
            }
            return null;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum CustomCmdType {
        NXP_SetReadProtect(0),
        NXP_ResetReadProtect(1),
        NXP_ChangeEAS(2),
        NXP_EASAlarm(3),
        NXP_Calibrate(4),
        ALIEN_Higgs2_PartialLoadImage(5),
        ALIEN_Higgs2_FullLoadImage(6),
        ALIEN_Higgs3_FastLoadImage(7),
        ALIEN_Higgs3_LoadImage(8),
        ALIEN_Higgs3_BlockReadLock(9),
        ALIEN_Higgs3_BlockPermaLock(10),
        IMPINJ_M4_Qt(11),
        NXP_U8_InventoryMode(20);

        private int value = 0;

        private CustomCmdType(int value) {
            this.value = value;
        }

        public static CustomCmdType valueOf(int value) {
            switch (value) {
                case 0: {
                    return NXP_SetReadProtect;
                }
                case 1: {
                    return NXP_ResetReadProtect;
                }
                case 2: {
                    return NXP_ChangeEAS;
                }
                case 3: {
                    return NXP_EASAlarm;
                }
                case 4: {
                    return NXP_Calibrate;
                }
                case 5: {
                    return ALIEN_Higgs2_PartialLoadImage;
                }
                case 6: {
                    return ALIEN_Higgs2_FullLoadImage;
                }
                case 7: {
                    return ALIEN_Higgs3_FastLoadImage;
                }
                case 8: {
                    return ALIEN_Higgs3_LoadImage;
                }
                case 9: {
                    return ALIEN_Higgs3_BlockReadLock;
                }
                case 10: {
                    return ALIEN_Higgs3_BlockPermaLock;
                }
                case 11: {
                    return IMPINJ_M4_Qt;
                }
                case 20: {
                    return NXP_U8_InventoryMode;
                }
            }
            return null;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum READER_ERR {
        MT_OK_ERR(0),
        MT_IO_ERR(1),
        MT_INTERNAL_DEV_ERR(2),
        MT_CMD_FAILED_ERR(3),
        MT_CMD_NO_TAG_ERR(4),
        MT_M5E_FATAL_ERR(5),
        MT_OP_NOT_SUPPORTED(6),
        MT_INVALID_PARA(7),
        MT_INVALID_READER_HANDLE(8),
        MT_HARDWARE_ALERT_ERR_BY_HIGN_RETURN_LOSS(9),
        MT_HARDWARE_ALERT_ERR_BY_TOO_MANY_RESET(10),
        MT_HARDWARE_ALERT_ERR_BY_NO_ANTENNAS(11),
        MT_HARDWARE_ALERT_ERR_BY_HIGH_TEMPERATURE(12),
        MT_HARDWARE_ALERT_ERR_BY_READER_DOWN(13),
        MT_HARDWARE_ALERT_ERR_BY_UNKNOWN_ERR(14),
        M6E_INIT_FAILED(15),
        MT_OP_EXECING(16),
        MT_UNKNOWN_READER_TYPE(17),
        MT_OP_INVALID(18),
        MT_HARDWARE_ALERT_BY_FAILED_RESET_MODLUE(19),
        MT_MAX_ERR_NUM(20),
        MT_MAX_INT_NUM(21),
        MT_TEST_DEV_FAULT_1(51),
        MT_TEST_DEV_FAULT_2(52),
        MT_TEST_DEV_FAULT_3(53),
        MT_TEST_DEV_FAULT_4(54),
        MT_TEST_DEV_FAULT_5(55),
        MT_UPDFWFROMSP_OPENFILE_FAILED(80),
        MT_UPDFWFROMSP_FILE_FORMAT_ERR(81),
        MT_JNI_INVALID_PARA(101),
        MT_OTHER_ERR(-268435457);

        private int value = 0;

        private READER_ERR(int value) {
            this.value = value;
        }

        public static READER_ERR valueOf(int value) {
            switch (value) {
                case 0: {
                    return MT_OK_ERR;
                }
                case 1: {
                    return MT_IO_ERR;
                }
                case 2: {
                    return MT_INTERNAL_DEV_ERR;
                }
                case 3: {
                    return MT_CMD_FAILED_ERR;
                }
                case 4: {
                    return MT_CMD_NO_TAG_ERR;
                }
                case 5: {
                    return MT_M5E_FATAL_ERR;
                }
                case 6: {
                    return MT_OP_NOT_SUPPORTED;
                }
                case 7: {
                    return MT_INVALID_PARA;
                }
                case 8: {
                    return MT_INVALID_READER_HANDLE;
                }
                case 9: {
                    return MT_HARDWARE_ALERT_ERR_BY_HIGN_RETURN_LOSS;
                }
                case 10: {
                    return MT_HARDWARE_ALERT_ERR_BY_TOO_MANY_RESET;
                }
                case 11: {
                    return MT_HARDWARE_ALERT_ERR_BY_NO_ANTENNAS;
                }
                case 12: {
                    return MT_HARDWARE_ALERT_ERR_BY_HIGH_TEMPERATURE;
                }
                case 13: {
                    return MT_HARDWARE_ALERT_ERR_BY_READER_DOWN;
                }
                case 14: {
                    return MT_HARDWARE_ALERT_ERR_BY_UNKNOWN_ERR;
                }
                case 15: {
                    return M6E_INIT_FAILED;
                }
                case 16: {
                    return MT_OP_EXECING;
                }
                case 17: {
                    return MT_UNKNOWN_READER_TYPE;
                }
                case 18: {
                    return MT_OP_INVALID;
                }
                case 19: {
                    return MT_HARDWARE_ALERT_BY_FAILED_RESET_MODLUE;
                }
                case 80: {
                    return MT_UPDFWFROMSP_OPENFILE_FAILED;
                }
                case 81: {
                    return MT_UPDFWFROMSP_FILE_FORMAT_ERR;
                }
                case 20: {
                    return MT_OTHER_ERR;
                }
                case 21: {
                    return MT_OTHER_ERR;
                }
                case 51: {
                    return MT_TEST_DEV_FAULT_1;
                }
                case 52: {
                    return MT_TEST_DEV_FAULT_2;
                }
                case 53: {
                    return MT_TEST_DEV_FAULT_3;
                }
                case 54: {
                    return MT_TEST_DEV_FAULT_4;
                }
                case 55: {
                    return MT_TEST_DEV_FAULT_5;
                }
                case 101: {
                    return MT_JNI_INVALID_PARA;
                }
            }
            return MT_OTHER_ERR;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Reader_Type {
        MODULE_TWO_ANTS(0),
        MODULE_FOUR_ANTS(1),
        MODULE_THREE_ANTS(2),
        MODULE_ONE_ANT(3),
        PR9000(4),
        MODULE_ARM7_TWO_ANTS(5),
        MODULE_ARM7_FOUR_ANTS(6),
        M6E_ARM7_FOUR_ANTS(7),
        M56_ARM7_FOUR_ANTS(8),
        R902_M1S(9),
        R902_M2S(10),
        ARM7_16ANTS(11),
        SL_COMMN_READER(12);

        private int value = 0;

        private Reader_Type(int value) {
            this.value = value;
        }

        public static Reader_Type valueOf(int value) {
            switch (value) {
                case 0: {
                    return MODULE_TWO_ANTS;
                }
                case 1: {
                    return MODULE_FOUR_ANTS;
                }
                case 2: {
                    return MODULE_THREE_ANTS;
                }
                case 3: {
                    return MODULE_ONE_ANT;
                }
                case 4: {
                    return PR9000;
                }
                case 5: {
                    return MODULE_ARM7_TWO_ANTS;
                }
                case 6: {
                    return MODULE_ARM7_FOUR_ANTS;
                }
                case 7: {
                    return M6E_ARM7_FOUR_ANTS;
                }
                case 8: {
                    return M56_ARM7_FOUR_ANTS;
                }
                case 9: {
                    return R902_M1S;
                }
                case 10: {
                    return R902_M2S;
                }
                case 11: {
                    return ARM7_16ANTS;
                }
                case 12: {
                    return SL_COMMN_READER;
                }
            }
            return null;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Lock_Type {
        KILL_PASSWORD_UNLOCK(0),
        KILL_PASSWORD_LOCK(512),
        KILL_PASSWORD_PERM_LOCK(768),
        KILL_PASSWORD_PERM_UNLOCK(256),
        ACCESS_PASSWD_UNLOCK(0),
        ACCESS_PASSWD_LOCK(128),
        ACCESS_PASSWD_PERM_LOCK(192),
        ACCESS_PASSWD_PERM_UNLOCK(64),
        BANK1_UNLOCK(0),
        BANK1_LOCK(32),
        BANK1_PERM_LOCK(48),
        BANK1_PERM_UNLOCK(16),
        BANK2_UNLOCK(0),
        BANK2_LOCK(8),
        BANK2_PERM_LOCK(12),
        BANK2_PERM_UNLOCK(4),
        BANK3_UNLOCK(0),
        BANK3_LOCK(2),
        BANK3_PERM_LOCK(3),
        BANK3_PERM_UNLOCK(1);

        int p_v;

        private Lock_Type(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }
    }

    public static enum Lock_Type_GB_Config_Sec {
        Sec_Res(0),
        Sec_NotIden(1),
        Sec_IdenNoSafeTran(2),
        Sec_IdenSafeTran(3);

        int p_v;

        private Lock_Type_GB_Config_Sec(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }
    }

    public static enum Lock_Type_GB_Config_Pro {
        Pro_ReadAndWrite(0),
        Pro_ReadOnly(1),
        Pro_WriteOnly(2),
        Pro_NONE(3);

        int p_v;

        private Lock_Type_GB_Config_Pro(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }
    }

    public static enum Lock_Type_GB_Config {
        Config_Bank_Pro(0),
        Confgi_Bank_Sec(4);

        int p_v;

        private Lock_Type_GB_Config(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }
    }

    public static enum GB_USE_SUB {
        GB_USE_SUB0(0),
        GB_USE_SUB1(1),
        GB_USE_SUB2(2),
        GB_USE_SUB3(3),
        GB_USE_SUB4(4),
        GB_USE_SUB5(5),
        GB_USE_SUB6(6),
        GB_USE_SUB7(7),
        GB_USE_SUB8(8),
        GB_USE_SUB9(9),
        GB_USE_SUB10(10),
        GB_USE_SUB11(11),
        GB_USE_SUB12(12),
        GB_USE_SUB13(13),
        GB_USE_SUB14(14),
        GB_USE_SUB15(15);

        int p_v;

        private GB_USE_SUB(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }

        public static GB_USE_SUB valueOf(int value) {
            switch (value) {
                case 0: {
                    return GB_USE_SUB0;
                }
                case 1: {
                    return GB_USE_SUB1;
                }
                case 2: {
                    return GB_USE_SUB2;
                }
                case 3: {
                    return GB_USE_SUB3;
                }
                case 4: {
                    return GB_USE_SUB4;
                }
                case 5: {
                    return GB_USE_SUB5;
                }
                case 6: {
                    return GB_USE_SUB6;
                }
                case 7: {
                    return GB_USE_SUB7;
                }
                case 8: {
                    return GB_USE_SUB8;
                }
                case 9: {
                    return GB_USE_SUB9;
                }
                case 10: {
                    return GB_USE_SUB10;
                }
                case 11: {
                    return GB_USE_SUB11;
                }
                case 12: {
                    return GB_USE_SUB12;
                }
                case 13: {
                    return GB_USE_SUB13;
                }
                case 14: {
                    return GB_USE_SUB14;
                }
                case 15: {
                    return GB_USE_SUB15;
                }
            }
            return null;
        }
    }

    public static enum Lock_Obj_GB {
        LOCK_OBJECT_GBTID(0),
        LOCK_OBJECT_GBEPC(16),
        LOCK_OBJECT_GBSEC(32),
        LOCK_OBJECT_GBUSE(48);

        int p_v;

        private Lock_Obj_GB(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }
    }

    public static enum Lock_Obj {
        LOCK_OBJECT_KILL_PASSWORD(1),
        LOCK_OBJECT_ACCESS_PASSWD(2),
        LOCK_OBJECT_BANK1(4),
        LOCK_OBJECT_BANK2(8),
        LOCK_OBJECT_BANK3(16);

        int p_v;

        private Lock_Obj(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }
    }

    public static enum SL_TagProtocol {
        SL_TAG_PROTOCOL_NONE(0),
        SL_TAG_PROTOCOL_ISO180006B(3),
        SL_TAG_PROTOCOL_GEN2(5),
        SL_TAG_PROTOCOL_ISO180006B_UCODE(6),
        SL_TAG_PROTOCOL_IPX64(7),
        SL_TAG_PROTOCOL_IPX256(8),
        SL_TAG_PROTOCOL_GB(16),
        SL_TAG_PROTOCOL_SPETAG_CC33(100);

        int p_v;

        private SL_TagProtocol(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }

        public static SL_TagProtocol valueOf(int value) {
            switch (value) {
                case 0: {
                    return SL_TAG_PROTOCOL_NONE;
                }
                case 3: {
                    return SL_TAG_PROTOCOL_ISO180006B;
                }
                case 5: {
                    return SL_TAG_PROTOCOL_GEN2;
                }
                case 6: {
                    return SL_TAG_PROTOCOL_ISO180006B_UCODE;
                }
                case 7: {
                    return SL_TAG_PROTOCOL_IPX64;
                }
                case 8: {
                    return SL_TAG_PROTOCOL_IPX256;
                }
                case 16: {
                    return SL_TAG_PROTOCOL_GB;
                }
                case 100: {
                    return SL_TAG_PROTOCOL_SPETAG_CC33;
                }
            }
            return null;
        }
    }

    public static enum MaindBoard_Type {
        MAINBOARD_NONE,
        MAINBOARD_ARM7,
        MAINBOARD_SERIAL,
        MAINBOARD_WIFI,
        MAINBOARD_ARM9,
        MAINBOARD_ARM9_WIFI;

    }

    public static enum Region_Conf {
        RG_NONE(0),
        RG_NA(1),
        RG_EU(2),
        RG_EU2(7),
        RG_EU3(8),
        RG_KR(3),
        RG_PRC(6),
        RG_PRC2(10),
        RG_OPEN(255),
        RG_IN(4),
        RG_JP(5),
        RG_CE_HIGH(12),
        RG_HK(13),
        RG_TAIWAN(14),
        RG_MALAYSIA(15),
        RG_SOUTH_AFRICA(16),
        RG_BRAZIL(17),
        RG_THAILAND(18),
        RG_SINGAPORE(19),
        RG_AUSTRALIA(20),
        RG_URUGUAY(22),
        RG_VIETNAM(23),
        RG_ISRAEL(24),
        RG_PHILIPPINES(25),
        RG_INDONESIA(26),
        RG_NEW_ZEALAND(27),
        RG_PERU(28),
        RG_RUSSIA(29),
        RG_CE_LOW_HIGH(30),
        RG_JP2_LBT6(31),
        RG_JP3_NLBT19(32);

        int p_v;

        private Region_Conf(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }

        public static Region_Conf valueOf(int value) {
            switch (value) {
                case 0: {
                    return RG_NONE;
                }
                case 1: {
                    return RG_NA;
                }
                case 2: {
                    return RG_EU;
                }
                case 7: {
                    return RG_EU2;
                }
                case 8: {
                    return RG_EU3;
                }
                case 3: {
                    return RG_KR;
                }
                case 6: {
                    return RG_PRC;
                }
                case 10: {
                    return RG_PRC2;
                }
                case 255: {
                    return RG_OPEN;
                }
                case 4: {
                    return RG_IN;
                }
                case 5: {
                    return RG_JP;
                }
                case 12: {
                    return RG_CE_HIGH;
                }
                case 13: {
                    return RG_HK;
                }
                case 14: {
                    return RG_TAIWAN;
                }
                case 15: {
                    return RG_MALAYSIA;
                }
                case 16: {
                    return RG_SOUTH_AFRICA;
                }
                case 17: {
                    return RG_BRAZIL;
                }
                case 18: {
                    return RG_THAILAND;
                }
                case 19: {
                    return RG_SINGAPORE;
                }
                case 20: {
                    return RG_AUSTRALIA;
                }
                case 22: {
                    return RG_URUGUAY;
                }
                case 23: {
                    return RG_VIETNAM;
                }
                case 24: {
                    return RG_ISRAEL;
                }
                case 25: {
                    return RG_PHILIPPINES;
                }
                case 26: {
                    return RG_INDONESIA;
                }
                case 27: {
                    return RG_NEW_ZEALAND;
                }
                case 28: {
                    return RG_PERU;
                }
                case 29: {
                    return RG_RUSSIA;
                }
                case 30: {
                    return RG_CE_LOW_HIGH;
                }
                case 31: {
                    return RG_JP2_LBT6;
                }
                case 32: {
                    return RG_JP3_NLBT19;
                }
            }
            return null;
        }
    }

    public static enum Module_Type {
        MODOULE_NONE(0),
        MODOULE_R902_M1S(1),
        MODOULE_R902_M2S(2),
        MODOULE_M5E(3),
        MODOULE_M5E_C(4),
        MODOULE_M6E(5),
        MODOULE_PR9000(6),
        MODOULE_M5E_PRC(7),
        MODOULE_M6E_PRC(8),
        MODOULE_M6E_MICRO(9),
        MODOULE_SLR1100(10),
        MODOULE_SLR1200(11),
        MODOULE_SLR1300(12),
        MODOULE_SLR3000(13),
        MODOULE_SLR5100(14),
        MODOULE_SLR5200(15),
        MODOULE_SLR3100(16),
        MODOULE_SLR3200(17),
        MODOULE_SLR5300(18),
        MODOULE_SLR5900(19),
        MODOULE_SLR5800(20),
        MODOULE_SLR6000(21),
        MODOULE_SLR6100(22),
        MODOULE_SIM7100(23),
        MODOULE_SIM7200(24),
        MODOULE_SIM7300(25),
        MODOULE_SIM7400(26),
        MODOULE_SIM7500(27),
        MODOULE_SIM7600(28),
        MODOULE_SIM3100(29),
        MODOULE_SIM3200(30),
        MODOULE_SIM3300(31),
        MODOULE_SIM3400(32),
        MODOULE_SIM3500(33),
        MODOULE_SIM3600(34),
        MODOULE_SIM5100(35),
        MODOULE_SIM5200(36),
        MODOULE_SIM5300(37),
        MODOULE_SIM5400(38),
        MODOULE_SIM5500(39),
        MODOULE_SIM5600(40),
        MODOULE_SIM3110(41);

        private int value = 0;

        private Module_Type(int value) {
            this.value = value;
        }

        public static Module_Type valueOf(int value) {
            switch (value) {
                case 0: {
                    return MODOULE_NONE;
                }
                case 1: {
                    return MODOULE_R902_M1S;
                }
                case 2: {
                    return MODOULE_R902_M2S;
                }
                case 3: {
                    return MODOULE_M5E;
                }
                case 4: {
                    return MODOULE_M5E_C;
                }
                case 5: {
                    return MODOULE_M6E;
                }
                case 6: {
                    return MODOULE_PR9000;
                }
                case 7: {
                    return MODOULE_M5E_PRC;
                }
                case 8: {
                    return MODOULE_M6E_PRC;
                }
                case 9: {
                    return MODOULE_M6E_MICRO;
                }
                case 10: {
                    return MODOULE_SLR1100;
                }
                case 11: {
                    return MODOULE_SLR1200;
                }
                case 12: {
                    return MODOULE_SLR1300;
                }
                case 13: {
                    return MODOULE_SLR3000;
                }
                case 14: {
                    return MODOULE_SLR5100;
                }
                case 15: {
                    return MODOULE_SLR5200;
                }
                case 16: {
                    return MODOULE_SLR3100;
                }
                case 17: {
                    return MODOULE_SLR3200;
                }
                case 18: {
                    return MODOULE_SLR5300;
                }
                case 19: {
                    return MODOULE_SLR5900;
                }
                case 20: {
                    return MODOULE_SLR5800;
                }
                case 21: {
                    return MODOULE_SLR6000;
                }
                case 22: {
                    return MODOULE_SLR6100;
                }
                case 23: {
                    return MODOULE_SIM7100;
                }
                case 24: {
                    return MODOULE_SIM7200;
                }
                case 25: {
                    return MODOULE_SIM7300;
                }
                case 26: {
                    return MODOULE_SIM7400;
                }
                case 27: {
                    return MODOULE_SIM7500;
                }
                case 28: {
                    return MODOULE_SIM7600;
                }
                case 29: {
                    return MODOULE_SIM3100;
                }
                case 30: {
                    return MODOULE_SIM3200;
                }
                case 31: {
                    return MODOULE_SIM3300;
                }
                case 32: {
                    return MODOULE_SIM3400;
                }
                case 33: {
                    return MODOULE_SIM3500;
                }
                case 34: {
                    return MODOULE_SIM3600;
                }
                case 35: {
                    return MODOULE_SIM5100;
                }
                case 36: {
                    return MODOULE_SIM5200;
                }
                case 37: {
                    return MODOULE_SIM5300;
                }
                case 38: {
                    return MODOULE_SIM5400;
                }
                case 39: {
                    return MODOULE_SIM5500;
                }
                case 40: {
                    return MODOULE_SIM5600;
                }
                case 41: {
                    return MODOULE_SIM3110;
                }
            }
            return null;
        }

        public int value() {
            return this.value;
        }
    }
}

