/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.api.cls;

import com.uhf.api.cls.ParseInfo;
import com.uhf.api.cls.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class SpecialSensorTag {
    public int timeout;
    public byte[] accesspwd;
    protected byte[] data;
    protected byte datalen = 0;
    protected byte[] outdata;
    protected int outdatalen = 0;
    protected int pos;
    public int RSSI;
    public int Frequency;
    public int Phase;
    public short Epclen;
    public byte[] PC = new byte[2];
    public byte[] EpcId = null;
    public byte[] CRC = new byte[2];

    public TagType TagTypeE() {
        return null;
    }

    public SpecialSensorTag() {
        this.data = new byte[0];
        this.outdata = new byte[0];
    }

    public byte[] ToByteData() {
        return this.data;
    }

    protected int ParseOfEPCinfo(byte[] buf, int buflen) throws Exception {
        int stpos = 2;
        if ((buf[0] << 8 | buf[1]) != this.TagTypeE().value()) {
            throw new Exception("tagtype");
        }
        if (buflen < 7) {
            throw new Exception("len<7");
        }
        this.RSSI = buf[stpos++];
        this.Frequency = (buf[stpos++] & 0xFF) << 16 | (buf[stpos++] & 0xFF) << 8 | buf[stpos++] & 0xFF;
        this.Phase = (buf[stpos++] & 0xFF) << 8 | buf[stpos++] & 0xFF;
        this.Epclen = (short)(buf[stpos++] & 0xFF);
        if (buflen < 7 + this.Epclen) {
            throw new Exception("len<7+epclen");
        }
        this.PC[0] = buf[stpos++];
        this.PC[1] = buf[stpos++];
        this.EpcId = new byte[this.Epclen - 4];
        System.arraycopy(buf, stpos, this.EpcId, 0, this.EpcId.length);
        stpos += this.EpcId.length;
        this.CRC[0] = buf[stpos++];
        this.CRC[1] = buf[stpos++];
        this.outdata = new byte[buflen];
        System.arraycopy(buf, 0, this.outdata, 0, buflen);
        this.outdatalen = this.outdata.length;
        return stpos;
    }

    public static enum TagType {
        NMV2D_v1_1(1),
        LTU32(2),
        FM13DT160(3),
        KX2005X_BL(4),
        E_MAN_EWIZ(5),
        FUJITSU_MB97R8110(6),
        NXP_U8_U8M(7),
        EPCV2_Auth(8),
        SCR409(9);

        int p_v;

        private TagType(int v) {
            this.p_v = v;
        }

        static TagType valueOf(int v) {
            switch (v) {
                case 1: {
                    return NMV2D_v1_1;
                }
                case 2: {
                    return LTU32;
                }
                case 3: {
                    return FM13DT160;
                }
                case 4: {
                    return KX2005X_BL;
                }
                case 5: {
                    return E_MAN_EWIZ;
                }
                case 6: {
                    return FUJITSU_MB97R8110;
                }
                case 7: {
                    return NXP_U8_U8M;
                }
                case 8: {
                    return EPCV2_Auth;
                }
                case 9: {
                    return SCR409;
                }
            }
            return null;
        }

        public int value() {
            return this.p_v;
        }
    }

    public class Tag_SCR409
    extends SpecialSensorTag
    implements ParseInfo {
        private TagType tagtype = TagType.SCR409;
        public float temperature = Float.NaN;
        private float A;
        private float B;
        private float a;
        private float X;
        private float dX;

        public Tag_SCR409() {
            this.timeout = 1000;
            this.accesspwd = null;
        }

        @Override
        public TagType TagTypeE() {
            return this.tagtype;
        }

        private float CalculateTemperature(float A, float B, float a, float X, float dX) {
            return (float)((double)(A * a) / (39.0672689537297 * (double)(X + dX) + (double)(a * 10.0f)) + (double)B * 0.1);
        }

        private float getTemperature() {
            return this.CalculateTemperature(this.A, this.B, this.a, this.X, this.dX);
        }

        @Override
        public Reader.READER_ERR ParseSpecialSensorInfo(byte[] buff, int pos) {
            this.temperature = Float.NaN;
            this.dX = ((buff[pos] & 0x40) == 0 ? 1 : -1) * (buff[pos++] & 0x1F) << 8 | buff[pos++] & 0xFF;
            this.A = ((buff[pos] & 0x40) == 0 ? 1 : -1) * ((buff[pos++] & 0x3F) << 8 | buff[pos++] & 0xFF);
            this.B = ((buff[pos] & 0x40) == 0 ? 1 : -1) * ((buff[pos++] & 0x3F) << 8 | buff[pos++] & 0xFF);
            this.a = ((buff[pos] & 0x40) == 0 ? 1 : -1) * ((buff[pos++] & 0x3F) << 8 | buff[pos++] & 0xFF);
            if ((buff[pos] & 0xE0) != 0) {
                return Reader.READER_ERR.MT_MAX_INT_NUM;
            }
            this.X = (buff[pos++] & 0x1F) << 8 | buff[pos++] & 0xFF;
            System.out.println("dX:" + this.dX + " A:" + this.A + " B:" + this.B + " a:" + this.a + " X:" + this.X);
            this.temperature = this.getTemperature();
            BigDecimal bd = new BigDecimal(this.temperature);
            bd = bd.setScale(2, RoundingMode.HALF_UP);
            this.temperature = bd.floatValue();
            return Reader.READER_ERR.MT_OK_ERR;
        }
    }
}

