/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.utils;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import com.zkteco.android.biometric.core.utils.LogHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ToolUtils {
    private static final char[] HexCode = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static int MAX_HEX_LEN = 64;

    public static void setMaxHexLogLen(int nLen) {
        MAX_HEX_LEN = nLen;
    }

    public static String bytesToHexString(byte[] bytes) {
        if (null == bytes) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            stringBuilder.append(HexCode[bytes[i] >>> 4 & 0xF]);
            stringBuilder.append(HexCode[bytes[i] & 0xF]);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static String bytesToHexString(byte[] bytes, int offset, int len) {
        if (null == bytes || offset < 0 || len <= 0 || offset + len > bytes.length) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            stringBuilder.append(HexCode[bytes[offset + i] >>> 4 & 0xF]);
            stringBuilder.append(HexCode[bytes[offset + i] & 0xF]);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static void outputHexString(byte[] bytes) {
        if (LogHelper.getLevel() < 4) {
            int nLen = bytes.length;
            if (nLen > MAX_HEX_LEN) {
                nLen = MAX_HEX_LEN;
            }
            LogHelper.d("outputHexString : " + ToolUtils.bytesToHexString(bytes, 0, MAX_HEX_LEN));
        }
    }

    public static void outputHexString(byte[] bytes, int offset, int length) {
        if (LogHelper.getLevel() < 4) {
            if (length > MAX_HEX_LEN) {
                length = MAX_HEX_LEN;
            }
            LogHelper.d("outputHexString : " + ToolUtils.bytesToHexString(bytes, offset, length));
        }
    }

    public static Bitmap renderCroppedGreyScaleBitmap(byte[] buffer, int width, int height) {
        if (buffer == null || buffer.length == 0) {
            return null;
        }
        int[] pixels = new int[width * height];
        int inputOffset = 0;
        for (int y = 0; y < height; ++y) {
            int outputOffset = y * width;
            for (int x = 0; x < width; ++x) {
                int grey = buffer[inputOffset + x] & 0xFF;
                pixels[outputOffset + x] = 0xFF000000 | grey * 65793;
            }
            inputOffset += width;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        buffer = null;
        pixels = null;
        return bitmap;
    }

    public static Bitmap renderCroppedGreyScaleRGBABitmap(byte[] data, int width, int height) {
        byte[] Bits = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            byte by = data[i];
            Bits[i * 4 + 2] = by;
            Bits[i * 4 + 1] = by;
            Bits[i * 4] = by;
            Bits[i * 4 + 3] = -1;
        }
        Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bmp.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(Bits));
        return bmp;
    }

    public static Context getApplicationContext() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Method method = activityThreadClass.getMethod("currentApplication", new Class[0]);
            Application app = (Application)method.invoke(null, (Object[])null);
            if (app != null) {
                return app.getApplicationContext();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public static byte[] intToByteArray(int number) {
        byte[] abyte = new byte[]{(byte)(0xFF & number), (byte)((0xFF00 & number) >> 8), (byte)((0xFF0000 & number) >> 16), (byte)((0xFF000000 & number) >> 24)};
        return abyte;
    }

    public static int byteArrayToInt(byte[] bytes) {
        int number = bytes[0] & 0xFF;
        number |= (bytes[1] & 0xFF) << 8 & 0xFF00;
        number |= (bytes[2] & 0xFF) << 16 & 0xFF0000;
        return number |= (bytes[3] & 0xFF) << 24 & 0xFF000000;
    }

    public static long byteArrayToUint(byte[] bytes, int offset, int size) {
        long number = 0L;
        if (size != 2 && size != 4 && size != 8) {
            return 0L;
        }
        number = bytes[offset + 0] & 0xFF;
        number |= (long)((bytes[offset + 1] & 0xFF) << 8 & 0xFF00);
        if (size >= 4) {
            number |= (long)((bytes[offset + 2] & 0xFF) << 16 & 0xFF0000);
            number |= (long)((bytes[offset + 3] & 0xFF) << 24 & 0xFF000000);
        }
        return number;
    }

    public static boolean isNIDFPSensor(int vid, int pid) {
        return 6997 == vid && pid >= 768 && pid <= 1023;
    }

    public static boolean isZKFPModule(int vid, int pid) {
        return 6997 == vid && 289 == pid;
    }

    public static void sleep(int mSecond) {
        try {
            Thread.sleep(mSecond);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static byte[] bitmap2ARGB8888(Bitmap bitmap, int[] width, int[] height) {
        Bitmap bm = bitmap.copy(Bitmap.Config.ARGB_8888, true);
        if (null == bm) {
            return null;
        }
        width[0] = bm.getWidth();
        height[0] = bm.getHeight();
        int bytes = bm.getByteCount();
        ByteBuffer buffer = ByteBuffer.allocate(bytes);
        bm.copyPixelsToBuffer((Buffer)buffer);
        bm.recycle();
        return buffer.array();
    }

    public static byte[] bitmap2Gray256(Bitmap bitmap, int[] width, int[] height) {
        Bitmap bm = bitmap.copy(Bitmap.Config.ARGB_8888, true);
        if (null == bm) {
            return null;
        }
        width[0] = bm.getWidth();
        height[0] = bm.getHeight();
        byte[] gray = new byte[width[0] * height[0]];
        int bytes = bm.getByteCount();
        ByteBuffer buffer = ByteBuffer.allocate(bytes);
        bm.copyPixelsToBuffer((Buffer)buffer);
        byte[] temp = buffer.array();
        for (int i = 0; i < temp.length / 4; ++i) {
            gray[i] = temp[i * 4 + 2];
        }
        bm.recycle();
        return gray;
    }
}

