/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.module.fingerprintreader;

import android.util.Base64;
import com.zkteco.android.biometric.FingerprintExceptionListener;
import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.module.fingerprintreader.FingerprintCaptureListener;
import com.zkteco.android.biometric.module.fingerprintreader.FingerprintSensor;
import com.zkteco.android.biometric.module.fingerprintreader.exception.FingerprintException;
import com.zkteco.zkfinger.FingerprintService;
import com.zkteco.zkfinger.ZKFingerConfig;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class FingerprintCaptureThread
implements Runnable {
    private FingerprintSensor fingerprintSensor = null;
    private int index;
    private FingerprintCaptureListener fingerprintCaptureListener = null;
    private boolean isCancel = false;
    private CountDownLatch countdownLatch = null;
    private byte[] mfpImage = null;
    private byte[] mfpTemplate = null;
    private int mExceptCnt = 0;
    private final int MAX_TRY_CNT = 5;

    public FingerprintCaptureThread(FingerprintSensor fingerprintSensor, int index) {
        this.fingerprintSensor = fingerprintSensor;
        this.index = index;
        this.fingerprintCaptureListener = fingerprintSensor.getFingerprintCaptureListenerList().get("key.working.listener." + index);
    }

    @Override
    public void run() {
        this.countdownLatch = new CountDownLatch(1);
        while (!this.isCancel) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                if (null == this.mfpImage) {
                    this.mfpImage = new byte[this.fingerprintSensor.getImageWidth() * this.fingerprintSensor.getImageHeight()];
                }
                this.fingerprintSensor.capture(this.index, this.mfpImage);
                this.mExceptCnt = 0;
                this.fingerprintCaptureListener.captureOK(this.mfpImage);
                if (ZKFingerConfig.isOnlyCapture()) continue;
                if (null == this.mfpTemplate) {
                    this.mfpTemplate = new byte[2048];
                }
                int ret = 0;
                int[] fpScore = new int[1];
                ret = FingerprintService.extract((byte[])this.mfpImage, (int)this.fingerprintSensor.getImageWidth(), (int)this.fingerprintSensor.getImageHeight(), (byte[])this.mfpTemplate, (int[])fpScore);
                if (ret <= 0) {
                    this.fingerprintCaptureListener.extractError(ret);
                    continue;
                }
                this.fingerprintSensor.setLastTempLen(ret);
                String strBase64Template = Base64.encodeToString((byte[])this.mfpTemplate, (int)0, (int)ret, (int)2);
                this.fingerprintSensor.setLastTempBase64(strBase64Template);
                this.fingerprintCaptureListener.extractOK(this.mfpTemplate);
            }
            catch (FingerprintException e) {
                int statusCode = this.fingerprintSensor.getDeviceStatus(this.index);
                if (1 == statusCode) {
                    LogHelper.d((String)"usb is ok!");
                    this.mExceptCnt = 0;
                } else {
                    FingerprintExceptionListener listener;
                    if (this.mExceptCnt < 5) {
                        ++this.mExceptCnt;
                    }
                    if ((this.mExceptCnt == 5 || statusCode == -99998) && null != (listener = this.fingerprintSensor.getFingerprintExceptionListener())) {
                        LogHelper.d((String)"!!!exception occurred!!!");
                        listener.onDeviceException();
                    }
                }
                this.fingerprintCaptureListener.captureError(e);
            }
        }
        this.countdownLatch.countDown();
    }

    public void cancel() {
        this.isCancel = true;
        try {
            if (null != this.countdownLatch) {
                this.countdownLatch.await(5L, TimeUnit.SECONDS);
            }
            if (null != this.mfpImage) {
                this.mfpImage = null;
            }
            if (null != this.mfpTemplate) {
                this.mfpTemplate = null;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

