/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.module.fingerprintreader;

import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.module.fingerprintreader.FingerprintCaptureThread;
import com.zkteco.android.biometric.module.fingerprintreader.FingerprintSensor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class FingerprintCaptureThreadPool {
    private static Map<String, FingerprintCaptureThread> fingerprintCaptureThreadMap = new HashMap<String, FingerprintCaptureThread>();

    FingerprintCaptureThreadPool() {
    }

    public static void start(FingerprintSensor fingerprintSensor, int index) {
        String threadKey = FingerprintCaptureThreadPool.buildKey(fingerprintSensor, index);
        if (fingerprintCaptureThreadMap.get(threadKey) == null) {
            FingerprintCaptureThread fingerprintCaptureThread = new FingerprintCaptureThread(fingerprintSensor, index);
            new Thread(fingerprintCaptureThread).start();
            fingerprintCaptureThreadMap.put(threadKey, fingerprintCaptureThread);
        } else {
            LogHelper.w((String)(threadKey + " is already running, you don't need to start it once more"));
        }
    }

    private static String buildKey(FingerprintSensor fingerprintSensor, int index) {
        return fingerprintSensor.getTransportType() + "." + FingerprintSensor.class.getCanonicalName() + "." + index + "_" + fingerprintSensor.getDeviceTag();
    }

    public static void destroy() {
        Collection<FingerprintCaptureThread> threads = fingerprintCaptureThreadMap.values();
        for (FingerprintCaptureThread thread : threads) {
            thread.cancel();
        }
        fingerprintCaptureThreadMap.clear();
    }

    public static void cancel(FingerprintSensor fingerprintSensor, int index) {
        String threadKey = FingerprintCaptureThreadPool.buildKey(fingerprintSensor, index);
        FingerprintCaptureThread fingerprintCaptureThread = fingerprintCaptureThreadMap.get(threadKey);
        if (fingerprintCaptureThread != null) {
            fingerprintCaptureThread.cancel();
            fingerprintCaptureThreadMap.remove(threadKey);
        } else {
            LogHelper.w((String)(threadKey + " is already cancelled or never running"));
        }
    }
}

