/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.serialport;

import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.core.utils.ToolUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ZKSerialHOSTAPIService {
    private InputStream mInputStream = null;
    private OutputStream mOutPutStream = null;
    private final int TYPE_SERIAL = 1;

    public void setStream(InputStream inputStream, OutputStream outputStream) {
        this.mInputStream = inputStream;
        this.mOutPutStream = outputStream;
    }

    public int control(int requestType, int request, int value, int index, byte[] buffer, int length, int timeout) {
        return 0;
    }

    public int read(byte[] buffer, int length, int timeout) {
        int ret = 0;
        if (null == this.mInputStream) {
            LogHelper.e("Device not opened!");
            return 0;
        }
        long nTickStart = System.currentTimeMillis();
        int nReadLen = length;
        try {
            nReadLen = this.mInputStream.available();
        }
        catch (IOException e) {
            nReadLen = 0;
            e.printStackTrace();
        }
        if (nReadLen > length) {
            nReadLen = length;
        }
        while (nReadLen > 0 && Math.abs(System.currentTimeMillis() - nTickStart) < (long)timeout) {
            try {
                ret = this.mInputStream.read(buffer, 0, nReadLen);
                if (ret <= 0) continue;
                ToolUtils.outputHexString(buffer, 0, ret);
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                LogHelper.e("read fail, msg=" + e.getMessage() + " !");
            }
        }
        return ret;
    }

    public int write(byte[] buffer, int length, int timeout) {
        if (null == this.mOutPutStream) {
            LogHelper.e("Device not opened!");
            return 0;
        }
        try {
            this.mOutPutStream.write(buffer, 0, length);
            ToolUtils.outputHexString(buffer, 0, length);
            return length;
        }
        catch (IOException e) {
            e.printStackTrace();
            LogHelper.e("write fail, msg=" + e.getMessage() + " !");
            return 0;
        }
    }

    public int getVendorID() {
        return -1;
    }

    public int getProductID() {
        return -1;
    }

    public int getTransportType() {
        return 1;
    }
}

