/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device;

import android.content.Context;
import com.zkteco.android.biometric.core.device.BiometricDevice;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.utils.LogHelper;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class BiometricFactory {
    private static final Class[] ARGS_CLASS = new Class[]{Context.class, TransportType.class, Map.class};
    private static Map<String, BiometricDevice> biometricDeviceMap = new HashMap<String, BiometricDevice>();

    protected static BiometricDevice createBiometricDevice(String className, Context context, TransportType transportType, Map<String, Object> parameters) {
        if (className == null || className.equals("")) {
            return null;
        }
        BiometricDevice biometricDevice = (BiometricDevice)BiometricFactory.instanceClass(className, BiometricFactory.buildArgs(context, transportType, parameters));
        if (biometricDevice != null) {
            biometricDeviceMap.put(biometricDevice.getDeviceTag(), biometricDevice);
        }
        return biometricDevice;
    }

    protected static BiometricDevice createBiometricDevice2(String className, Context context, TransportType transportType, Map<String, Object> parameters) {
        if (className == null || className.equals("")) {
            return null;
        }
        BiometricDevice biometricDevice = (BiometricDevice)BiometricFactory.instanceClass(className, null);
        if (biometricDevice != null) {
            biometricDevice.initBiometricDevice(context, transportType, parameters);
            biometricDeviceMap.put(biometricDevice.getDeviceTag(), biometricDevice);
        }
        return biometricDevice;
    }

    private static Object[] buildArgs(Context context, TransportType transportType, Map<String, Object> parameters) {
        Object[] args = new Object[]{context, transportType, parameters};
        return args;
    }

    private static Object instanceClass(String className, Object[] args) {
        Class<?> biometricDeviceClass = null;
        try {
            biometricDeviceClass = Class.forName(className);
            Constructor<?> constructor = null;
            constructor = null != args ? biometricDeviceClass.getConstructor(ARGS_CLASS) : biometricDeviceClass.getConstructor(new Class[0]);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            LogHelper.printStackTrace(e);
            return null;
        }
    }

    public static void clear() {
        biometricDeviceMap.clear();
    }

    public static void destroy(BiometricDevice biometricDevice) {
        if (biometricDevice != null) {
            biometricDeviceMap.remove(biometricDevice.getDeviceTag());
            biometricDevice.destroy();
        }
    }

    protected static BiometricDevice getExistingBiometricDevice(String deviceTag) {
        return biometricDeviceMap.get(deviceTag);
    }
}

