/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.usbmcu;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.text.TextUtils;
import com.zkteco.android.biometric.core.device.TransportDevice;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.device.usb.ZKUSBHOSTAPIService;
import com.zkteco.android.biometric.core.device.usbmcu.USBMCUHandler;
import com.zkteco.android.biometric.core.device.usbmcu.exception.USBMCUTransportException;
import com.zkteco.android.biometric.core.exception.BiometricTransportException;
import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.core.utils.ToolUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class USBMCUTransportDevice
extends TransportDevice {
    private List<USBMCUHandler> usbHandlerList = new ArrayList<USBMCUHandler>();
    private List<UsbDevice> filterUSBDeviceList = new ArrayList<UsbDevice>();
    private static final int INTERFACE_SUBCLASS = 6;
    private static final int INTERFACE_PROTOCOL = 80;
    private boolean mbConnectExcept = false;
    private boolean mbCtlRetry = false;
    private Context mContext = null;
    private ZKUSBHOSTAPIService mZKUSBHOSTAPISerivce = new ZKUSBHOSTAPIService();
    private int mCurIndex = 0;
    private UsbInterface mUsbInterface = null;
    private int mFilterVendorID = -1;
    private int mFilterProductID = -1;
    private byte[] bufRecv = new byte[64];
    private byte[] bufSend = new byte[64];

    public static void writeLogToFile(String log) {
        try {
            String path;
            File file;
            File dirFile = new File("/sdcard/zkteco/");
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            if (!(file = new File(path = "/sdcard/zkteco/idrlog.txt")).exists()) {
                File dir = new File(file.getParent());
                dir.mkdirs();
                file.createNewFile();
            }
            FileOutputStream outStream = new FileOutputStream(file, true);
            log = log + "\r\n";
            outStream.write(log.getBytes());
            outStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    int getString_descriptor(USBMCUHandler usbHandler, byte desc_index, short langid, byte[] data, int length) {
        return usbHandler.control(128, 6, 0x300 | desc_index, langid, data, length, 1000);
    }

    private String getUsbdescriptor_ascii(USBMCUHandler usbHandler, byte desc_index) {
        byte[] buffer = new byte[256];
        int r = this.getString_descriptor(usbHandler, (byte)0, (short)0, buffer, 256);
        if (r < 4) {
            LogHelper.e("getUsbdescriptor_ascii failed, ret:" + r);
            return "";
        }
        int langid = buffer[2] | buffer[3] << 8;
        r = this.getString_descriptor(usbHandler, desc_index, (short)langid, buffer, 256);
        if (r < 0) {
            LogHelper.e("getUsbdescriptor_ascii2 failed, ret:" + r);
            return "";
        }
        if (buffer[1] != 3) {
            LogHelper.e("getUsbdescriptor_ascii2 failed, no string");
            return "";
        }
        if (buffer[0] > r) {
            LogHelper.e("getUsbdescriptor_ascii2 failed, invalid length");
            return "";
        }
        int di = 0;
        int si = 0;
        byte[] data = new byte[128];
        di = 0;
        for (si = 2; si < buffer[0] && di < 127; si += 2) {
            data[di++] = buffer[si + 1] != 0 ? 63 : buffer[si];
        }
        LogHelper.i("getUsbdescriptor_ascii2 data length:" + di);
        return new String(data, 0, di);
    }

    public USBMCUTransportDevice(Context context) {
        super(context);
    }

    @Override
    public int init() throws USBMCUTransportException {
        if (null == this.context && null == (this.context = ToolUtils.getApplicationContext())) {
            throw USBMCUTransportException.initUSBDeviceFailed();
        }
        this.usbHandlerList.clear();
        this.filterUSBDeviceList.clear();
        this.filterUSBDevice();
        int usbCount = this.countValidDevice();
        if (usbCount > 0) {
            LogHelper.i("found " + usbCount + " devices");
            return usbCount;
        }
        LogHelper.e("no device found!");
        throw USBMCUTransportException.initUSBDeviceFailed();
    }

    @Override
    public void open(Object object) throws BiometricTransportException {
        throw USBMCUTransportException.openUSBDeviceFailed();
    }

    private void filterUSBDevice() {
        Map<String, UsbDevice> usbDeviceList = USBMCUHandler.getUSBDeviceList(this.context);
        this.mFilterVendorID = (Integer)this.parameters.get("param.key.vid");
        this.mFilterProductID = (Integer)this.parameters.get("param.key.pid");
        for (UsbDevice device : usbDeviceList.values()) {
            int vid = device.getVendorId();
            int pid = device.getProductId();
            if (vid == this.mFilterVendorID && pid == this.mFilterProductID) {
                this.filterUSBDeviceList.add(device);
                LogHelper.w("This usb device confirms with specific [VID=" + this.mFilterVendorID + ", PID=" + this.mFilterProductID + "]\nDevice info: " + device.toString());
                continue;
            }
            LogHelper.w("Those usb device don't confirm with specific [VID=" + this.mFilterVendorID + ", PID=" + this.mFilterProductID + "]\nDevice info: " + device.toString());
        }
    }

    public int countValidDevice() {
        return this.filterUSBDeviceList.size();
    }

    @Override
    public void open(int index) throws USBMCUTransportException {
        if (index >= this.countValidDevice()) {
            LogHelper.e("Invalid usb device " + index + " !");
            throw USBMCUTransportException.openInvaliedUSBDevice();
        }
        if (!this.startUSBHandler(index)) {
            throw USBMCUTransportException.openUSBDeviceFailed();
        }
    }

    private boolean startUSBHandler(int index) {
        UsbDevice usbDevice = this.filterUSBDeviceList.get(index);
        if (null == usbDevice) {
            LogHelper.e("invalid device!");
            return false;
        }
        UsbDeviceConnection usbDeviceConnection = USBMCUHandler.getUsbManager(this.context).openDevice(usbDevice);
        if (usbDeviceConnection == null) {
            LogHelper.e("Open usb device " + index + " failed because of USBDeviceConnection is null!");
            return false;
        }
        USBMCUHandler usbHandler = new USBMCUHandler(this.context);
        if (0 >= usbDevice.getInterfaceCount()) {
            LogHelper.e("Opening device " + index + " failed because of getInterfaceCount <= 0!");
            return false;
        }
        if (ToolUtils.isNIDFPSensor(this.mFilterVendorID, this.mFilterProductID)) {
            LogHelper.e("is nid fpsensor!");
        } else {
            UsbInterface usbInterface = usbDevice.getInterface(0);
            UsbEndpoint[] inEndPoint = new UsbEndpoint[2];
            UsbEndpoint[] outEndPoint = new UsbEndpoint[2];
            int j = 0;
            int k = 0;
            for (int i = 0; i < usbInterface.getEndpointCount(); ++i) {
                UsbEndpoint endpoint = usbInterface.getEndpoint(i);
                if (endpoint.getType() != 2) continue;
                if (endpoint.getDirection() == 0 && 1 == endpoint.getEndpointNumber()) {
                    outEndPoint[j++] = endpoint;
                    LogHelper.i("out enpoint type=" + endpoint.getType() + ",num=" + endpoint.getEndpointNumber());
                    continue;
                }
                if (endpoint.getDirection() == 0 || 129 != (endpoint.getEndpointNumber() | 0x80)) continue;
                inEndPoint[k++] = endpoint;
                LogHelper.i("in enpoint type=" + endpoint.getType() + ",num=" + endpoint.getEndpointNumber());
            }
            this.mUsbInterface = usbInterface;
            usbHandler.setOutEndpoint(outEndPoint);
            usbHandler.setInEndpoint(inEndPoint);
        }
        LogHelper.i("inEndpoint=" + usbHandler.getInEndpoint(0));
        LogHelper.i("outEndpoint=" + usbHandler.getOutEndpoint(0));
        if (usbHandler.getInEndpoint(0) == null || usbHandler.getOutEndpoint(0) == null) {
            LogHelper.e("Opening device " + index + " failed because of start USBHandler failed!");
            return false;
        }
        usbDeviceConnection.claimInterface(this.mUsbInterface, true);
        usbHandler.setUsbDeviceConnection(usbDeviceConnection);
        usbHandler.setUsbInterface(this.mUsbInterface);
        USBMCUHandler.setCurrentDeviceIndex(this.mCurIndex);
        usbHandler.setUsbConnectionConfig(usbDevice.getVendorId(), usbDevice.getProductId(), usbDeviceConnection.getFileDescriptor(), usbHandler.getInEndpoint(0) == null ? 0 : usbHandler.getInEndpoint(0).getAddress(), usbHandler.getOutEndpoint(0) == null ? 0 : usbHandler.getOutEndpoint(0).getAddress());
        String name = usbDevice.getDeviceName();
        String[] v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
        int busnum = 0;
        int devnum = 0;
        if (v != null && v.length >= 2) {
            busnum = Integer.parseInt(v[v.length - 2]);
            devnum = Integer.parseInt(v[v.length - 1]);
        }
        this.mZKUSBHOSTAPISerivce.setUSBInfo(usbDevice.getVendorId(), usbDevice.getProductId(), usbDeviceConnection.getFileDescriptor(), busnum, devnum);
        LogHelper.i("Open usb device " + index + " OK");
        this.mZKUSBHOSTAPISerivce.setInEndpoint(usbHandler.getInEndpoint(0));
        this.mZKUSBHOSTAPISerivce.setOutEndpoint(usbHandler.getOutEndpoint(0));
        this.mZKUSBHOSTAPISerivce.setUSBDevConn(usbDeviceConnection);
        this.usbHandlerList.add(this.mCurIndex, usbHandler);
        String strSerialNumber = "";
        usbHandler.setStrSerialNumber(strSerialNumber);
        return true;
    }

    @Override
    public void control(int index, byte[] buffer, int length, int timeout) throws USBMCUTransportException {
        LogHelper.d("Start control USB device " + index);
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(this.mCurIndex)) {
            throw USBMCUTransportException.operateInvalidUSBDevice();
        }
        if (!this.isValidBufferLength(buffer, length)) {
            throw USBMCUTransportException.invalidBufferLength();
        }
        if (buffer != null && buffer.length > 0) {
            ToolUtils.outputHexString(buffer, 0, length);
        }
        long nTickStart = System.currentTimeMillis();
        int ret = 0;
        while (Math.abs(System.currentTimeMillis() - nTickStart) < (long)timeout && (ret = this.usbHandlerList.get(this.mCurIndex).control(buffer, length, timeout)) < 0 && this.mbCtlRetry) {
            LogHelper.e("control fail, ret: " + ret);
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (ret < 0) {
            LogHelper.e("Control USB device " + index + " failed!\nAndroid UsbDeviceConnection return ret is" + ret);
            throw USBMCUTransportException.controlUSBDeviceFailed(ret);
        }
    }

    public void control(byte[] buffer, int length, int timeout) throws USBMCUTransportException {
        this.control(USBMCUHandler.getCurrentDeviceIndex(), buffer, length, timeout);
    }

    @Override
    public void controlEx(int index, int requestType, int request, int value, int addr, byte[] buffer, int length, int timeout) throws USBMCUTransportException {
        LogHelper.d("Start control USB device Extension" + index);
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(this.mCurIndex)) {
            throw USBMCUTransportException.operateInvalidUSBDevice();
        }
        if (!this.isValidBufferLength(buffer, length)) {
            throw USBMCUTransportException.invalidBufferLength();
        }
        if (buffer != null && buffer.length > 0) {
            ToolUtils.outputHexString(buffer);
        }
        int ret = 0;
        long nTickStart = System.currentTimeMillis();
        while (Math.abs(System.currentTimeMillis() - nTickStart) < (long)timeout && (ret = this.usbHandlerList.get(this.mCurIndex).control(requestType, request, value, addr, buffer, length, timeout)) <= 0 && this.mbCtlRetry) {
            LogHelper.e("control fail, ret: " + ret);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (ret < 0) {
            LogHelper.e("Control USB device " + index + " failed!\nAndroid UsbDeviceConnection return ret is" + ret);
            throw USBMCUTransportException.controlUSBDeviceFailed(ret);
        }
    }

    public void controlEx(int requestType, int request, int value, int addr, byte[] buffer, int length, int timeout) throws USBMCUTransportException {
        this.controlEx(USBMCUHandler.getCurrentDeviceIndex(), requestType, request, value, addr, buffer, length, timeout);
    }

    private boolean isValidBufferLength(byte[] buffer, int length) throws USBMCUTransportException {
        if (null != buffer && buffer.length < length) {
            LogHelper.e("Buffer length is less than specified length!");
            return false;
        }
        return true;
    }

    @Override
    public int read(int index, byte[] buffer, int length, int timeout) throws USBMCUTransportException {
        LogHelper.d("Start readMCU USB device " + index + ",length=" + length);
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(this.mCurIndex)) {
            throw USBMCUTransportException.operateInvalidUSBDevice();
        }
        int ret = 0;
        if (!this.isValidBufferLength(buffer, length)) {
            throw USBMCUTransportException.invalidBufferLength();
        }
        long tickStart = System.currentTimeMillis();
        while ((ret = this.usbHandlerList.get(this.mCurIndex).read(this.bufRecv, this.bufRecv.length, timeout)) <= 0 && Math.abs(System.currentTimeMillis() - tickStart) < (long)timeout) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (ret == -1) {
            LogHelper.w("Read USB device " + index + " timout!");
            USBMCUTransportDevice.writeLogToFile("Read USB device " + index + " timout!");
            return 0;
        }
        if (ret <= 0) {
            LogHelper.e("Read USB device " + index + " failed!Android UsbDeviceConnection return ret is " + ret);
            USBMCUTransportDevice.writeLogToFile("Read USB device " + index + " failed!Android UsbDeviceConnection return ret is " + ret);
            return 0;
        }
        System.arraycopy(this.bufRecv, 0, buffer, 0, ret);
        ToolUtils.outputHexString(buffer, 0, ret);
        USBMCUTransportDevice.writeLogToFile("read USB device " + index + " success!ret= " + ret + "data:" + ToolUtils.bytesToHexString(buffer, 0, ret));
        return ret;
    }

    public int read(byte[] buffer, int length, int timeout) throws USBMCUTransportException {
        return this.read(USBMCUHandler.getCurrentDeviceIndex(), buffer, length, timeout);
    }

    @Override
    public void write(int index, byte[] buffer, int length, int timeout) throws USBMCUTransportException {
        LogHelper.d("Start write USBMCU device " + index);
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(this.mCurIndex)) {
            throw USBMCUTransportException.operateInvalidUSBDevice();
        }
        if (!this.isValidBufferLength(buffer, length)) {
            throw USBMCUTransportException.invalidBufferLength();
        }
        ToolUtils.outputHexString(buffer, 0, length);
        int ret = this.usbHandlerList.get(this.mCurIndex).write(buffer, length, timeout);
        if (ret <= 0) {
            USBMCUTransportDevice.writeLogToFile("Write USB device " + index + " failed!\nAndroid UsbDeviceConnection return ret is " + ret);
            LogHelper.e("Write USB device " + index + " failed!\nAndroid UsbDeviceConnection return ret is " + ret);
            throw USBMCUTransportException.writeUSBDeviceFailed(ret);
        }
        USBMCUTransportDevice.writeLogToFile("Write USB device " + index + " success!ret= " + ret + "data:" + ToolUtils.bytesToHexString(buffer, 0, length));
    }

    public void write(byte[] buffer, int length, int timeout) throws USBMCUTransportException {
        this.write(USBMCUHandler.getCurrentDeviceIndex(), buffer, length, timeout);
    }

    @Override
    public void close(int index) throws USBMCUTransportException {
        if (this.usbHandlerList.size() > 0) {
            try {
                this.usbHandlerList.get(this.mCurIndex).close();
            }
            catch (IndexOutOfBoundsException e) {
                LogHelper.e("Invalid index to close! Your invalid index is " + index);
                throw USBMCUTransportException.closeUSBTransportException(-9);
            }
        } else {
            LogHelper.w("No any working USB device, don't need to close");
        }
    }

    @Override
    public void free(int index) throws USBMCUTransportException {
        if (this.usbHandlerList.size() > 0) {
            try {
                this.usbHandlerList.remove(this.usbHandlerList);
            }
            catch (IndexOutOfBoundsException e) {
                LogHelper.e("Invalid index to free! Your invalid index is " + index);
                throw USBMCUTransportException.freeUSBDeviceFailed(-10);
            }
        } else {
            LogHelper.w("No any working USB device, don't need to free");
        }
    }

    @Override
    public void destroy() {
        if (this.usbHandlerList.size() > 0) {
            for (USBMCUHandler usbHandler : this.usbHandlerList) {
                if (null == usbHandler) continue;
                usbHandler.close();
            }
            this.usbHandlerList.clear();
        }
        USBMCUHandler.reset();
        this.filterUSBDeviceList.clear();
        this.parameters = null;
        this.context = null;
        this.mZKUSBHOSTAPISerivce = null;
    }

    @Override
    public TransportType getType() {
        return TransportType.USBMCU;
    }

    @Override
    public boolean isConnectExcepted() {
        return this.mbConnectExcept;
    }

    @Override
    public Object getConnectionService() {
        return this.mZKUSBHOSTAPISerivce;
    }

    @Override
    public void setCtlRetryFlag(boolean bFlag) {
        this.mbCtlRetry = bFlag;
    }

    @Override
    public String getSerialNumber(int index) {
        if (this.usbHandlerList.size() > 0) {
            return this.usbHandlerList.get(this.mCurIndex).getStrSerialNumber();
        }
        return "";
    }

    @Override
    public void reset(int index) throws USBMCUTransportException {
    }

    @Override
    public void reset2(int index) throws BiometricTransportException {
    }

    @Override
    public int getUSBProductID() {
        return this.mFilterProductID;
    }

    @Override
    public int getUSBVendorID() {
        return this.mFilterVendorID;
    }
}

