/*
 * Decompiled with CFR 0.152.
 */
package com.arcsoft.face;

import android.graphics.Rect;
import com.arcsoft.face.Face3DAngle;
import com.arcsoft.face.FaceAttributeInfo;

public class FaceInfo {
    Rect rect;
    int orient;
    int faceId;
    byte[] faceData;
    public static final int FACE_DATA_SIZE = 5000;
    int isWithinBoundary;
    Rect foreheadRect;
    FaceAttributeInfo faceAttributeInfo;
    Face3DAngle face3DAngle;

    public FaceInfo(Rect rect, int orient, int faceId, byte[] faceData, int isWithinBoundary, Rect foreheadRect, FaceAttributeInfo faceAttributeInfo, Face3DAngle face3DAngle) {
        this.rect = new Rect(rect);
        this.orient = orient;
        this.faceId = faceId;
        this.faceData = faceData;
        this.isWithinBoundary = isWithinBoundary;
        this.foreheadRect = new Rect(foreheadRect);
        this.faceAttributeInfo = new FaceAttributeInfo(faceAttributeInfo);
        this.face3DAngle = new Face3DAngle(face3DAngle);
    }

    public FaceInfo(FaceInfo obj) {
        if (obj == null) {
            this.rect = new Rect();
            this.orient = 0;
            this.faceId = 0;
            this.faceData = new byte[5000];
            this.isWithinBoundary = 0;
            this.foreheadRect = new Rect();
            this.faceAttributeInfo = new FaceAttributeInfo();
            this.face3DAngle = new Face3DAngle();
        } else {
            this.rect = new Rect(obj.rect);
            this.orient = obj.orient;
            this.faceId = obj.faceId;
            this.faceData = (byte[])obj.getFaceData().clone();
            this.isWithinBoundary = obj.isWithinBoundary;
            this.foreheadRect = new Rect(obj.foreheadRect);
            this.faceAttributeInfo = new FaceAttributeInfo(obj.faceAttributeInfo);
            this.face3DAngle = new Face3DAngle(obj.face3DAngle);
        }
    }

    public FaceInfo() {
        this.rect = new Rect();
        this.orient = 0;
        this.faceId = 0;
        this.faceData = new byte[5000];
        this.isWithinBoundary = 0;
        this.foreheadRect = new Rect();
        this.faceAttributeInfo = new FaceAttributeInfo();
        this.face3DAngle = new Face3DAngle();
    }

    public Rect getRect() {
        return this.rect;
    }

    public void setRect(Rect rect) {
        this.rect = rect;
    }

    public int getOrient() {
        return this.orient;
    }

    public void setOrient(int orient) {
        this.orient = orient;
    }

    public int getFaceId() {
        return this.faceId;
    }

    public void setFaceId(int faceId) {
        this.faceId = faceId;
    }

    public byte[] getFaceData() {
        return this.faceData;
    }

    public void setFaceData(byte[] faceData) {
        this.faceData = faceData;
    }

    public int getIsWithinBoundary() {
        return this.isWithinBoundary;
    }

    public void setIsWithinBoundary(int isWithinBoundary) {
        this.isWithinBoundary = isWithinBoundary;
    }

    public Rect getForeheadRect() {
        return this.foreheadRect;
    }

    public void setForeheadRect(Rect foreheadRect) {
        this.foreheadRect = foreheadRect;
    }

    public FaceAttributeInfo getFaceAttributeInfo() {
        return new FaceAttributeInfo(this.faceAttributeInfo);
    }

    public void setFaceAttributeInfo(FaceAttributeInfo faceAttributeInfo) {
        this.faceAttributeInfo = faceAttributeInfo;
    }

    public Face3DAngle getFace3DAngle() {
        return new Face3DAngle(this.face3DAngle);
    }

    public void setFace3DAngle(Face3DAngle face3DAngle) {
        this.face3DAngle = face3DAngle;
    }

    public String toString() {
        return "FaceInfo{faceRect=" + this.rect.toString() + ", orient=" + this.orient + ", faceId=" + this.faceId + ", isWithinBoundary=" + this.isWithinBoundary + "\nforeheadRect=" + this.foreheadRect.toString() + ", " + this.face3DAngle.toString() + "\n" + this.faceAttributeInfo.toString() + '}';
    }

    public FaceInfo clone() {
        return new FaceInfo(this);
    }
}

