/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.module.fingerprintreader;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import com.zkteco.android.biometric.FingerprintExceptionListener;
import com.zkteco.android.biometric.core.device.BiometricDevice;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.device.usb.ZKUSBHOSTAPIService;
import com.zkteco.android.biometric.core.exception.BiometricTransportException;
import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.core.utils.ToolUtils;
import com.zkteco.android.biometric.module.fingerprintreader.FingerprintCaptureListener;
import com.zkteco.android.biometric.module.fingerprintreader.FingerprintCaptureThreadPool;
import com.zkteco.android.biometric.module.fingerprintreader.FingerprintInterface;
import com.zkteco.android.biometric.module.fingerprintreader.ZKFingerService;
import com.zkteco.android.biometric.module.fingerprintreader.exception.FingerprintException;
import com.zkteco.biometric.SlkIDCap;
import com.zkteco.zkfinger.FingerprintService;
import com.zkteco.zkfinger.ZKFingerConfig;
import java.util.HashMap;
import java.util.Map;

public class FingerprintSensor
extends BiometricDevice
implements FingerprintInterface {
    private static final String SDK_Version = "2.1.24\t20201209";
    private ZKFPCallBack zkfpCallBack = null;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private int lastTempLen = 0;
    private String lastTempBase64 = "";
    private boolean bManualReleaseZKFinger = false;
    private long mhDevice = 0L;
    private int FingerFakeStatus = 0;
    private int mExceptStatus = 0;
    private int checkFakeFunOn = 0;
    private boolean mbLibusb = false;
    private int MajorVer = 0;
    private int MinorVer = 0;
    private int captureMode = 0;
    private int lastQuality = 0;
    private FingerprintExceptionListener fingerprintExceptionListener = null;
    public static final String KEY_CAPTURE_LISTENER_PREFIX = "key.working.listener.";
    private Map<String, FingerprintCaptureListener> fingerprintCaptureListenerList = new HashMap<String, FingerprintCaptureListener>();

    public void setLibusbFlag(boolean blibUsb) {
        this.mbLibusb = blibUsb;
    }

    public void setCaptureMode(int mode) {
        if (mode == 0 || mode == 1) {
            this.captureMode = mode;
        }
    }

    @Override
    public void SetFingerprintExceptionListener(FingerprintExceptionListener listener) {
        this.fingerprintExceptionListener = listener;
    }

    public FingerprintExceptionListener getFingerprintExceptionListener() {
        return this.fingerprintExceptionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeviceStatus(int index) {
        Object object = this.deviceLock;
        synchronized (object) {
            if (0L == this.mhDevice) {
                return -1;
            }
            int ret = SlkIDCap.status(this.mhDevice);
            if (0 == ret) {
                ret = 1;
            }
            return ret;
        }
    }

    public int getExceptStatus() {
        return this.mExceptStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wdtEnable(int index, int timesecond) {
        Object object = this.deviceLock;
        synchronized (object) {
            if (0L != this.mhDevice) {
                SlkIDCap.wdtEnable(this.mhDevice, timesecond);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wdtReset(int index) {
        Object object = this.deviceLock;
        synchronized (object) {
            if (0L != this.mhDevice) {
                return SlkIDCap.wdtReset(this.mhDevice) >= 0;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebootDevice(int index) throws FingerprintException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (0L != this.mhDevice) {
                int ret = SlkIDCap.reboot(this.mhDevice);
                if (ret < 0) {
                    throw FingerprintException.SetGPIOFail(ret);
                }
            } else {
                throw FingerprintException.openFingerprintSensorFailed(-1);
            }
        }
    }

    public void setManualReleaseZKFinger(boolean bManual) {
        this.bManualReleaseZKFinger = bManual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageDPI(int index, float fDPI) {
        if (fDPI <= 0.0f || 0L == this.mhDevice) {
            return;
        }
        Object object = this.deviceLock;
        synchronized (object) {
            SlkIDCap.setParameter(this.mhDevice, 3, FingerprintSensor.int2ByteArray((int)fDPI), 4);
            byte[] bufValue = new byte[4];
            int[] retSize = new int[]{4};
            SlkIDCap.getParameter(this.mhDevice, 1, bufValue, retSize);
            this.imageWidth = FingerprintSensor.byteArray2Int(bufValue, 0);
            retSize[0] = 4;
            SlkIDCap.getParameter(this.mhDevice, 2, bufValue, retSize);
            this.imageHeight = FingerprintSensor.byteArray2Int(bufValue, 0);
        }
    }

    public String getSDK_Version() {
        return SDK_Version;
    }

    @Override
    public int getImageWidth() {
        return this.imageWidth;
    }

    @Override
    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getFakeStatus() {
        return this.FingerFakeStatus;
    }

    @Override
    public int getLastTempLen() {
        return this.lastTempLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFakeFunOn(int fakeFunOn) {
        this.checkFakeFunOn = fakeFunOn;
        Object object = this.deviceLock;
        synchronized (object) {
            if (0L != this.mhDevice) {
                SlkIDCap.setParameter(this.mhDevice, 2002, FingerprintSensor.int2ByteArray(fakeFunOn), 4);
            }
        }
    }

    public int getFakeFunOn() {
        return this.checkFakeFunOn;
    }

    protected void setLastTempLen(int lastTempLen) {
        this.lastTempLen = lastTempLen;
    }

    protected void setLastTempBase64(String strTemplate) {
        this.lastTempBase64 = strTemplate;
    }

    public String getLastTempBase64() {
        return this.lastTempBase64;
    }

    public int getLastQuality() {
        return this.lastQuality;
    }

    @Override
    public String getStrSerialNumber() {
        return this.transportDevice.getSerialNumber(0);
    }

    @Override
    public String getFirmwareVersion() {
        String strVersion = this.MajorVer + "." + this.MinorVer;
        return strVersion;
    }

    public FingerprintSensor(Context context, TransportType transportType, Map<String, Object> parameters) {
        super(context, transportType, parameters);
    }

    public FingerprintSensor() {
    }

    public Map<String, FingerprintCaptureListener> getFingerprintCaptureListenerList() {
        return this.fingerprintCaptureListenerList;
    }

    public void openAndReboot(int index) throws FingerprintException {
        try {
            this.transportDevice.init();
            this.transportDevice.open(index);
            int ret = SlkIDCap.rebootEx(this.transportDevice.getConnectionService());
            this.transportDevice.close(index);
            if (ret < 0) {
                throw FingerprintException.SetGPIOFail(ret);
            }
        }
        catch (BiometricTransportException e) {
            throw FingerprintException.openFingerprintSensorFailed(e.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryOpenDevice(int index, UsbDevice usbDevice) throws FingerprintException {
        Object object = this.deviceLock;
        synchronized (object) {
            try {
                this.mExceptStatus = 0;
                if (null != usbDevice) {
                    this.transportDevice.open((Object)usbDevice);
                } else {
                    this.transportDevice.init();
                    this.transportDevice.open(index);
                }
                ZKUSBHOSTAPIService zkusbhostapiService = (ZKUSBHOSTAPIService)this.transportDevice.getConnectionService();
                this.mhDevice = this.mbLibusb ? SlkIDCap.openDeviceByFD(zkusbhostapiService.getVendorID(), zkusbhostapiService.getProductID(), zkusbhostapiService.getBusNum(), zkusbhostapiService.getDevAddr(), zkusbhostapiService.getFD(), zkusbhostapiService.getInEndPointAddr(), zkusbhostapiService.getOutEndPointAddr()) : SlkIDCap.openDeviceByAndroidHost(zkusbhostapiService);
                if (0L == this.mhDevice) {
                    throw FingerprintException.openFingerprintSensorFailed(-1);
                }
                this.setFakeFunOn(this.checkFakeFunOn);
                this.setImageDPI(index, 500.0f);
                if (this.captureMode == 0) {
                    SlkIDCap.setParameter(this.mhDevice, 5, FingerprintSensor.int2ByteArray(0), 4);
                } else {
                    SlkIDCap.setParameter(this.mhDevice, 5, FingerprintSensor.int2ByteArray(1), 4);
                }
                byte[] paramvalue = new byte[4];
                int[] retSize = new int[]{4};
                SlkIDCap.getParameter(this.mhDevice, 202, paramvalue, retSize);
                this.MajorVer = paramvalue[1];
                this.MinorVer = paramvalue[0];
                if (!ZKFingerConfig.isOnlyCapture()) {
                    if (null == this.zkfpCallBack) {
                        this.zkfpCallBack = new ZKFPCallBack(this);
                        FingerprintService.SetCallBack((FingerprintService.CBInterface)this.zkfpCallBack);
                    }
                    int[] limit = new int[1];
                    int ret = ZKFingerService.init();
                    if (0 != ret) {
                        LogHelper.e((String)"Init zkfinger10 fail");
                        SlkIDCap.closeDevice(this.mhDevice);
                        this.mhDevice = 0L;
                        this.transportDevice.close(index);
                        this.transportDevice.free(index);
                        throw FingerprintException.initFpServiceFailed(ret);
                    }
                    if (ZKFingerService.getLicenseType() == 3) {
                        LogHelper.e((String)"Init zkfinger10 fail, because no license");
                        SlkIDCap.closeDevice(this.mhDevice);
                        this.mhDevice = 0L;
                        this.transportDevice.close(index);
                        this.transportDevice.free(index);
                        ZKFingerService.free();
                        throw FingerprintException.initFpServiceFailed(ret);
                    }
                    byte[] version = new byte[128];
                    ZKFingerService.setParameter((int)1, (int)50);
                    FingerprintService.version((byte[])version);
                    System.out.println("version=" + new String(version).trim());
                }
            }
            catch (BiometricTransportException e) {
                LogHelper.e((String)("Open fingerprint sensor " + index + " failed!Reason: " + e.getMessage() + "Internal error code: " + e.getErrorCode()));
                throw FingerprintException.openFingerprintSensorFailed(e.getInternalErrorCode());
            }
        }
    }

    @Override
    public void open(int index) throws FingerprintException {
        this.tryOpenDevice(index, null);
    }

    public void open(UsbDevice usbDevice) throws FingerprintException {
        this.tryOpenDevice(0, usbDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int index) throws FingerprintException {
        Object object = this.deviceLock;
        synchronized (object) {
            try {
                if (0L != this.mhDevice) {
                    SlkIDCap.closeDevice(this.mhDevice);
                    this.mhDevice = 0L;
                }
                this.transportDevice.close(index);
                this.transportDevice.free(index);
                if (!ZKFingerConfig.isOnlyCapture()) {
                    FingerprintService.ResetCallBack((FingerprintService.CBInterface)this.zkfpCallBack);
                    if (!this.bManualReleaseZKFinger) {
                        ZKFingerService.free();
                    }
                }
                this.zkfpCallBack = null;
                this.mExceptStatus = 0;
            }
            catch (BiometricTransportException e) {
                LogHelper.e((String)("Close fingerprint sensor " + index + " failed!Reason: " + e.getMessage() + "Internal error code: " + e.getErrorCode()));
                throw FingerprintException.closeFingerprintSensorFailed(e.getInternalErrorCode());
            }
        }
    }

    @Override
    public void setFingerprintCaptureListener(int index, FingerprintCaptureListener listener) {
        this.fingerprintCaptureListenerList.put(KEY_CAPTURE_LISTENER_PREFIX + index, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCapture(int index) throws FingerprintException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (index < 0 || this.fingerprintCaptureListenerList.size() <= 0) {
                LogHelper.e((String)"Start fingerprint capture thread failed!");
                throw FingerprintException.startCaptureThreadFailed();
            }
            FingerprintCaptureThreadPool.start(this, index);
            LogHelper.d((String)("Start fingerprint capture thread " + index + " OK"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(int index, int code, int value) {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.mhDevice == 0L) {
                return;
            }
            int n = SlkIDCap.setParameter(this.mhDevice, code, ToolUtils.intToByteArray((int)value), 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upgrade(int index, byte[] data, int size) {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.mhDevice == 0L) {
                return false;
            }
            int retVal = SlkIDCap.upgrade(this.mhDevice, data, size);
            return retVal == 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!ZKFingerConfig.isOnlyCapture()) {
                if (null != this.zkfpCallBack) {
                    FingerprintService.ResetCallBack((FingerprintService.CBInterface)this.zkfpCallBack);
                    this.zkfpCallBack = null;
                }
                if (!this.bManualReleaseZKFinger) {
                    ZKFingerService.free();
                }
            }
            FingerprintCaptureThreadPool.destroy();
            this.fingerprintCaptureListenerList.clear();
            this.transportDevice.destroy();
            this.deviceLock = null;
        }
    }

    @Override
    public void stopCapture(int index) throws FingerprintException {
        if (index < 0 || this.fingerprintCaptureListenerList.size() <= 0) {
            LogHelper.e((String)"Stop fingerprint capture thread failed!");
            throw FingerprintException.stopCaptureThreadFailed();
        }
        FingerprintCaptureThreadPool.cancel(this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void capture(int index, byte[] fpImg) throws FingerprintException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (0L == this.mhDevice) {
                throw FingerprintException.openFingerprintSensorFailed(-1);
            }
            int ret = 0;
            ret = SlkIDCap.capture(this.mhDevice, fpImg, fpImg.length);
            if (ret <= 0) {
                this.FingerFakeStatus = 0;
                this.lastQuality = 0;
                throw FingerprintException.CaptureFail(ret);
            }
            byte[] paramValue = new byte[4];
            int[] retSize = new int[]{4};
            SlkIDCap.getParameter(this.mhDevice, 2004, paramValue, retSize);
            this.FingerFakeStatus = FingerprintSensor.byteArray2Int(paramValue, 0);
            retSize[0] = 4;
            SlkIDCap.getParameter(this.mhDevice, 1016, paramValue, retSize);
            this.lastQuality = FingerprintSensor.byteArray2Int(paramValue, 0);
        }
    }

    public static int byteArray2Short(byte[] bufValue, int offset) {
        if (null == bufValue || bufValue.length < 2 + offset) {
            return 0;
        }
        int value = 0;
        value = bufValue[offset + 0] & 0xFF;
        return value += bufValue[offset + 1] << 8 & 0xFF00;
    }

    public static byte[] int2ByteArray(int number) {
        byte[] value = new byte[]{(byte)(number & 0xFF), (byte)((number & 0xFF00) >> 8), (byte)((number & 0xFF0000) >> 16), (byte)((number & 0xFF000000) >> 24)};
        return value;
    }

    public static int byteArray2Int(byte[] bufValue, int offset) {
        if (null == bufValue || bufValue.length < 4 + offset) {
            return 0;
        }
        int value = 0;
        value = bufValue[offset + 0] & 0xFF;
        value += bufValue[offset + 1] << 8 & 0xFF00;
        value += bufValue[offset + 2] << 16 & 0xFF0000;
        return value += bufValue[offset + 3] << 24 & 0xFF000000;
    }

    class ZKFPCallBack
    implements FingerprintService.CBInterface {
        FingerprintSensor fingerprintSensor = null;

        ZKFPCallBack(FingerprintSensor fingerprintSensor) {
            this.fingerprintSensor = fingerprintSensor;
        }

        public int CheckSensor(int code) {
            if (0L != FingerprintSensor.this.mhDevice) {
                return SlkIDCap.checkSensor(FingerprintSensor.this.mhDevice, code);
            }
            return 0;
        }
    }
}

