/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.usbmcu.exception;

import com.zkteco.android.biometric.core.exception.BiometricTransportException;

public class USBMCUTransportException
extends BiometricTransportException {
    private static final String INIT_USB_DEVICE_FAILED = "Initialize USB device failed";
    private static final String OPEN_INVALID_USB_DEVICE = "Try to open a invalid USB device";
    private static final String OPEN_DEVICE_FAILED = "Open USB device failed";
    private static final String INVALID_BUFFER_LENGTH = "Invalid buffer length, buffer length is less than specified length";
    private static final String CONTROL_INVALID_USB_DEVICE = "Control invalid USB device";
    private static final String CONTROL_USB_DEVICE_FAILED = "Control USB device failed";
    private static final String READ_USB_DEVICE_FAILED = "Read USB device failed";
    private static final String WRITE_USB_DEVICE_FAILED = "Write USB device failed";
    private static final String CLOSE_USB_DEVICE_FAILED = "Close USB device failed";
    private static final String FREE_USB_DEVICE_FAILED = "Free USB device failed";

    USBMCUTransportException(String message, int errorCode) {
        super(message, errorCode);
    }

    USBMCUTransportException(String message, int errorCode, int internalErrorCode) {
        super(message, errorCode, internalErrorCode);
    }

    public static USBMCUTransportException initUSBDeviceFailed() {
        return new USBMCUTransportException(INIT_USB_DEVICE_FAILED, -1);
    }

    public static USBMCUTransportException openInvaliedUSBDevice() {
        return new USBMCUTransportException(OPEN_INVALID_USB_DEVICE, -2);
    }

    public static USBMCUTransportException openUSBDeviceFailed() {
        return new USBMCUTransportException(OPEN_DEVICE_FAILED, -3);
    }

    public static USBMCUTransportException operateInvalidUSBDevice() {
        return new USBMCUTransportException(CONTROL_INVALID_USB_DEVICE, -5);
    }

    public static USBMCUTransportException invalidBufferLength() {
        return new USBMCUTransportException(INVALID_BUFFER_LENGTH, -4);
    }

    public static USBMCUTransportException controlUSBDeviceFailed(int internalErrorCode) {
        return new USBMCUTransportException(CONTROL_USB_DEVICE_FAILED, -6, internalErrorCode);
    }

    public static USBMCUTransportException readUSBDeviceFailed(int internalErrorCode) {
        return new USBMCUTransportException(READ_USB_DEVICE_FAILED, -7, internalErrorCode);
    }

    public static USBMCUTransportException writeUSBDeviceFailed(int internalErrorCode) {
        return new USBMCUTransportException(WRITE_USB_DEVICE_FAILED, -8, internalErrorCode);
    }

    public static USBMCUTransportException closeUSBTransportException(int errorCode) {
        return new USBMCUTransportException(CLOSE_USB_DEVICE_FAILED, errorCode);
    }

    public static USBMCUTransportException freeUSBDeviceFailed(int errorCode) {
        return new USBMCUTransportException(FREE_USB_DEVICE_FAILED, errorCode);
    }
}

