/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.api.cls;

import com.uhf.api.cls.R2000CheckFlashSendData;
import com.uhf.api.cls.R2000DataCmdReturn;
import com.uhf.api.cls.R2000WriteFlashSendData;
import com.uhf.api.cls.R2000_calibration;
import com.uhf.api.cls.Reader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class R2000Command
implements Runnable {
    public String filename;
    public int Percent;
    public static final byte headerCode = -1;
    private static int[] crcTable = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935};
    public static InputStream is;
    public static OutputStream os;
    public FileOutputStream fos;
    public static FileInputStream fis;

    private void toDlogAPI(String mess) {
    }

    private void toDlog(String mess) {
    }

    @Override
    public void run() {
        try {
            R2000Command.Updatebyserial(this.filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] Get_Build_ToOp_Cmds(R2000CmdCode Rcc) {
        byte[] br2000cmd = new byte[5];
        br2000cmd[0] = -1;
        br2000cmd[1] = 0;
        br2000cmd[2] = (byte)Rcc.value;
        byte[] crc = R2000Command.calcCRC(br2000cmd, 1, br2000cmd[1] + 4);
        br2000cmd[br2000cmd.length - 2] = crc[0];
        br2000cmd[br2000cmd.length - 1] = crc[1];
        return br2000cmd;
    }

    public static byte[] Get_Build_ToOp_Cmds(R2000CmdCode Rcc, byte[] data) {
        byte[] br2000cmd = new byte[5 + data.length];
        br2000cmd[0] = -1;
        br2000cmd[1] = (byte)data.length;
        br2000cmd[2] = (byte)Rcc.value;
        for (int i = 0; i < data.length; ++i) {
            br2000cmd[i + 3] = data[i];
        }
        byte[] crc = R2000Command.calcCRC(br2000cmd, 1, br2000cmd[1] + 4);
        br2000cmd[br2000cmd.length - 2] = crc[0];
        br2000cmd[br2000cmd.length - 1] = crc[1];
        return br2000cmd;
    }

    public int getError(byte[] data) {
        byte error = data[3];
        byte datalength = data[1];
        byte op = data[2];
        return error;
    }

    public static byte[] calcCRC(byte[] message, int offset, int length) {
        int crc = 65535;
        for (int i = offset; i < offset + length; ++i) {
            crc = (crc << 4 | message[i] >> 4 & 0xF) ^ crcTable[crc >> 12];
            crc &= 0xFFFF;
            crc = (crc << 4 | message[i] >> 0 & 0xF) ^ crcTable[crc >> 12];
            crc &= 0xFFFF;
        }
        short scrc = (short)crc;
        byte[] bcrc = new byte[]{(byte)((0xFF00 & scrc) >> 8), (byte)(0xFF & scrc)};
        return bcrc;
    }

    public static byte[] getResp(byte opcode) throws Exception {
        int isr;
        int pos = 0;
        byte[] CmdBuf = new byte[1000];
        int doct = 0;
        while (is.available() < 1) {
            Thread.sleep(20L);
            if (++doct < 250) continue;
        }
        if ((isr = is.read(CmdBuf, pos, 5)) == -1) {
            throw new Exception("no data return");
        }
        if (isr < 5) {
            is.read(CmdBuf, pos + isr, 5 - isr);
        }
        int startpos = 0;
        for (int i = 0; i < 3; ++i) {
            if (CmdBuf[i] != -1) continue;
            startpos = i;
            break;
        }
        if (CmdBuf[pos] != -1) {
            Thread.sleep(1500L);
            throw new Exception("interal_Msg_Format_err");
        }
        if (CmdBuf[2 + startpos] != opcode) {
            Thread.sleep(1500L);
            throw new Exception("opcode_err");
        }
        pos += 5;
        doct = 0;
        while (is.available() < 1) {
            Thread.sleep(20L);
            if (++doct < 250) continue;
        }
        if (CmdBuf[2 + startpos] == 2) {
            doct = 0;
            for (isr = 0; isr < CmdBuf[1 + startpos] * 4 + 2; isr += is.read(CmdBuf, pos + isr, CmdBuf[1 + startpos] * 4 + 2 - isr)) {
                if (++doct < 5) continue;
                break;
            }
        } else {
            doct = 0;
            while (isr < CmdBuf[1 + startpos] + 2) {
                isr += is.read(CmdBuf, pos + isr, CmdBuf[1 + startpos] + 2 - isr);
                if (++doct < 5) continue;
            }
        }
        byte[] getdata = new byte[7 + CmdBuf[1 + startpos]];
        System.arraycopy(CmdBuf, startpos, getdata, 0, getdata.length);
        byte[] returnCRC = new byte[2];
        byte[] inputBufferNoCRC = new byte[getdata.length - 2];
        System.arraycopy(getdata, 0, inputBufferNoCRC, 0, inputBufferNoCRC.length);
        returnCRC = R2000Command.calcCRC(inputBufferNoCRC, 1, inputBufferNoCRC[1] + 4);
        if (getdata[getdata.length - 2] != returnCRC[0] || getdata[getdata.length - 1] != returnCRC[1]) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            throw new Exception("MSG_CRC_ERROR");
        }
        int err = new R2000Command().getError(getdata);
        if (err != 0) {
            throw new Exception("ERROR:" + String.valueOf(err));
        }
        return getdata;
    }

    private static byte[] SendAndRecvSlMsg(byte[] data) throws Exception {
        os.write(data, 0, data.length);
        byte[] resbytes = R2000Command.getResp(data[2]);
        return resbytes;
    }

    public static byte[] Build_ToOp_Cmds(R2000CmdCode Rcc) throws Exception {
        byte[] br2000cmd = new byte[5];
        br2000cmd[0] = -1;
        br2000cmd[1] = 0;
        br2000cmd[2] = (byte)Rcc.Value();
        byte[] crc = R2000Command.calcCRC(br2000cmd, 1, (br2000cmd[1] & 0xFF) + 2);
        br2000cmd[br2000cmd.length - 2] = crc[0];
        br2000cmd[br2000cmd.length - 1] = crc[1];
        byte[] databack = null;
        databack = R2000Command.SendAndRecvSlMsg(br2000cmd);
        return databack;
    }

    public static byte[] Build_ToOp_Cmds(R2000CmdCode Rcc, byte[] data) throws Exception {
        byte[] br2000cmd = new byte[5 + data.length];
        br2000cmd[0] = -1;
        br2000cmd[1] = (byte)data.length;
        br2000cmd[2] = (byte)Rcc.Value();
        for (int i = 0; i < data.length; ++i) {
            br2000cmd[i + 3] = data[i];
        }
        byte[] crc = R2000Command.calcCRC(br2000cmd, 1, (br2000cmd[1] & 0xFF) + 2);
        br2000cmd[br2000cmd.length - 2] = crc[0];
        br2000cmd[br2000cmd.length - 1] = crc[1];
        byte[] backdata = null;
        backdata = R2000Command.SendAndRecvSlMsg(br2000cmd);
        return backdata;
    }

    public static void Updatebyserial(String filename) throws Exception {
        Integer val = 0;
        R2000Command.Updatebyserial(filename, val);
    }

    public static void Updatebyserial(String filename, Object val) throws Exception {
        int carry;
        int wtotlen;
        File fi = new File(filename);
        int rest = wtotlen = (int)fi.length();
        byte[] cmd_checkfm = new byte[]{-1, 0, 3, 29, 12};
        byte[] response = null;
        int doi = 0;
        int max = 2;
        while (true) {
            try {
                response = R2000Command.SendAndRecvSlMsg(cmd_checkfm);
            }
            catch (Exception ex) {
                if (doi < max) continue;
                throw ex;
                if (doi++ < 2) continue;
            }
            break;
        }
        if (response[3] + response[4] != 0) {
            throw new Exception("status:" + String.valueOf(response[3] << 8 | response[4]));
        }
        float[] fval = (float[])val;
        if (fval == null) {
            fval = new float[1];
            val = fval;
        }
        fval[0] = 0.01f;
        int address = 0x10A000;
        switch (response[9] & 0xFF) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 32: {
                break;
            }
            case 160: 
            case 161: 
            case 168: 
            case 169: 
            case 170: 
            case 171: {
                address = 0x104000;
                break;
            }
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: {
                address = 0x8003000;
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 255: {
                address = 0x8008000;
                break;
            }
        }
        int vaddress = address;
        String moduleaddr = "T:" + Integer.toHexString(response[9] & 0xFF) + " D:" + Integer.toHexString(address) + " M:" + Reader.bytes_Hexstr(response);
        fis = new FileInputStream(fi);
        R2000DataCmdReturn rdcr = new R2000DataCmdReturn();
        try {
            rdcr.GetData(R2000Command.Build_ToOp_Cmds(R2000CmdCode.GetCurLayer));
            if (rdcr.SData() == 18) {
                R2000_calibration r2kcal = new R2000_calibration();
                byte[] cmd_readytoup = r2kcal.GetSendCmd(R2000_calibration.R2000cmd.DefaultConfig, new byte[]{-85, 1});
                response = R2000Command.SendAndRecvSlMsg(cmd_readytoup);
                if (response[3] + response[4] != 0) {
                    throw new Exception("ready to update failed status:" + String.valueOf(response[3] << 8 | response[4]));
                }
                rdcr.GetData(R2000Command.Build_ToOp_Cmds(R2000CmdCode.ReadyWriteFlash));
            }
            fval[0] = 0.02f;
            Thread.sleep(500L);
        }
        catch (Exception mex) {
            Thread.sleep(1000L);
            rdcr.GetData(R2000Command.Build_ToOp_Cmds(R2000CmdCode.GetCurLayer));
            if (rdcr.SData() == 18) {
                R2000_calibration r2kcal = new R2000_calibration();
                byte[] cmd_readytoup = r2kcal.GetSendCmd(R2000_calibration.R2000cmd.DefaultConfig, new byte[]{-85, 1});
                response = R2000Command.SendAndRecvSlMsg(cmd_readytoup);
                if (response[3] + response[4] != 0) {
                    throw new Exception("ready to update failed status:" + String.valueOf(response[3] << 8 | response[4]));
                }
                rdcr.GetData(R2000Command.Build_ToOp_Cmds(R2000CmdCode.ReadyWriteFlash));
            }
            fval[0] = 0.02f;
            Thread.sleep(500L);
        }
        while (rest > 0) {
            int f;
            int var;
            byte[] wdata = new byte[128];
            if (rest >= 128) {
                fis.read(wdata, 0, 128);
                var = 128;
                f = 0;
                if (rest == 128) {
                    f = 255;
                }
            } else {
                fis.read(wdata, 0, rest);
                if (wdata.length % 4 != 0) {
                    throw new Exception("Firmware file len error");
                }
                var = rest;
                f = 255;
            }
            if (wdata == null) {
                throw new Exception("Firmware File not accessible");
            }
            R2000WriteFlashSendData rwfsd = new R2000WriteFlashSendData(f, vaddress, wdata);
            rdcr.GetData(R2000Command.Build_ToOp_Cmds(R2000CmdCode.WriteFlash, rwfsd.To_CmdData()));
            rest -= var;
            fval[0] = (float)((double)((vaddress += var) - address) * 1.0 / (double)wtotlen * 0.96 + 0.02);
        }
        fis.close();
        fis = new FileInputStream(fi);
        byte[] buffer = new byte[wtotlen];
        int getc = fis.read(buffer, 0, wtotlen);
        if (getc != wtotlen && (getc = fis.read(buffer, 0, wtotlen)) != wtotlen) {
            throw new Exception("lost Firmware data");
        }
        R2000CheckFlashSendData rcfsd = new R2000CheckFlashSendData(address, buffer);
        rdcr.GetData(R2000Command.Build_ToOp_Cmds(R2000CmdCode.CheckFlash, rcfsd.To_CmdData()));
        fval[0] = 0.99f;
        for (carry = 0; carry < 5; ++carry) {
            try {
                rdcr.GetData(R2000Command.Build_ToOp_Cmds(R2000CmdCode.CarrytoProgram));
            }
            catch (Exception ex) {
                continue;
            }
            fval[0] = 1.0f;
            break;
        }
        if (carry >= 5) {
            throw new Exception("Can't boot Firmware:" + moduleaddr);
        }
    }

    public static enum R2000CmdSatus {
        Non_Identifiability_CMD(136),
        OK(0),
        Error_Or_Failed(255),
        NonTag(1),
        RSSI_High(255),
        OptionCodeError(2),
        AntSetError(254),
        PWD_ERR_OR_TAG_NO_RESPONE(80),
        TagNonsupportedOrLowPwr(32),
        MemOverranging(33),
        TagLocked(34),
        TagOpFailed(48),
        PswZeroError(81),
        ModuleFatalError(238),
        Temperatrue_High(253);

        private int value = 0;

        private R2000CmdSatus(int value) {
            this.value = value;
        }

        public static R2000CmdSatus valueOf(int value) {
            switch (value) {
                case 0: {
                    return OK;
                }
                case 136: {
                    return Non_Identifiability_CMD;
                }
                case 1: {
                    return NonTag;
                }
                case 251: {
                    return Error_Or_Failed;
                }
                case 255: {
                    return RSSI_High;
                }
                case 2: {
                    return OptionCodeError;
                }
                case 254: {
                    return AntSetError;
                }
                case 33: {
                    return MemOverranging;
                }
                case 34: {
                    return TagLocked;
                }
                case 48: {
                    return TagOpFailed;
                }
                case 81: {
                    return PswZeroError;
                }
                case 238: {
                    return ModuleFatalError;
                }
                case 253: {
                    return Temperatrue_High;
                }
                case 80: {
                    return PWD_ERR_OR_TAG_NO_RESPONE;
                }
                case 32: {
                    return TagNonsupportedOrLowPwr;
                }
            }
            return OK;
        }
    }

    public static enum R2000CmdCode {
        RFPwdSet(15),
        FrequencySelect(16),
        CustomFrequencySelect(17),
        SetSession(19),
        SingleTagInventry(33),
        MuliteTagInventry(34),
        WriteTagMem(36),
        ReadTagMem(40),
        FetchTag(41),
        GetRFPower(65),
        GetCurrentFrequency(66),
        GetCurrentSession(67),
        GetVersion(68),
        CarrytoProgram(4),
        LockTag(37),
        KillTag(38),
        SetIO(80),
        GetIOStatus(81),
        AntSet(20),
        AntGet(21),
        GetCurLayer(12),
        WriteFlash(1),
        ReadyWriteFlash(9),
        CheckFlash(8);

        private int value = 0;

        public int Value() {
            return this.value;
        }

        private R2000CmdCode(int value) {
            this.value = value;
        }
    }
}

