/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.module.fingerprintreader.exception;

import com.zkteco.android.biometric.core.exception.BiometricHandleException;

public class FingerprintException
extends BiometricHandleException {
    private static final String OPEN_FINGERVEIN_SENSOR_FAILED = "Open fingprint sensor failed";
    private static final String CLOSE_FINGERVEIN_SENSOR_FAILED = "Close fingprint sensor failed";
    private static final String GET_GPIO_FAILED = "Get GPIO failed";
    private static final String SET_GPIO_FAILED = "Set GPIO failed";
    private static final String READ_EEPROM_FAILED = "Read Eeprom failed";
    private static final String GET_IMAGE_FAILED = "Get Image failed";
    private static final String DET_IMAGE_FAILED = "Get Image failed";
    private static final String SET_CORRECT_PARAMS_FAILED = "Set correct parameter failed";
    private static final String CAPTURE_FAILED = "Capture failed";
    private static final String DECRYPT_FAILED = "Decrypt failed";
    private static final String INIT_FPSERVICE_FAILED = "Initialize fingprint service failed";
    private static final String START_CAPTURE_FV_THREAD_FAILED = "Start fingprint capture thread failed";
    private static final String STOP_CAPTURE_FV_THREAD_FAILED = "Stop fingprint capture thread failed";

    FingerprintException(String message, int errorCode) {
        super(message, errorCode);
    }

    FingerprintException(String message, int errorCode, int internalErrorCode) {
        super(message, errorCode, internalErrorCode);
    }

    public static FingerprintException openFingerprintSensorFailed(int internalErrorCode) {
        return new FingerprintException(OPEN_FINGERVEIN_SENSOR_FAILED, -20001, internalErrorCode);
    }

    public static FingerprintException closeFingerprintSensorFailed(int internalErrorCode) {
        return new FingerprintException(CLOSE_FINGERVEIN_SENSOR_FAILED, -20002, internalErrorCode);
    }

    public static FingerprintException GetGPIOFail(int internalErrorCode) {
        return new FingerprintException(GET_GPIO_FAILED, -20003, internalErrorCode);
    }

    public static FingerprintException SetGPIOFail(int internalErrorCode) {
        return new FingerprintException(SET_GPIO_FAILED, -20004, internalErrorCode);
    }

    public static FingerprintException ReadEepromFail(int internalErrorCode) {
        return new FingerprintException(READ_EEPROM_FAILED, -20005, internalErrorCode);
    }

    public static FingerprintException GetIMAGEFail(int internalErrorCode) {
        return new FingerprintException("Get Image failed", -20006, internalErrorCode);
    }

    public static FingerprintException DetIMAGEFail(int internalErrorCode) {
        return new FingerprintException("Get Image failed", -20007, internalErrorCode);
    }

    public static FingerprintException SetCorrectParamsFail(int internalErrorCode) {
        return new FingerprintException(SET_CORRECT_PARAMS_FAILED, -20015, internalErrorCode);
    }

    public static FingerprintException CaptureFail(int internalErrorCode) {
        return new FingerprintException(CAPTURE_FAILED, -20010, internalErrorCode);
    }

    public static FingerprintException DecryptFail(int internalErrorCode) {
        return new FingerprintException(DECRYPT_FAILED, -20011, internalErrorCode);
    }

    public static FingerprintException startCaptureThreadFailed() {
        return new FingerprintException(START_CAPTURE_FV_THREAD_FAILED, -20012);
    }

    public static FingerprintException stopCaptureThreadFailed() {
        return new FingerprintException(STOP_CAPTURE_FV_THREAD_FAILED, -20013);
    }

    public static FingerprintException initFpServiceFailed(int internalErrorCode) {
        return new FingerprintException(INIT_FPSERVICE_FAILED, -20014, internalErrorCode);
    }
}

