/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkfinger;

import android.app.Application;
import android.content.Context;
import com.zkteco.biometric.IDFprService;
import com.zkteco.zkfinger.ZKFingerConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ZKIDFprService {
    public static Context getApplicationContext() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Method method = activityThreadClass.getMethod("currentApplication", new Class[0]);
            Application app = (Application)method.invoke(null, (Object[])null);
            if (app != null) {
                return app.getApplicationContext();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public static int init() {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return IDFprService.begin(ZKIDFprService.getApplicationContext());
    }

    public static int free() {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return IDFprService.end();
    }

    public static int imageMatch(byte[] bitmapImage, byte[] temp, float[] score) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return IDFprService.imageMatch(bitmapImage, temp, score);
    }

    public static int gtQualityScore(byte[] bitmapImage, byte[] score) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return IDFprService.getQualityScore(bitmapImage, score);
    }

    public static int getVersion(byte[] libVersion) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return IDFprService.getVersion(libVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int imageMatch2(byte[] rawimage1, byte[] rawimage2, float[] score) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        byte[] feature1 = new byte[2048];
        byte[] feature2 = new byte[2048];
        score[0] = 0.0f;
        try {
            int ret = IDFprService.featureExtract((byte)-1, (byte)11, rawimage1, feature1);
            if (1 != ret) {
                int n = 0;
                return n;
            }
            ret = IDFprService.featureExtract((byte)-1, (byte)11, rawimage2, feature2);
            if (1 != ret) {
                int n = 0;
                return n;
            }
            int n = ret = IDFprService.featureMatch(feature1, feature2, score);
            return n;
        }
        finally {
            feature1 = null;
            feature2 = null;
        }
    }

    public static int featureExtract(byte cScannerType, byte cFingerCode, byte[] pFingerImgBuf, byte[] pFeatureData) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return IDFprService.featureExtract(cScannerType, cFingerCode, pFingerImgBuf, pFeatureData);
    }

    public static int featureMatch(byte[] pFeatureData1, byte[] pFeatureData2, float[] pfSimilarity) {
        if (ZKFingerConfig.isOnlyCapture()) {
            return -1;
        }
        return IDFprService.featureMatch(pFeatureData1, pFeatureData2, pfSimilarity);
    }
}

