/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.usb;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.text.TextUtils;
import com.zkteco.android.biometric.ZKUSBDeviceCtl;
import com.zkteco.android.biometric.core.device.TransportDevice;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.device.usb.USBHandler;
import com.zkteco.android.biometric.core.device.usb.ZKUSBHOSTAPIService;
import com.zkteco.android.biometric.core.device.usb.exception.USBTransportException;
import com.zkteco.android.biometric.core.exception.BiometricTransportException;
import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.core.utils.ToolUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class USBTransportDevice
extends TransportDevice {
    private List<USBHandler> usbHandlerList = new ArrayList<USBHandler>();
    private List<UsbDevice> filterUSBDeviceList = new ArrayList<UsbDevice>();
    private static final int INTERFACE_SUBCLASS = 6;
    private static final int INTERFACE_PROTOCOL = 80;
    private boolean mbConnectExcept = false;
    private boolean mbCtlRetry = false;
    private Context mContext = null;
    private ZKUSBHOSTAPIService mZKUSBHOSTAPISerivce = new ZKUSBHOSTAPIService();
    private int mCurIndex = 0;
    private UsbInterface mUsbInterface = null;
    private int mFilterVendorID = -1;
    private int mFilterProductID = -1;
    private String mDeviceName = "";
    private static final int IDRVID = 1024;
    private static final int IDRPID = 50010;
    private int DEFAULT_TIMEOUT = 500;

    int getString_descriptor(USBHandler usbHandler, byte desc_index, short langid, byte[] data, int length) {
        return usbHandler.control(128, 6, 0x300 | desc_index, langid, data, length, 1000);
    }

    private String getUsbdescriptor_ascii(USBHandler usbHandler, byte desc_index) {
        byte[] buffer = new byte[256];
        int r = this.getString_descriptor(usbHandler, (byte)0, (short)0, buffer, 256);
        if (r < 4) {
            LogHelper.e("getUsbdescriptor_ascii failed, ret:" + r);
            return "";
        }
        int langid = buffer[2] | buffer[3] << 8;
        r = this.getString_descriptor(usbHandler, desc_index, (short)langid, buffer, 256);
        if (r < 0) {
            LogHelper.e("getUsbdescriptor_ascii2 failed, ret:" + r);
            return "";
        }
        if (buffer[1] != 3) {
            LogHelper.e("getUsbdescriptor_ascii2 failed, no string");
            return "";
        }
        if (buffer[0] > r) {
            LogHelper.e("getUsbdescriptor_ascii2 failed, invalid length");
            return "";
        }
        int di = 0;
        int si = 0;
        byte[] data = new byte[128];
        di = 0;
        for (si = 2; si < buffer[0] && di < 127; si += 2) {
            data[di++] = buffer[si + 1] != 0 ? 63 : buffer[si];
        }
        LogHelper.i("getUsbdescriptor_ascii2 data length:" + di);
        return new String(data, 0, di);
    }

    public USBTransportDevice(Context context) {
        super(context);
    }

    @Override
    public int init() throws USBTransportException {
        if (null == this.context && null == (this.context = ToolUtils.getApplicationContext())) {
            throw USBTransportException.initUSBDeviceFailed();
        }
        this.usbHandlerList.clear();
        this.filterUSBDeviceList.clear();
        this.filterUSBDevice();
        int usbCount = this.countValidDevice();
        if (usbCount > 0) {
            LogHelper.i("found " + usbCount + " devices");
            return usbCount;
        }
        throw USBTransportException.initUSBDeviceFailed();
    }

    @Override
    public void open(Object object) throws BiometricTransportException {
        UsbDevice usbDevice = (UsbDevice)object;
        if (null == usbDevice) {
            throw USBTransportException.openInvaliedUSBDevice();
        }
        if (!this.startUSBHandler(-1, usbDevice)) {
            throw USBTransportException.openUSBDeviceFailed();
        }
    }

    private void filterUSBDevice() {
        Map<String, UsbDevice> usbDeviceList = USBHandler.getUSBDeviceList(this.context);
        this.mFilterVendorID = (Integer)this.parameters.get("param.key.vid");
        this.mFilterProductID = (Integer)this.parameters.get("param.key.pid");
        for (UsbDevice device : usbDeviceList.values()) {
            int vid = device.getVendorId();
            int pid = device.getProductId();
            if (vid == this.mFilterVendorID && pid == this.mFilterProductID) {
                this.filterUSBDeviceList.add(device);
                LogHelper.w("This usb device confirms with specific [VID=" + this.mFilterVendorID + ", PID=" + this.mFilterProductID + "]\nDevice info: " + device.toString());
                continue;
            }
            LogHelper.w("Those usb device don't confirm with specific [VID=" + this.mFilterVendorID + ", PID=" + this.mFilterProductID + "]\nDevice info: " + device.toString());
        }
    }

    public int countValidDevice() {
        return this.filterUSBDeviceList.size();
    }

    @Override
    public void open(int index) throws USBTransportException {
        if (index >= this.countValidDevice()) {
            LogHelper.e("Invalid usb device " + index + " !");
            throw USBTransportException.openInvaliedUSBDevice();
        }
        if (!this.startUSBHandler(index, null)) {
            throw USBTransportException.openUSBDeviceFailed();
        }
    }

    private boolean startUSBHandler(int index, UsbDevice device) {
        String name;
        int i;
        UsbDeviceConnection usbDeviceConnection;
        UsbDevice usbDevice = null;
        usbDevice = device != null ? device : this.filterUSBDeviceList.get(index);
        if (null == usbDevice) {
            LogHelper.e("invalid device!");
            return false;
        }
        this.mDeviceName = "";
        if (!USBHandler.getUsbManager(this.context).hasPermission(usbDevice)) {
            LogHelper.e("device no permission");
        }
        if ((usbDeviceConnection = USBHandler.getUsbManager(this.context).openDevice(usbDevice)) == null) {
            LogHelper.e("Open usb device " + index + " failed because of USBDeviceConnection is null!");
            return false;
        }
        USBHandler usbHandler = new USBHandler(this.context);
        if (0 >= usbDevice.getInterfaceCount()) {
            LogHelper.e("Opening device " + index + " failed because of getInterfaceCount <= 0!");
            return false;
        }
        if (ToolUtils.isNIDFPSensor(this.mFilterVendorID, this.mFilterProductID)) {
            int interfaceCount = usbDevice.getInterfaceCount();
            for (i = 0; i < interfaceCount; ++i) {
                UsbInterface usbInterface = usbDevice.getInterface(i);
                LogHelper.i("found usb interface: " + usbInterface);
                if (usbInterface.getInterfaceClass() != 8 || usbInterface.getInterfaceSubclass() != 6 || usbInterface.getInterfaceProtocol() != 80) {
                    LogHelper.w("device interface not suitable!");
                    continue;
                }
                int endpointCount = usbInterface.getEndpointCount();
                if (endpointCount != 2) {
                    LogHelper.w("inteface endpoint count != 2");
                }
                for (int j = 0; j < endpointCount; ++j) {
                    UsbEndpoint endpoint = usbInterface.getEndpoint(j);
                    if (endpoint.getType() != 2) continue;
                    if (endpoint.getDirection() == 0) {
                        usbHandler.setOutEndpoint(endpoint);
                        continue;
                    }
                    usbHandler.setInEndpoint(endpoint);
                }
                this.mUsbInterface = usbInterface;
            }
        } else {
            UsbInterface usbInterface = usbDevice.getInterface(0);
            for (i = 0; i < usbInterface.getEndpointCount(); ++i) {
                UsbEndpoint endpoint = usbInterface.getEndpoint(i);
                if (endpoint.getAttributes() != 2) continue;
                if (endpoint.getDirection() == 128) {
                    usbHandler.setInEndpoint(endpoint);
                    continue;
                }
                if (endpoint.getDirection() != 0) continue;
                usbHandler.setOutEndpoint(endpoint);
            }
            this.mUsbInterface = usbInterface;
        }
        LogHelper.i("inEndpoint=" + usbHandler.getInEndpoint());
        LogHelper.i("outEndpoint=" + usbHandler.getOutEndpoint());
        if (usbHandler.getInEndpoint() == null) {
            LogHelper.e("Opening device " + index + " failed because of start USBHandler failed!");
            return false;
        }
        usbDeviceConnection.claimInterface(this.mUsbInterface, true);
        usbHandler.setUsbDeviceConnection(usbDeviceConnection);
        usbHandler.setUsbInterface(this.mUsbInterface);
        USBHandler.setCurrentDeviceIndex(this.mCurIndex);
        usbHandler.setUsbConnectionConfig(usbDevice.getVendorId(), usbDevice.getProductId(), usbDeviceConnection.getFileDescriptor(), usbHandler.getInEndpoint() == null ? 0 : usbHandler.getInEndpoint().getAddress(), usbHandler.getOutEndpoint() == null ? 0 : usbHandler.getOutEndpoint().getAddress());
        this.mDeviceName = name = usbDevice.getDeviceName();
        this.mZKUSBHOSTAPISerivce.setDeviceName(this.mDeviceName);
        String[] v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
        int busnum = 0;
        int devnum = 0;
        if (v != null && v.length >= 2) {
            busnum = Integer.parseInt(v[v.length - 2]);
            devnum = Integer.parseInt(v[v.length - 1]);
        }
        this.mZKUSBHOSTAPISerivce.setUSBInfo(usbDevice.getVendorId(), usbDevice.getProductId(), usbDeviceConnection.getFileDescriptor(), busnum, devnum);
        LogHelper.i("Open usb device " + index + " OK");
        this.mZKUSBHOSTAPISerivce.setInEndpoint(usbHandler.getInEndpoint());
        this.mZKUSBHOSTAPISerivce.setOutEndpoint(usbHandler.getOutEndpoint());
        this.mZKUSBHOSTAPISerivce.setUSBDevConn(usbDeviceConnection);
        this.usbHandlerList.add(this.mCurIndex, usbHandler);
        String strSerialNumber = "";
        if (usbDevice.getVendorId() != 1024 || usbDevice.getProductId() != 50010) {
            strSerialNumber = this.getUsbdescriptor_ascii(usbHandler, (byte)3);
        }
        usbHandler.setStrSerialNumber(strSerialNumber);
        return true;
    }

    @Override
    public void control(int index, byte[] buffer, int length, int timeout) throws USBTransportException {
        LogHelper.d("Start control USB device " + index);
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(this.mCurIndex)) {
            throw USBTransportException.operateInvalidUSBDevice();
        }
        if (!this.isValidBufferLength(buffer, length)) {
            throw USBTransportException.invalidBufferLength();
        }
        if (buffer != null && buffer.length > 0) {
            ToolUtils.outputHexString(buffer, 0, length);
        }
        long nTickStart = System.currentTimeMillis();
        int ret = 0;
        while (Math.abs(System.currentTimeMillis() - nTickStart) < (long)timeout && (ret = this.usbHandlerList.get(this.mCurIndex).control(buffer, length, timeout)) < 0 && this.mbCtlRetry) {
            LogHelper.e("device name:" + this.mDeviceName + ",control fail, ret: " + ret);
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (ret < 0) {
            LogHelper.e("Control USB device \uff0c deviceName:" + this.mDeviceName + "," + index + " failed!\nAndroid UsbDeviceConnection return ret is" + ret);
            throw USBTransportException.controlUSBDeviceFailed(ret);
        }
    }

    public void control(byte[] buffer, int length, int timeout) throws USBTransportException {
        this.control(USBHandler.getCurrentDeviceIndex(), buffer, length, timeout);
    }

    @Override
    public void controlEx(int index, int requestType, int request, int value, int addr, byte[] buffer, int length, int timeout) throws USBTransportException {
        LogHelper.d("Start control USB device Extension" + index + ", request=" + request + ",value=" + value + ",addr=" + addr);
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(this.mCurIndex)) {
            throw USBTransportException.operateInvalidUSBDevice();
        }
        if (!this.isValidBufferLength(buffer, length)) {
            throw USBTransportException.invalidBufferLength();
        }
        if (buffer != null && buffer.length > 0) {
            ToolUtils.outputHexString(buffer);
        }
        int ret = 0;
        long nTickStart = System.currentTimeMillis();
        while (Math.abs(System.currentTimeMillis() - nTickStart) < (long)timeout && (ret = this.usbHandlerList.get(this.mCurIndex).control(requestType, request, value, addr, buffer, length, timeout)) < 0 && this.mbCtlRetry) {
            LogHelper.e("device name:" + this.mDeviceName + ",control fail, ret: " + ret);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (ret < 0) {
            LogHelper.e("Control USB device\uff0c deviceName:" + this.mDeviceName + "," + index + " failed!\nAndroid UsbDeviceConnection return ret is" + ret);
            throw USBTransportException.controlUSBDeviceFailed(ret);
        }
    }

    public void controlEx(int requestType, int request, int value, int addr, byte[] buffer, int length, int timeout) throws USBTransportException {
        this.controlEx(USBHandler.getCurrentDeviceIndex(), requestType, request, value, addr, buffer, length, timeout);
    }

    private boolean isValidBufferLength(byte[] buffer, int length) throws USBTransportException {
        if (null != buffer && buffer.length < length) {
            LogHelper.e("Buffer length is less than specified length!");
            return false;
        }
        return true;
    }

    @Override
    public int read(int index, byte[] buffer, int length, int timeout) throws USBTransportException {
        LogHelper.d("Start read USB device " + index + ",length=" + length);
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(this.mCurIndex)) {
            throw USBTransportException.operateInvalidUSBDevice();
        }
        int ret = 0;
        if (!this.isValidBufferLength(buffer, length)) {
            throw USBTransportException.invalidBufferLength();
        }
        long tickStart = System.currentTimeMillis();
        while ((ret = this.usbHandlerList.get(this.mCurIndex).read(buffer, length, timeout)) <= 0 && Math.abs(System.currentTimeMillis() - tickStart) < (long)timeout) {
            ToolUtils.sleep(10);
        }
        if (ret == -1) {
            LogHelper.w("Read USB device " + index + " timout!");
            return 0;
        }
        if (ret <= 0) {
            LogHelper.e("Read USB device " + index + " failed!Android UsbDeviceConnection return ret is " + ret);
            return 0;
        }
        ToolUtils.outputHexString(buffer, 0, ret);
        return ret;
    }

    public int read(byte[] buffer, int length, int timeout) throws USBTransportException {
        return this.read(USBHandler.getCurrentDeviceIndex(), buffer, length, timeout);
    }

    @Override
    public void write(int index, byte[] buffer, int length, int timeout) throws USBTransportException {
        LogHelper.d("Start write USB device " + index);
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(this.mCurIndex)) {
            throw USBTransportException.operateInvalidUSBDevice();
        }
        if (!this.isValidBufferLength(buffer, length)) {
            throw USBTransportException.invalidBufferLength();
        }
        ToolUtils.outputHexString(buffer, 0, length);
        int ret = this.usbHandlerList.get(this.mCurIndex).write(buffer, length, timeout);
        if (ret <= 0) {
            LogHelper.e("DeviceName:" + this.mDeviceName + ",Write USB device " + index + " failed!\nAndroid UsbDeviceConnection return ret is " + ret);
            throw USBTransportException.writeUSBDeviceFailed(ret);
        }
    }

    public void write(byte[] buffer, int length, int timeout) throws USBTransportException {
        this.write(USBHandler.getCurrentDeviceIndex(), buffer, length, timeout);
    }

    @Override
    public void close(int index) throws USBTransportException {
        if (this.usbHandlerList.size() > 0) {
            try {
                this.usbHandlerList.get(this.mCurIndex).close();
            }
            catch (IndexOutOfBoundsException e) {
                LogHelper.e("Invalid index to close! Your invalid index is " + index);
                throw USBTransportException.closeUSBTransportException(-9);
            }
        } else {
            LogHelper.w("No any working USB device, don't need to close");
        }
    }

    @Override
    public void free(int index) throws USBTransportException {
        if (this.usbHandlerList.size() > 0) {
            try {
                this.usbHandlerList.remove(this.usbHandlerList);
            }
            catch (IndexOutOfBoundsException e) {
                LogHelper.e("Invalid index to free! Your invalid index is " + index);
                throw USBTransportException.freeUSBDeviceFailed(-10);
            }
        } else {
            LogHelper.w("No any working USB device, don't need to free");
        }
    }

    @Override
    public void destroy() {
        if (this.usbHandlerList.size() > 0) {
            for (USBHandler usbHandler : this.usbHandlerList) {
                if (null == usbHandler) continue;
                usbHandler.close();
            }
            this.usbHandlerList.clear();
        }
        USBHandler.reset();
        this.filterUSBDeviceList.clear();
        this.parameters = null;
        this.context = null;
        this.mZKUSBHOSTAPISerivce = null;
    }

    @Override
    public TransportType getType() {
        return TransportType.USB;
    }

    @Override
    public boolean isConnectExcepted() {
        return this.mbConnectExcept;
    }

    @Override
    public Object getConnectionService() {
        return this.mZKUSBHOSTAPISerivce;
    }

    @Override
    public void setCtlRetryFlag(boolean bFlag) {
        this.mbCtlRetry = bFlag;
    }

    @Override
    public String getSerialNumber(int index) {
        if (this.usbHandlerList.size() > 0) {
            return this.usbHandlerList.get(this.mCurIndex).getStrSerialNumber();
        }
        return "";
    }

    private int Uart_Control_Out(UsbDeviceConnection connection, int request, int value, int index) {
        int retval = 0;
        retval = connection.controlTransfer(64, request, value, index, null, 0, this.DEFAULT_TIMEOUT);
        return retval;
    }

    private int Uart_Control_In(UsbDeviceConnection connection, int request, int value, int index, byte[] buffer, int length) {
        int retval = 0;
        retval = connection.controlTransfer(192, request, value, index, buffer, length, this.DEFAULT_TIMEOUT);
        return retval;
    }

    private int Uart_Set_Handshake(UsbDeviceConnection connection, int control) {
        return this.Uart_Control_Out(connection, 164, ~control, 0);
    }

    private int Uart_Tiocmset(UsbDeviceConnection connection, int set, int clear) {
        int control = 0;
        if ((set & 4) == 4) {
            control |= 0x40;
        }
        if ((set & 2) == 2) {
            control |= 0x20;
        }
        if ((clear & 4) == 4) {
            control &= 0xFFFFFFBF;
        }
        if ((clear & 2) == 2) {
            control &= 0xFFFFFFDF;
        }
        return this.Uart_Set_Handshake(connection, control);
    }

    private boolean SetConfig(UsbDeviceConnection connection, int baudRate, byte dataBit, byte stopBit, byte parity, byte flowControl) {
        int value = 0;
        int index = 0;
        int valueHigh = 0;
        int valueLow = 0;
        int indexHigh = 0;
        int indexLow = 0;
        switch (parity) {
            case 0: {
                valueHigh = 0;
                break;
            }
            case 1: {
                valueHigh = (char)(valueHigh | 8);
                break;
            }
            case 2: {
                valueHigh = (char)(valueHigh | 0x18);
                break;
            }
            case 3: {
                valueHigh = (char)(valueHigh | 0x28);
                break;
            }
            case 4: {
                valueHigh = (char)(valueHigh | 0x38);
                break;
            }
            default: {
                valueHigh = 0;
            }
        }
        if (stopBit == 2) {
            valueHigh = (char)(valueHigh | 4);
        }
        switch (dataBit) {
            case 5: {
                valueHigh = (char)(valueHigh | 0);
                break;
            }
            case 6: {
                valueHigh = (char)(valueHigh | 1);
                break;
            }
            case 7: {
                valueHigh = (char)(valueHigh | 2);
                break;
            }
            case 8: {
                valueHigh = (char)(valueHigh | 3);
                break;
            }
            default: {
                valueHigh = (char)(valueHigh | 3);
            }
        }
        valueHigh = (char)(valueHigh | 0xC0);
        valueLow = 156;
        value |= valueLow;
        value |= valueHigh << 8;
        switch (baudRate) {
            case 50: {
                indexLow = 0;
                indexHigh = 22;
                break;
            }
            case 75: {
                indexLow = 0;
                indexHigh = 100;
                break;
            }
            case 110: {
                indexLow = 0;
                indexHigh = 150;
                break;
            }
            case 135: {
                indexLow = 0;
                indexHigh = 169;
                break;
            }
            case 150: {
                indexLow = 0;
                indexHigh = 178;
                break;
            }
            case 300: {
                indexLow = 0;
                indexHigh = 217;
                break;
            }
            case 600: {
                indexLow = 1;
                indexHigh = 100;
                break;
            }
            case 1200: {
                indexLow = 1;
                indexHigh = 178;
                break;
            }
            case 1800: {
                indexLow = 1;
                indexHigh = 204;
                break;
            }
            case 2400: {
                indexLow = 1;
                indexHigh = 217;
                break;
            }
            case 4800: {
                indexLow = 2;
                indexHigh = 100;
                break;
            }
            case 9600: {
                indexLow = 2;
                indexHigh = 178;
                break;
            }
            case 19200: {
                indexLow = 2;
                indexHigh = 217;
                break;
            }
            case 38400: {
                indexLow = 3;
                indexHigh = 100;
                break;
            }
            case 57600: {
                indexLow = 3;
                indexHigh = 152;
                break;
            }
            case 115200: {
                indexLow = 3;
                indexHigh = 204;
                break;
            }
            case 230400: {
                indexLow = 3;
                indexHigh = 230;
                break;
            }
            case 460800: {
                indexLow = 3;
                indexHigh = 243;
                break;
            }
            case 500000: {
                indexLow = 3;
                indexHigh = 244;
                break;
            }
            case 921600: {
                indexLow = 7;
                indexHigh = 243;
                break;
            }
            case 1000000: {
                indexLow = 3;
                indexHigh = 250;
                break;
            }
            case 2000000: {
                indexLow = 3;
                indexHigh = 253;
                break;
            }
            case 3000000: {
                indexLow = 3;
                indexHigh = 254;
                break;
            }
            default: {
                indexLow = 2;
                indexHigh = 178;
            }
        }
        index |= 0x88 | indexLow;
        this.Uart_Control_Out(connection, 161, value, index |= indexHigh << 8);
        if (flowControl == 1) {
            this.Uart_Tiocmset(connection, 6, 0);
        }
        return true;
    }

    @Override
    public boolean SetConfigUsb(int index, int paramInt) {
        if (0 == index) {
            UsbDeviceConnection usbDeviceConnection = this.usbHandlerList.get(this.mCurIndex).getUsbDeviceConnection();
            byte[] arrayOfByte = new byte[8];
            int size = 8;
            byte[] buffer = new byte[size];
            this.Uart_Control_Out(usbDeviceConnection, 161, 0, 0);
            int ret = this.Uart_Control_In(usbDeviceConnection, 95, 0, 0, buffer, 2);
            if (ret < 0) {
                return false;
            }
            this.Uart_Control_Out(usbDeviceConnection, 154, 4882, 55682);
            this.Uart_Control_Out(usbDeviceConnection, 154, 3884, 4);
            ret = this.Uart_Control_In(usbDeviceConnection, 149, 9496, 0, buffer, 2);
            if (ret < 0) {
                return false;
            }
            this.Uart_Control_Out(usbDeviceConnection, 154, 10023, 0);
            this.Uart_Control_Out(usbDeviceConnection, 164, 255, 0);
            this.SetConfig(usbDeviceConnection, paramInt, (byte)8, (byte)1, (byte)0, (byte)0);
            return true;
        }
        return false;
    }

    @Override
    public void getUsbConnectionConfig(int index, int[] vid, int[] pid, int[] fd, int[] inPoint, int[] outPoint) {
        if (this.usbHandlerList.size() > 0) {
            try {
                this.usbHandlerList.get(this.mCurIndex).getUsbConnectionConfig(vid, pid, fd, inPoint, outPoint);
            }
            catch (IndexOutOfBoundsException e) {
                LogHelper.e("Invalid index to close! Your invalid index is " + index);
            }
        } else {
            LogHelper.w("No any working USB device, don't need to close");
        }
    }

    @Override
    public void reset(int index) throws USBTransportException {
        ZKUSBDeviceCtl.resetDevice(this.mZKUSBHOSTAPISerivce.getVendorID(), this.mZKUSBHOSTAPISerivce.getProductID(), this.mZKUSBHOSTAPISerivce.getFD(), this.mZKUSBHOSTAPISerivce.getBusNum(), this.mZKUSBHOSTAPISerivce.getDevAddr(), this.mZKUSBHOSTAPISerivce.getInEndPointAddr(), this.mZKUSBHOSTAPISerivce.getOutEndPointAddr());
    }

    @Override
    public void reset2(int index) throws BiometricTransportException {
    }

    @Override
    public int getUSBProductID() {
        return this.mFilterProductID;
    }

    @Override
    public int getUSBVendorID() {
        return this.mFilterVendorID;
    }
}

